/*
 * 6502 disassembler
 */

#include <stdio.h>
#include <string.h>
#include "disasm.h"

int start;

extern FILE *optin;
extern void optparse (void);

int main (int argc, char *argv[])
{
	FILE *f;
	unsigned char buffer[0x4000];
	int length;
	
	if (argc < 3)
	{
		printf ("Usage: %s file options-file [ start [ base ] ]\n", argv[0]);
		exit (1);
	}
	
	f = fopen (argv[1], "r");
	fread (buffer, 0x4000, 1, f);
	fseek (f, 0, SEEK_END);
	length = ftell (f);
	fclose (f);
	
	f = fopen (argv[2], "r");
	optin = f;
	optparse ();
	fclose (f);
	
	if (argc >= 4)
	{
		start = strtoul (argv[3], NULL, 0);
		printf ("start = %x\n", start);
	}
	if (argc >= 5)
	{
		base_addr = strtoul (argv[4], NULL, 0);
		printf ("base = %x\n", base_addr); 
	}
	
	do_disasm (start, length, buffer);
}

char *find_symbol (int addr, int type)
{
	struct symbol *s;
	
	for (s = first_sym; s != NULL; s = s->next)
		if (s->addr == addr && ((s->type & type) == type))
			return s->name;
	return hex (addr);
}

char *hex (int addr)
{
	static char buf[256];
	
	if (addr < 0x100)
		sprintf (buf, "&%02x", addr);
	else
		sprintf (buf, "&%04x", addr);
	return buf;
}

/* End of file. */
