/*
 * Implementation of a linked list with deduping
 */

#ifndef ULIST_H
#define ULIST_H

#include "list.h"

template<class Cls>
class UList: protected List<Cls>
{
protected:
	

public:
	UList<Cls> (void): List<Cls> () {}
	inline ListElem<Cls> *Add (Cls *c);
	ListElem<Cls> *Add (Cls c) { return Add (&c); }
	void Remove (Cls *c) { RemoveFirst (c); }
	void Remove (Cls c) { RemoveFirst (&c); }
	ListElem<Cls> *find (Cls *c) { return findFirst (c); }
	ListElem<Cls> *getFirst (void) { return first; }
};

template<class Cls>
ListElem<Cls> *UList<Cls>::Add (Cls *c)
{
	ListElem<Cls> *e;
	
	if ((e = find (c)))
		return e;
	else
		return Append (c);
}

#endif /* ULIST_H */

/* End of file. */
