/*
 * Model B emulation
 */

#ifndef MODELB_H
#define MODELB_H

#include "CompEmul.h"
#include "VIA6522.h"
#include "MemEmul.h"

#define SYSVIA ModelBSysVIA
#include "StdSysVIA.h"
#undef SYSVIA

#ifndef MODELA
#define USRVIA ModelBUsrVIA
#include "StdUsrVIA.h"
#undef USRVIA
#endif

class ACIA;
class ModelBEmul;

class ModelBMem: public MemEmul
{
protected:
	ModelBSysVIA *sysVIA;
#ifndef MODELA
	ModelBUsrVIA *usrVIA;
#endif
	ACIA *acia;
	
	ModelBEmul *parent;
	
	friend class ModelBEmul;

public:
	ModelBMem (ModelBEmul *p);
	virtual ~ModelBMem (void);
	
	inline void Write (int addr, byte val);
	inline void RenderDisplay (void);
};

class ModelBEmul: public CompEmul
{
protected:
	

public:
	ModelBEmul (void);
	virtual ~ModelBEmul (void);
	
	virtual void ExecThread (void);
};

void ModelBMem::Write (int addr, byte val)
{
	if (addr == 0xfe30)
	{
		Switch_SWbank (val & 0xf);
		return;
	}
#ifndef MODELA
	MemEmul::Write (addr, val);
#else
	if (addr < 0x8000)
	{
		coremem[addr & 0x3fff] = coremem[(addr & 0x3fff) | 0x4000]
			= val;
	}
	else
		OtherWrite (addr, val);
#endif
}

#endif /* MODELB_H */

/* End of file. */
