/*
 * ByteFIFO class
 * Provides a variable-length FIFO of bytes.
 * (used by AcornTUBE etc.)
 */

#include "ByteFIFO.h"

ByteFIFO::ByteFIFO (int size)
{
	data = new byte[size];
	len = size;
	first = last = 0;
}

ByteFIFO::~ByteFIFO (void)
{
	delete data;
}

byte ByteFIFO::Read (void)
{
	byte d;
	
	d = data[first];
	first++;
	if (first == len) first = 0;
	return d;
}

void ByteFIFO::Write (byte val)
{
	data[last] = val;
	last++;
	if (last == len) last = 0;
}

int ByteFIFO::Empty (void) const
{
	if (first == last)
		return 1;
	else
		return 0;
}

int ByteFIFO::Full (void) const
{
	if ((first == (last + 1)) || (first == 0 && last == (len - 1)))
		return 1;
	else
		return 0;
}

void ByteFIFO::Reset (void)
{
	first = last = 0;	
}

/* End of file. */
