/**************************************************************************/
/*                                                                        */
/*            em6502 - An X Based 6502 Emulator & Teaching Aid            */
/*            ------------------------------------------------            */
/*              (c) Neil Pollard, University of Bristol 1994              */
/*                                                                        */
/*            Please read the file README for more information            */
/*                                                                        */
/**************************************************************************/
/* textbox.c */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <stdio.h>
#include "window.h"
#include "textbox.h"

/* This set of routines deal with 'text boxes'. A text box is a value 
 * printed in a window which can be selected and altered.
 * These routines are not complete, two more specific functions have been
 * left in monitor.c until they can be made more general.
 *
 * Some global variables and some definitions are stored in
 * "textbox.h" */

/*======================================================================*/
/* Open a text box for editing */

void open_text_box(win, gc, box_number)
Window win;
GC gc;
{
int counter;

/* Draw a rectangle around the existing text */
XDrawRectangle(display, win, gc, text_box_x[box_number]-5,
         text_box_y[box_number]-15, (TB_LETTERS*9)+9, 20);

/* Reset the current character position to zero */
text_box_pos[box_number]=0;

/* Clear any existing contents of the text box */
for (counter = 0; counter < TB_LETTERS; counter++)
        text_box_string[box_number][counter] = 0;

}
/*======================================================================*/
/* Add a charcter to a text box */

void add_char(win, gc, box_number, letter)
Window win;
GC gc;
int box_number;
char letter;
{
int x,y;

/* If the box is not full... */
if (text_box_pos[box_number] < TB_LETTERS)
        {
        x = text_box_x[box_number];
        y = text_box_y[box_number];

	/* add the character */
        text_box_string[box_number][text_box_pos[box_number]++]=letter;

	/* update the box on screen */
        XClearArea(display, win, x-4, y-14, (9*TB_LETTERS)+7, 18, 0);
        XDrawString(display, win, gc, x, y, text_box_string[box_number], TB_LETTERS);
        }
}
/*======================================================================*/
/* Delete a character from a text box */
void del_char(win, gc, box_number)

Window win;
GC gc;
int box_number;
{
int x,y;

/* If the box is not empty, delete the charcter */
if (text_box_pos[box_number])
	{
        text_box_pos[box_number]--;
	text_box_string[box_number][text_box_pos[box_number]]=0;
	}

x = text_box_x[box_number];
y = text_box_y[box_number];

/* Redraw the text box on screen */
XClearArea(display, win, x-4, y-14, (9*TB_LETTERS)+7, 18, 0);
XDrawString(display, win, gc, x, y, text_box_string[box_number], TB_LETTERS);

}
/*======================================================================*/
/* Function to convert a string containing a hexadecimal number into
 * an integer.
 * This was written because the library function sscanf 
 * does not seem to work in all cases. */

int hexstring_to_int(char *string, int length)
{
int counter, digit;
int value = 0;

for (counter = 0; counter < length; counter++)
        {
        digit = (*(string+counter)) - '0';

        if (digit > 16)
                digit -= 7;

        value = (value*16)+digit;
        }

return (value);
}
/*======================================================================*/
/* TO DO:
 *
 * Provide general close_text_box and print_text_box routines.
 */ 
