/*
 *mega2.c -- Apple ][ soft switches->UNIX emulation for Apple ][ Emulator
 *(C) 1989 Ben Koning [556498717 408/738-1763 ben@apple.com]
 */

#include "apple.h"

/*
 * Emulation globals:
 */

BYTE MMemory [0x8000];     /* Main RAM memory                         */
BYTE Rom [0x8000];         /* 32K ROM bank of Main memory         */

BYTE MegaQuitDetect = 0;  /* Set if user requests to quit        */


#define MegaPutChar(c) addch(c)

/**************************************************************************/
/* Dispatch routines: The MegaPutMem and MegaGetMem, below, have default  */
/* behavior for I/O space.  They may also contain calls to other routines */
/* in this file which handle Apple II behavior.  If these latter routines */
/* need initialization/shutdown, that code should be placed in the two    */
/* MegaStartUp and MegaShutDown routines, below.                          */
/**************************************************************************/

/* This routine is called at emulation startup time.  All initialization
   stuff, like setting terminal modes, opening files, etc. goes here. */
void MegaStartUp ()
{
  
  /* Initialize some variables: */
  MegaQuitDetect = 0;
}



/* This routine is called at emulation shutdown time.  All things
   started in MegaStartUp, above, should be cleaned up here. */
void MegaShutDown ()
{
}

/* This routine handles ALL stores to the 64K address space, in order to
   faciliate special Apple ][ - specific effects.  Not all behaviors may
   be implemented; to install a new one, install the call in this routine.
   Returns: Nothing. */
void MegaPutMem (addr, byte)
register ADDR addr;
register BYTE byte;
{
  /* Make sure these are in range: */
  addr &= 0xffff;
  byte &= 0xff;

  /* If in ROM, we are done here: */
  if (addr >= 0x8000)
    return;

  if (addr < 0x8000)                               /* Main memory   */
    MMemory [addr] = byte;
}


/* This routine handles ALL fetches from the 64K address space, in order to
   facilitate special Apple ][ - specific effects.  Not all behaviors may
   be implemented; to install a new one, install the call in this routine.
   Returns: Value at location (could be random if I/O, etc.). */
BYTE MegaGetMem (addr)
register ADDR addr;
{
  register BYTE data;   /* Data from memory space to be returned */

  /* Make sure we're in range: */
  addr &= 0xffff;

  /* If we're just in ROM or RAM, it's easy: */
  if (addr < 0x8000) 
    return (MMemory [addr]);
  else if (addr >= 0x8000 )             /* rom read enabled */
    return (Rom[addr - 0x8000]);
  
}

#define DOERROR(ERVAL,STRING) {	int i; \
				MegaPutMem(0x100,0);\
				MegaPutMem(0x101,ERVAL);\
				for(i=0;i<strlen(STRING);i++)\
				    MegaPutMem(0x102+i,STRING[i]);\
				MegaPutMem(0x102+i,0);\
				PPC=0x100;\
				}
os(value)
BYTE value;
{
switch (value)
{ 
case 0xDD: OsFile(); break;
case 0x1E: OsFsc(); break;
case 0xEE: OsWrch(); break;
case 0xE0: OsRdch(); break;
case 0xF4: OsByte(); break;
case 0xF1: OsWord(); break;
case 0xFE: Interupt(1); break;
case 0xFF: Interupt(2); break;
default: MegaQuitDetect=1;
	 fprintf(stderr,"Unknown OS call %x\n",value);
	 break;
}
return 0;
}

OsWrch()
{
if(A==12)
	fprintf(stderr,"\f");
else
	fprintf(stderr,"%c",A);
}

OsRdch()
{
A=getchar();
}

OsByte()
{
if (A>=166) 
	{

	}

else
	switch (A)
	{
	case 0x00: puts("OS1.2(ish)");
	case 0x7E: X=0xFF; MegaPutMem (0xFF, 0); break;
	case 0x82: X=0; Y=0x08; break;
	case 0x83: X=0; Y=0x08; break;
	case 0x84: X=0; Y=0x80; break;
	default: fprintf(stderr,"Unknown OSBYTE call %d\n",(int)A);
	    MegaQuitDetect=1;
	    break;
	};

return 0;
}

OsWord()
{
switch (A)
{
case 0: Osword_0(); break;
default: fprintf(stderr,"Unknown OSWORD call %x\n",A);
	MegaQuitDetect=1;
	break;
}
return 0;
}

Osword_0()
{
int block;
int strstart;
int strl;
char temp[256];

block=X+Y*256;
strstart= MegaGetMem(block)+MegaGetMem(block+1)*0x100;

gets(temp);
for(strl=0;temp[strl]!=0; strl++)
    MegaPutMem(strstart+strl,temp[strl]);
strl=strlen((char *)temp);
Y=strl; /* +1*/
P &= ~0x01;
MegaPutMem(strstart+strl,0x0D);
}

OsFile()
{
int block;
int FnAdr;
int LoAdr;
int ExAdr;
int StAdr;
int EnAdr;
char string[256];
int i;
char ch;
int fp;


block=X+Y*256;
   
FnAdr=MegaGetMem(block+0x00)+MegaGetMem(block+0x01)*0x100;
while(MegaGetMem(FnAdr)==' ' || MegaGetMem(FnAdr)=='\"')
    FnAdr++;	
for(i=0;i<256 && MegaGetMem(FnAdr+i)!=0x0D && MegaGetMem(FnAdr+i)!=' ' && MegaGetMem(FnAdr+i)!='\"' ;i++)
    string[i]=MegaGetMem(FnAdr+i);
string[i]=0;

LoAdr=MegaGetMem(block+0x02)+MegaGetMem(block+0x03)*0x100;
ExAdr=MegaGetMem(block+0x06)+MegaGetMem(block+0x07)*0x100;
StAdr=MegaGetMem(block+0x0A)+MegaGetMem(block+0x0B)*0x100;
EnAdr=MegaGetMem(block+0x0E)+MegaGetMem(block+0x0F)*0x100;
	

switch(A)
{
    case 0x00:
	    {
	    fp = open (string, O_WRONLY|O_CREAT,0600);
	    if(fp<=0)
		{
		DOERROR(0,"Cant open File");
		return;
		}
		
	    sprintf(string,"%x %x            ",LoAdr,ExAdr);
	    write(fp,string,12);
	    
	    for(i=StAdr;i<EnAdr;i++)
		{
		ch=MegaGetMem(i);
		write(fp,&ch,1);
		}
	    close(fp);
	    }
	    break;
    case 0xFF:
	    {
	    fp = open (string, O_RDONLY);
	    if(fp<=0)
		{
		DOERROR(0,"File Not Found");
		return;
		}

	    /* Get header Block */
	    read(fp,string,12);
	    if((ExAdr & 0xff)!=0)
		{
		sscanf(string,"%x %x",&LoAdr,&ExAdr);
		}
 
	    for (i = LoAdr;   i <= 0xffff && read(fp,&ch,1)==1; i++)
		MegaPutMem(i,ch);
	    (void)close (fp);
	    }
	    break;
default: fprintf(stderr,"Unknown OSFILE call %x\n",A);
	MegaQuitDetect=1;
	break;
}
return 0;
}

OsFsc()
{
switch(A)
    {
    case 3: DOERROR(254,"Bad Command");
	break;
    case 4:
	{ /* *RUN */
	int FnAdr;
	int LoAdr;
	int ExAdr;
	char ch;
	char string[256];
	int fp;
	int i;
	
	FnAdr=X+Y*256;
   
	while(MegaGetMem(FnAdr)==' ' || MegaGetMem(FnAdr)=='\"')
	    FnAdr++;	
	for(i=0;i<256 && MegaGetMem(FnAdr+i)!=0x0D && MegaGetMem(FnAdr+i)!=' ' && MegaGetMem(FnAdr+i)!='\"' ;i++)
	    string[i]=MegaGetMem(FnAdr+i);
	string[i]=0;
	
	fp = open (string, O_RDONLY);
	if(fp<=0)
	    {
	    DOERROR(0,"File Not Found");
	    return;
	    }

	/* Get header Block */
	read(fp,string,12);
	    sscanf(string,"%x %x",&LoAdr,&ExAdr);

	for (i = LoAdr;   i <= 0xffff && read(fp,&ch,1)==1; i++)
	    MegaPutMem(i,ch);
	(void)close (fp);
	PPC=ExAdr;
	return;
	}
    case 5:
    	{ /* Catalougue */
	int p[2];
	int pid;
	
	pipe(p);
	pid=fork();
	if(pid==0)
	    {
	    /* Child */
	    close(stdout);
	    dup2(p[1],1);
	    execl("/bin/ls","ls","-C",0);
	    puts("Failed");
	    exit(-1);
	    }
	else
	    {
	    char ch;
	    /* Parent */
	   
	    close(p[1]);
	    
	    while(read(p[0],&ch,1)!=0)
		{
		A=ch;
		OsWrch();
		}    
	    close(p[0]);
	    }
	return;
	}
    case 8: return;
    default:fprintf(stderr,"Unknown OSFSC call %x\n",A);
	MegaQuitDetect=1;
	break;
    }
}

Interupt(level)
int level;
{
if(level==1)
    {
    PPC=MegaGetMem(0x206)+MegaGetMem(0x207)*0x100;
    }
else if(level==2)
    {
    int Madder;
    Madder=_pull_ ();
    Madder+=_pull_ ()*0x100;
    _push_(Madder % 0x100);
    _push_(Madder & 0xff);
    
    Madder++;
    MegaPutMem(0xfd,Madder & 0xff);
    MegaPutMem(0xfe,Madder % 0x100);
    A=MegaGetMem(0xfc);
    PPC=MegaGetMem(0x202)+MegaGetMem(0x203)*0x100;
    }
}



