#include "pch.h"
#include "mbDiscFormat.h"
#include <algorithm>

struct DiscGeometry {
	const char *description;
	int sides,tracks,sectors;
	bool is_double_density;
	const char **exts;
};

const char *exts_ss_sd[]={
	"ssd","bbc","img",0,
};
const char *exts_ds_sd[]={
	"dsd",0,
};

const DiscGeometry geom_ss_sd={"Single sided single density",1,80,10,false,exts_ss_sd};
const DiscGeometry geom_ds_sd={"Double sided single density",2,80,10,false,exts_ds_sd};

const DiscGeometry *geometries[]={
	&geom_ss_sd,
	&geom_ds_sd,
	0,
};

static void Convert(const DiscGeometry *src,mbDiscFormat *dest) {
	dest->sides=src->sides;
	dest->tracks=src->tracks;
	dest->sectors=src->sectors;
	dest->description=src->description;
	dest->extensions.clear();
	for(unsigned i=0;src->exts[i];++i) {
		dest->extensions.push_back(src->exts[i]);
	}
}

bool mbDiscFormatGetFromFileName(const wxFileName &file_name,mbDiscFormat *fmt) {
	wxString file_name_ext=file_name.GetExt();
	
	for(unsigned i=0;geometries[i];++i) {
		for(unsigned j=0;geometries[i]->exts[j];++j) {
			if(file_name_ext.CmpNoCase(geometries[i]->exts[j])==0) {
				Convert(geometries[i],fmt);
				return true;
			}
		}
	}
	return false;
}

void mbDiscFormatGetAll(std::vector<mbDiscFormat> *all_fmts) {
	wxASSERT(all_fmts);
	all_fmts->clear();
	for(unsigned i=0;geometries[i];++i) {
		all_fmts->push_back(mbDiscFormat());
		Convert(geometries[i],&all_fmts->back());
	}
}

void mbDiscFormatGetAllExtensions(std::vector<wxString> *all_exts) {
	wxASSERT(all_exts);
	all_exts->clear();
	for(unsigned i=0;geometries[i];++i) {
		for(unsigned j=0;geometries[i]->exts[j];++j) {
			all_exts->push_back(geometries[i]->exts[j]);
			wxASSERT(wxString(geometries[i]->exts[j]).Lower()==geometries[i]->exts[j]);
		}
	}
	std::sort(all_exts->begin(),all_exts->end());
}
