#include "pch.h"
#include "mbConfig.h"
#include "mbKeymap.h"
#include "HostWin32.h"
#include "mbMisc.h"
#include "mbKeys.h"
#include <algorithm>
#include <iostream>
#include <sstream>

//TODO loading and saving keyboard configs should be in the same place. Currently
//save is here, and load is in mbKeyMap... doh...

//////////////////////////////////////////////////////////////////////////
static void LoadRect(mbWxConfig *cfg,const wxString &dir,wxRect *rect) {
	wxASSERT(rect);

	if(!cfg->Read(dir+"/x",&rect->x)||!cfg->Read(dir+"/y",&rect->y)||
		!cfg->Read(dir+"/width",&rect->width)||!cfg->Read(dir+"/height",&rect->height))
	{
		*rect=wxRect(-1,-1,-1,-1);
	}
}

static void SaveRect(mbWxConfig *cfg,const wxString &dir,const wxRect &rect) {
	cfg->Write(dir+"/x",rect.x);
	cfg->Write(dir+"/y",rect.y);
	cfg->Write(dir+"/width",rect.width);
	cfg->Write(dir+"/height",rect.height);
}

template<class T>
static void ClampValue(const char *name,T *value,const T &mini,const T &maxi) {
	T old_value=*value;
	if(*value<mini) {
		*value=mini;
	} else if(*value>maxi&&maxi>mini) {
		*value=maxi;
	}
	if(*value!=old_value) {
		std::ostringstream old_val,new_val;
		old_val<<old_value<<std::ends;
		new_val<<*value<<std::ends;
		wxLogWarning("%s: invalid value %s, set to %s",name,old_val.str().c_str(),
			new_val.str().c_str());
	}
}

//////////////////////////////////////////////////////////////////////////
//
mbRomsConfig::Rom::Rom():
ram(false)
{
}

mbRomsConfig::mbRomsConfig():
dlg_rect(-1,-1,-1,-1)
{
}

void mbRomsConfig::Load(mbWxConfig *cfg) {
	cfg->Read("/Roms/Os",&this->os_filename);
	for(int i=0;i<16;++i) {
		//this->roms[i].used=false;
		this->roms[i].ram=false;
		wxString key;
		key.Printf("/Roms/%d",i);
		wxString value;
		if(cfg->Read(key,&value)) {
			size_t comma=value.find_last_of(',');
			if(comma!=wxString::npos) {
				if(value.substr(comma).Lower()==",ram") {
					this->roms[i].ram=true;
				}
				value=value.substr(0,comma);
			}
			//this->roms[i].used=true;
			this->roms[i].filename=value;
		}
	}
	LoadRect(cfg,"/Roms/DialogRect",&this->dlg_rect);
}

void mbRomsConfig::Save(mbWxConfig *cfg)  const{
	cfg->Write("/Roms/Os",mbRelativeFileName(this->os_filename,"."));
	for(int i=0;i<16;++i) {
		wxString key;
		key.Printf("/Roms/%d",i);
		wxString value=mbRelativeFileName(this->roms[i].filename,".");
//		wxFileName file_name=wxFileName::FileName(this->roms[i].filename);
//		file_name.MakeRelativeTo(".");
//		value=file_name.GetFullPath();
		if(this->roms[i].ram) {
			value+=",ram";
		}
		cfg->Write(key,value);
	}
	SaveRect(cfg,"/Roms/DialogRect",this->dlg_rect);
}

//////////////////////////////////////////////////////////////////////////
//
mbSoundConfig::mbSoundConfig():
enabled(false),
hz(44100),
bits(2),
stereo(false),
len_frames(4),
dlg_rect(-1,-1,-1,-1),
volume(100)
{
	for(unsigned i=0;i<4;++i) {
		this->is_stereo_left[i]=true;
		this->is_stereo_right[i]=true;
	}
}

void mbSoundConfig::Load(mbWxConfig *cfg) {
	cfg->Read("/Sound/Enabled",&this->enabled);
	cfg->Read("/Sound/Hz",&this->hz);
	cfg->Read("/Sound/Bits",&this->bits);
	cfg->Read("/Sound/Stereo",&this->stereo);
	cfg->Read("/Sound/LenFrames",&this->len_frames);
	for(unsigned i=0;i<4;++i) {
		cfg->Read(wxString::Format("/Sound/Stereo/%uLeft",i),&this->is_stereo_left[i]);
		cfg->Read(wxString::Format("/Sound/Stereo/%uRight",i),&this->is_stereo_right[i]);
	}
	LoadRect(cfg,"/Sound/DialogRect",&this->dlg_rect);
	cfg->Read("/Sound/Volume",&this->volume);
}

void mbSoundConfig::Save(mbWxConfig *cfg)  const{
	cfg->Write("/Sound/Enabled",this->enabled);
	cfg->Write("/Sound/Hz",this->hz);
	cfg->Write("/Sound/Bits",this->bits);
	cfg->Write("/Sound/Stereo",this->stereo);
	cfg->Write("/Sound/LenFrames",this->len_frames);
	for(unsigned i=0;i<4;++i) {
		cfg->Write(wxString::Format("/Sound/Stereo/%uLeft",i),this->is_stereo_left[i]);
		cfg->Write(wxString::Format("/Sound/Stereo/%uRight",i),this->is_stereo_right[i]);
	}
	SaveRect(cfg,"/Sound/DialogRect",this->dlg_rect);
	cfg->Write("/Sound/Volume",this->volume);
}

//////////////////////////////////////////////////////////////////////////
//
mbKeyboardConfig::mbKeyboardConfig():
dlg_rect(-1,-1,-1,-1)
{
	std::fill(this->keylinks,this->keylinks+8,false);
}

void mbKeyboardConfig::Load(mbWxConfig *cfg) {
	//Keyboard links
	wxString binlinks;
	if(cfg->Read("/Keyboard/Keylinks",&binlinks)) {
		if(binlinks.length()!=8) {
			wxLogWarning("Bad keylinks settings; setting to defaults.\n");
			for(unsigned i=0;i<8;++i) {
				this->keylinks[i]=false;
			}
		} else {
			for(unsigned i=0;i<8;++i) {
				if(binlinks[i]!='0'&&binlinks[i]!='1') {
					wxLogWarning("Bad character '%c' in keylinks.",binlinks[i]);
				} else {
					this->keylinks[i]=binlinks[i]=='1';
				}
				wxLogVerbose("link %u (bit %u, 0x%X) is %s\n",1+i,7-i,1<<(7-i),
					this->keylinks[i]?"set":"clear");
			}
		}
	}

	wxString old_path=cfg->GetPath();
	cfg->SetPath("/Keyboard");
	wxString group_name;
	long group_index;
	if(cfg->GetFirstGroup(group_name,group_index)) {
		std::vector<wxString> keymap_names;
		do {
			keymap_names.push_back(group_name);
		} while(cfg->GetNextGroup(group_name,group_index));
		for(unsigned i=0;i<keymap_names.size();++i) {
			wxLogVerbose("Reading keymap %s...\n",keymap_names[i].c_str());
			mbKeymap new_keymap(keymap_names[i]);
			cfg->SetPath("/Keyboard/"+keymap_names[i]);
			std::vector<wxString> key_names;
			wxString key_name;
			long key_index;
			if(cfg->GetFirstEntry(key_name,key_index)) {
				do {
					key_names.push_back(key_name);
				} while(cfg->GetNextEntry(key_name,key_index));
			}
			for(unsigned j=0;j<key_names.size();++j) {
				wxString host_keys;
				cfg->Read(key_names[j],&host_keys);
				new_keymap.SetKey(key_names[j],host_keys);
			}
			this->keymaps.push_back(new_keymap);
		}
	}
	cfg->SetPath(old_path);

	if(this->keymaps.empty()) {
		this->keymaps.push_back(mbKeymap::DefaultKeymap());
		wxLogWarning("No keymaps found -- adding default UK QWERTY\n");
	}

	cfg->Read("/Keyboard/SelectedKeymap",&this->selected_keymap);
	//this->selected_keymap=cfg->Read("/Keyboard/SelectedKeymap");
	LoadRect(cfg,"/Sound/DialogRect",&this->dlg_rect);
}

void mbKeyboardConfig::Save(mbWxConfig *cfg)  const{
	wxString binlinks;
	for(unsigned i=0;i<8;++i) {
		binlinks+=this->keylinks[i]?"1":"0";
	}
	cfg->Write("/Keyboard/Keylinks",binlinks);

	for(mbKeymap::C::const_iterator keymap=this->keymaps.begin();
		keymap!=this->keymaps.end();++keymap)
	{
		for(unsigned i=0;i<256;++i) {
			const mbKeymap::HostKeys *host_keys=&keymap->keymap[i];
			wxString mb_key=mbKeyNameFromCode(bbcKey(i));
			if(host_keys->empty()||mb_key.empty()) {
				continue;
			}
			wxString host_keys_names;
			for(mbKeymap::HostKeys::const_iterator host_key=host_keys->begin();
				host_key!=host_keys->end();++host_key)
			{
				wxString host_key_name=HostInp_KeyNameFromCode(*host_key);
				if(!host_key_name.empty()) {
					if(!host_keys_names.empty()) {
						host_keys_names+=",";
					}
					host_keys_names+=host_key_name;
				}
			}
			if(!host_keys_names.empty()) {
				cfg->Write("/Keyboard/"+keymap->name+"/"+mb_key,host_keys_names);
			}
		}
	}
	cfg->Write("/Keyboard/SelectedKeymap",selected_keymap);
	SaveRect(cfg,"/Sound/DialogRect",this->dlg_rect);
}

//////////////////////////////////////////////////////////////////////////
//

static HostGfx_ScanlinesMode ScanlinesModeFromName(const wxString &str) {
	if(str.CmpNoCase("single")==0) {
		return HostGfx_SINGLE;
	} else if(str.CmpNoCase("interlace")==0) {
		return HostGfx_INTERLACE;
	} else if(str.CmpNoCase("double")==0) {
		return HostGfx_DOUBLE;
	}
	wxLogWarning("Unknown scanlines mode \"%s\" -- using single",str.c_str());
	return HostGfx_SINGLE;
}

static const wxString NameFromScanlinesMode(HostGfx_ScanlinesMode mode) {
	switch(mode) {
	default:
	case HostGfx_SINGLE:
		return "single";
	case HostGfx_INTERLACE:
		return "interlace";
	case HostGfx_DOUBLE:
		return "double";
	}
}

mbVideoConfig::mbVideoConfig():
width(640),
height(272),
frame_skip(0),
cleanup_frequency(100),
full_screen(false),
full_screen_refresh_rate(0),
full_screen_scanlines(HostGfx_SINGLE),
windowed_scanlines(HostGfx_SINGLE)
{
}

void mbVideoConfig::Load(mbWxConfig *cfg) {
	wxString scanlines_mode_name;

	cfg->Read("/Video/Width",&this->width);
	cfg->Read("/Video/Height",&this->height);
	cfg->Read("/Video/FrameSkip",&this->frame_skip);
	cfg->Read("/Video/CleanupFrequency",&this->cleanup_frequency);
	//cfg->Read("/Video/Vertical2x",&this->vertical_2x);
	cfg->Read("/Video/FullScreen",&this->full_screen);
	cfg->Read("/Video/FullScreenRefreshRate",&this->full_screen_refresh_rate);

	scanlines_mode_name="";
	cfg->Read("/Video/FullScreenScanlinesMode",&scanlines_mode_name);
	this->full_screen_scanlines=ScanlinesModeFromName(scanlines_mode_name);
	scanlines_mode_name="";
	cfg->Read("/Video/WindowedScanlinesMode",&scanlines_mode_name);
	this->windowed_scanlines=ScanlinesModeFromName(scanlines_mode_name);
	
	ClampValue("Video/Width",&this->width,640,800);
	ClampValue("Video/Height",&this->height,256,312);
	ClampValue("Video/FrameSkip",&this->frame_skip,1,50);
	ClampValue("Video/CleanupFrequency",&this->cleanup_frequency,1,-1);
}

void mbVideoConfig::Save(mbWxConfig *cfg)  const{
	cfg->Write("/Video/Width",this->width);
	cfg->Write("/Video/Height",this->height);
	cfg->Write("/Video/FrameSkip",this->frame_skip);
	cfg->Write("/Video/CleanupFrequency",this->cleanup_frequency);
	//cfg->Write("/Video/Vertical2x",this->vertical_2x);
	cfg->Write("/Video/FullScreen",this->full_screen);
	cfg->Write("/Video/FullScreenScanlinesMode",
		NameFromScanlinesMode(this->full_screen_scanlines));
	cfg->Write("/Video/WindowedScanlinesMode",
		NameFromScanlinesMode(this->windowed_scanlines));
	cfg->Write("/Video/FullScreenRefreshRate",this->full_screen_refresh_rate);
}
	
//////////////////////////////////////////////////////////////////////////
//

mbMiscConfig::mbMiscConfig():
limit_speed(false),
show_status_bar(true),
show_menu(true),
fast_forward_disc_access(false),
model("b"),
window_rect(-1,-1,-1,-1),
window_is_maximized(false)
{
}

void mbMiscConfig::Load(mbWxConfig *cfg) {
	cfg->Read("/Misc/LimitSpeed",&this->limit_speed);
	cfg->Read("/Misc/DiscInterface",&this->disc_interface);
	cfg->Read("/Misc/ShowStatusBar",&this->show_status_bar);
	cfg->Read("/Misc/ShowMenu",&this->show_menu);
	cfg->Read("/Misc/FastForwardDiscAccess",&this->fast_forward_disc_access);
	cfg->Read("/Misc/Model",&this->model);
	LoadRect(cfg,"/Misc/WindowRect",&this->window_rect);
	cfg->Read("/Misc/WindowMaximized",&this->window_is_maximized);
}

void mbMiscConfig::Save(mbWxConfig *cfg) const {
	cfg->Write("/Misc/LimitSpeed",this->limit_speed);
	cfg->Write("/Misc/DiscInterface",this->disc_interface);
	cfg->Write("/Misc/ShowStatusBar",this->show_status_bar);
	cfg->Write("/Misc/ShowMenu",this->show_menu);
	cfg->Write("/Misc/FastForwardDiscAccess",this->fast_forward_disc_access);
	cfg->Write("/Misc/Model",this->model);
	SaveRect(cfg,"/Misc/WindowRect",this->window_rect);
	cfg->Write("/Misc/WindowMaximized",this->window_is_maximized);
}

//////////////////////////////////////////////////////////////////////////
//
mbQuickstartConfig::mbQuickstartConfig():
dialog_pos(-1,-1,-1,-1)
{
}

void mbQuickstartConfig::Load(mbWxConfig *cfg) {
	unsigned i=0;
	bool done=false;
	do {
		wxString key,value;
		key.Printf("%u",i++);
		if(!cfg->Read("/Quickstart/Dirs/"+key,&value)) {
			done=true;
		} else {
			this->dirs.push_back(wxFileName::DirName(value));
			if(!this->dirs.back().IsOk()) {
				wxLogWarning("Ignoring invalid quickstart dir\n%s",value);
				this->dirs.pop_back();
			}
		}
	} while(!done);

	LoadRect(cfg,"/Quickstart/DialogRect",&this->dialog_pos);
}

void mbQuickstartConfig::Save(mbWxConfig *cfg)  const{
	cfg->DeleteGroup("/Quickstart/Dirs");
	for(unsigned i=0;i<this->dirs.size();++i) {
		wxString key;
		key.Printf("%u",i);
		cfg->Write("/Quickstart/Dirs/"+key,this->dirs[i].GetFullPath());
	}

	SaveRect(cfg,"/Quickstart/DialogRect",this->dialog_pos);
}

//////////////////////////////////////////////////////////////////////////

//static const char *default_filename="./beeb.ini";

static mbWxConfig *NewMbWxConfig(const char *filename) {
	long flags=wxCONFIG_USE_LOCAL_FILE|wxCONFIG_USE_RELATIVE_PATH;
	return new mbWxConfig("Beeb","Tom",filename,"",flags);
}

void mbConfig::GetConfig(mbWxConfig *cfg) const {
	this->roms.Save(cfg);
	this->sound.Save(cfg);
	this->keyboard.Save(cfg);
	this->video.Save(cfg);
	this->misc.Save(cfg);
	this->quickstart.Save(cfg);
}

void mbConfig::Load(const wxString &config_file_name) {
	//This is to get around the possibility that a file specified without a
	//path will end up coming from some kind of systemwide config type place,
	//as is the case on Windows.
	mbWxConfig *conf=NewMbWxConfig(mbNormalizedFileName(config_file_name));//new mbWxConfig("mb");
	conf->SetExpandEnvVars(true);
	this->roms.Load(conf);
	this->sound.Load(conf);
	this->keyboard.Load(conf);
	this->video.Load(conf);
	this->misc.Load(conf);
	this->quickstart.Load(conf);
	delete conf;
}

void mbConfig::SetFilename(const wxString &config_file_name,bool is_read_only) {
	this->read_only=is_read_only;
	this->file_name=wxFileName::FileName(config_file_name).GetFullPath();
}

void mbConfig::Save() const {
	if(this->read_only) {
		return;
	}
	mbWxConfig *conf=NewMbWxConfig(this->file_name);//new mbWxConfig("mb");
	this->GetConfig(conf);
	//Retry 10 times. This is to ensure Norton Anti Virus
	//doesn't bollocks it all up!
	//This is slightly silly if not on Windows, but hey! it won't do any harm.
	//TODO porting issue?
	int i;
	for(i=0;i<10;++i) {
		if(conf->Flush()) {
			break;
		}
#ifdef __WXMSW__
		Sleep(10);
#endif
	}
	delete conf;
	if(i==0) {
		//That's ok!
	} else if(i<10) {
		wxLogMessage("File saved OK despite warnings\nProbably Norton Anti Virus...");
	} else {
		wxString tmp_name=wxFileName::CreateTempFileName(".");
		wxLogWarning("Saving cfg to tmp file \"%s\"\n",tmp_name.c_str());
		if(tmp_name) {
			conf=NewMbWxConfig(tmp_name);
			this->GetConfig(conf);
			if(!conf->Flush()) {
				wxLogWarning("Failed to save config to tmp file.\n");
			} else {
				wxLogWarning("Saved config successfully to tmp file.\n");
			}
			delete conf;
		}
		wxLogWarning("Failed to save config file. Check details.");
	}
	wxLog::FlushActive();
}

mbConfig::mbConfig():
read_only(false)
{
}
