#ifndef TAPE_H
#define TAPE_H

#include "uef.h"

class C_Tape
{
	public :
		bool motor_on, tape_read, pause_display;
		unsigned __int8 tape_data;

		bool Open(char *name);
		void Close(void);
		void Keepalive(void);
		void Rewind(void);

		void HandleService(unsigned char &a, unsigned char &x, unsigned char &y, unsigned char type);

	private :
		unsigned __int8 tape_minor;
		int tape_counter, tape_target;
		C_UEF tape;

		unsigned char *data;
		int data_length;
		unsigned char *fname;
		unsigned short blocknum;
		bool tape_end;

		void GetNewChunk(void);

		void NewFileChunk(void);
		void NextFile(void);

		bool FindFile(char *name);
		bool LoadFile(unsigned char *info);
};

#endif