#ifndef GUI_H
#define GUI_H

#include "defines.h"

extern void do_gui(void);

enum gui_messages
{
	GUIMSG_NONE, GUIMSG_DRAW, GUIMSG_DONE, GUIMSG_REDRAW, GUIMSG_KILL,
	GUIMSG_LCLICK, GUIMSG_KEYPRESS
};

struct gui_element
{
	unsigned int x1, y1;
	unsigned int x2, y2;
	int c;
	gui_messages (* proc)(gui_messages message, int x, int y, gui_element *owner);
	void *data;
	void *data2;
};

extern gui_messages gui_textline(gui_messages message, int x, int y, gui_element *owner);
gui_messages gui_radio_button(gui_messages message, int x, int y, gui_element *owner);
extern gui_messages gui_button(gui_messages message, int x, int y, gui_element *owner);
extern gui_messages gui_down_arrow(gui_messages message, int x, int y, gui_element *owner);
extern gui_messages gui_up_arrow(gui_messages message, int x, int y, gui_element *owner);
extern gui_messages gui_draw_rect(gui_messages message, int x, int y, gui_element *owner);
extern gui_messages gui_centre_string(gui_messages message, int x, int y, gui_element *owner);
extern gui_messages gui_left_string(gui_messages message, int x, int y, gui_element *owner);
extern gui_messages gui_right_string(gui_messages message, int x, int y, gui_element *owner);

extern gui_element *elements[5];
extern bool malld, done;
extern void free_gui(gui_element *first);

extern unsigned char keybuf[8], keyfirst;

typedef void (* callfunc)(void);

extern gui_element backdrop[];
#define set_default_behind() elements[0] = backdrop

#define FONT_H 25
#define kill_front() if(malld)free_gui(elements[2]); elements[2] = NULL;

#endif
