/*

	ElectrEm (c) 2000 Thomas Harte - an Acorn Electron Emulator

	This is open software, distributed under the GPL 2, see 'Copying' for details

	cheat.cpp
	=========

	The cheat mechanisms. Currently missing several routines.

	Contains :

		routines for finding cheats via the GUI

	Bibliography :

		(none)

*/
#include "defines.h"
#include "gui.h"
#include "6502.h"
#include <stdlib.h>
#include <stdio.h>

extern C_6502ULA electron;
#include "gfx.h"
extern C_gfx_api gfxdrvr;

struct cheat_element
{
	unsigned short addr;
	cheat_element *next;
} *first;
char key_value[4];
int base;


void init_cheat_list(void)
{
	first = NULL;
	base = 0;
}

void free_cheat_list(void)
{
	cheat_element *next;

	while(first)
	{
		next = first->next;
		free(first);
		first = next;
	}
}

int list_length(cheat_element *list)
{
	int c;

	c = 0;
	while(list)
	{
		c++;
		list = list->next;
	}

	return c;
}

int get_code(cheat_element *t)
{
	int ret;
	int count, res, temp;

	temp = ret = (t->addr) | ((unsigned int)(*(electron.GetNormalPtr(t->addr))) << 16);

	count = 7;
	res = 0;
	while(count--)
	{
		res += temp&15;
		temp >>= 4;
	}
	res &= 15;
	ret |= (res << 24);

	return ret;
}

gui_messages disp_list(gui_messages message, int x, int y, gui_element *owner)
{
	int length, ypos, w;
	cheat_element *top;
	char text[40];

	if(message == GUIMSG_DRAW)
	{
		length = list_length(first);
		gfxdrvr.SetTextArea(owner->x1, owner->y1, owner->x2, owner->y2);

		if(length == 0)
		{
			sprintf(text, "no matches found");

			w = gfxdrvr.StrLen(text) >> 1;
			gfxdrvr.WriteString(text, (owner->x1+owner->x2 >> 1)-w, owner->y1, 184);

			return GUIMSG_NONE;
		}

		if(length > 8)
		{
			sprintf(text, "%d matches found, refine search!", length);

			w = gfxdrvr.StrLen(text) >> 1;
			gfxdrvr.WriteString(text, (owner->x1+owner->x2 >> 1)-w, owner->y1, 184);

			return GUIMSG_NONE;
		}

		//list codes here
		top = first;
		sprintf(text, "Matches : %d", length);
		ypos = owner->y1;

		if(length == 1)
		{
			ypos++;
		}

		w = gfxdrvr.StrLen(text) >> 1;
		gfxdrvr.WriteString(text, (owner->x1+owner->x2 >> 1)-w, ypos, 160);
		ypos += FONT_H << 1;

		while(length--)
		{
			sprintf(text, "%07x", get_code(top));
			top = top->next;

			w = gfxdrvr.StrLen(text) >> 1;
			gfxdrvr.WriteString(text, (owner->x1+owner->x2 >> 1)-w, ypos, 160);
			ypos += FONT_H;
		}
	}

	return GUIMSG_NONE;
}

cheat_element *new_list_entry(void)
{
	cheat_element *local;

	local = (cheat_element*)malloc(sizeof(cheat_element));
	local->next = NULL;

	return local;
}

cheat_element *corrode_list(cheat_element *in, unsigned __int8 value)
{
	unsigned __int8 *mem, *base;
	int c;
	cheat_element *last, *first, *newlist, *next;

	//assumption 1 : all Electron RAM is contiguous in PC RAM
	base = mem = electron.GetNormalPtr(0);

	//no value for in => search all of RAM
	if(!in)
	{
		last = NULL;
		first = newlist = new_list_entry();

		//assumption 2 : Electron RAM totals 32kb
		c = 32768;
		while(c--)
		{
			if((*mem) == value)
			{
				last = newlist;
				newlist->addr = mem-base;
				newlist->next = new_list_entry();
				newlist = newlist->next;
				//add to list
			}
			mem++;
		}

		if(!last)
		{
			first = NULL;
		}
		else
		{
			free(last->next);
			last->next = NULL;
		}
	}
	else
	{
		first = last = newlist = NULL;

		while(in)
		{
			next = in->next;

			if( (*(electron.GetNormalPtr(in->addr))) == value)
			{
				if(!newlist)
				{
					first = newlist = in;
				}
				else
				{
					last = newlist;
					newlist->next = in;
					newlist = newlist->next;
				}
				//add to list
			}
			else
				free(in);

			in = next;
		}
		newlist->next = NULL;
	}

	return first;
}

void do_search(void)
{
	int val;
	char *end;

	if(strlen(key_value))
	{
		//have user enter 'val', here
		val = (int)strtol(key_value, &end, base ? 16 : 10);

		if(*end != '\0')
		{
			//not a number

			return;
		}

		if(val < 0 || val > 255)
		{
			//number out of range

			return;
		}

		first = corrode_list(first, val);
	}
}

void new_search(void)
{
	free_cheat_list();
	do_search();
}

gui_element newscreen[] =
{
	{0, FONT_H+3, 640, 511, 0, gui_draw_rect},

	{0, (int)(FONT_H*1.5), 639, (int)(FONT_H*2.5), 184, gui_centre_string, "Find New Cheat"},

	{0, (int)(FONT_H*3), 319, (int)(FONT_H*4), 160, gui_left_string, "Enter Search Value (0-255) :"},
	{320, (int)(FONT_H*3), 639, (int)(FONT_H*4), 4, gui_textline, key_value},

	{0, (int)(FONT_H*4.5), 240, (int)(FONT_H*5.5)+6, 160, gui_button, "Do Search", do_search},
	{0, (int)(FONT_H*6), 240, (int)(FONT_H*7)+6, 160, gui_button, "New Search", new_search},

	{320, (int)(FONT_H*4.5), 320+FONT_H, (int)(FONT_H*5.5), 0, gui_radio_button, "Decimal", &base},
	{320, (int)(FONT_H*6), 320+FONT_H, (int)(FONT_H*7), 1, gui_radio_button, "Hexadecimal", &base},

	{0, (int)(FONT_H*8), 639, 511, 160, disp_list, first},

	{0, 0, 0, 0, 0, NULL}
};

void find_new_cheat(void)
{
	kill_front();
	elements[0] = newscreen;
	sprintf(key_value, "");
}
