/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1998. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (BeebInC@aol.com)                             */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <i86.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include "dpmi.h"

volatile int Timer_50Hertz=0;

static void (__interrupt __far * old_Timer8_handler) ();
static int SystemTimer;

// 50  *5 =250
// 18.2*5 =91

// out of every 250 interrupts update system clock 91 times

#define HERTZ_50          23863
#define CALL_SYS_TIMER    91
#define INITIAL_SYS_TIMER 250


// port address for channel 0
#define chan_0 0x40
// port address for command register
#define cmd_reg 0x43


static void __interrupt __far Timer8_Handler()
{
  Timer_50Hertz++;

  SystemTimer--;
    if (SystemTimer<CALL_SYS_TIMER)
    {
      // call old system timer routine 91 times every 5 seconds      
        if (SystemTimer==0)
          SystemTimer=INITIAL_SYS_TIMER;
      _chain_intr(old_Timer8_handler);
    }
    else
      outp( 0x20,0x20); // re-enable lower level interrupts
}

void Timer8_Handler_End() // does nothing
{
}


void InitTimer()
{
    if (old_Timer8_handler!=NULL)
      return;

  // set the timer interrupt handler / save the old one //
  old_Timer8_handler = _dos_getvect(0x8);
  _disable();
  SystemTimer=INITIAL_SYS_TIMER;
  outp( cmd_reg, 0x36 );
  outp( chan_0, (HERTZ_50 & 0xff) );     // lo byte of counter
  outp( chan_0, ((HERTZ_50>>8) & 0xff)); // hi byte of counter
  _enable();

  LockMemory((void *) Timer8_Handler,(char *) Timer8_Handler_End -
                                     (char *)Timer8_Handler);
  LockMemory((void *) SystemTimer,sizeof(int));
  LockMemory((void *) Timer_50Hertz,sizeof(int));

  _dos_setvect(0x8,  Timer8_Handler);
}


void RemoveTimer()
{
  _dos_setvect(0x8,  old_Timer8_handler);

  _disable();
  // put the interrupt back the way it was
  outp( cmd_reg, 0x36 );
  outp( chan_0,  0x0); // lo byte of counter
  outp( chan_0,  0x0); // hi byte of counter
  _enable();
}
