/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1998. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (BeebInC@aol.com)                             */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <stdio.h>
#include <string.h>
#include "bbc.h"
#include "fs.h"


extern char DirectoryLetter[2];

/*
"ACCESS","A."
"BACKUP","BAC."
"BUILD", "BU."
"CLOSE", "CL."
"COMPACT","COM."
"COPY","COP."
"DELETE","DE."
"DESTROY","DES."
"DRIVE","DR."
"DUMP","DU."
"ENABLE","EN."
"EX"
"EXEC","E."
"FORM","FO."
"FREE","FR."
"INFO","I."
"LIB"
"LIST"
"LOAD","L."
"MAP","MA."
"RENAME","RE."
"ROMS"
"SPOOL","SP."
"TITLE","TI."
"TYPE","TY."
"VERIFY","V."
"WIPE","W."
*/

void OSROM()
{
  Processor.NFlag=0; // not *DISK
  Processor.CFlag=0; // no text to display
  Processor.VFlag=0; // no error
    switch (Processor.AReg)
    {
      case 4 : // *Command - do not attempt *RUN
               DoStarCommand();
               break;
      case 8 : // unknown OSWORD A,X,Y at EF,F0,F1
                 if (AddressSpace[0xef]==0x7d ||
                     AddressSpace[0xef]==0x7e ||
                     AddressSpace[0xef]==0x7f)
                  {
                    FILE * F=fopen("OSWORD.LOG","at+");
                    fprintf(F,"OSWORD 0x%2x, X=0x%2x, Y=0x%2x\n",
                            AddressSpace[0xef],
                            AddressSpace[0xf0],
                            AddressSpace[0xf1]);
                    fclose(F);
                  }
               break;
      case 9 : // *HELP
               DoHelpCommand();
               break;
    }
}

void DoStarCommand()
{
  char S[256];
  char * Str=S;

  // MAKE A=0 if done a *command

  strcpy(S,GetVectoredFSString(0xf2,Processor.YReg));
    while (*Str=='*')
      Str++;

    if (strnicmp(Str,"DISK",4)==0 ||
        strnicmp(Str,"DISC",4)==0 ||
        strnicmp(Str,"D.",2)==0 )
    {
      Processor.AReg=0;
      Processor.NFlag=128;
    }
    else if (strnicmp(Str,"DIR",3)==0 || strnicmp(Str,"DI.",3)==0)
    {
      Str+=3;
        while (*Str==' ')
          Str++;

      DirectoryLetter[0]=*Str;
      DirectoryLetter[1]=0;
        if (DirectoryLetter[0]=='$')
          DirectoryLetter[0]=0;
      Processor.AReg=0;
    }
    else
    {
      FILE * FH=fopen("STAR.LOG","at");
      fprintf(FH,"%s\n",Str);
      fclose(FH);
    }
}

void DoHelpCommand()
{
  char HelpStr[256];

  strcpy(HelpStr,GetVectoredFSString(0xf2,Processor.YReg));

    if (strnicmp(HelpStr,"DFS",3)==0)
    {
      MakeTextFile("DCDDFS 0.1\n"
                   "  DIR     (<dir>)       DI.     (<dir>)\n",0);
    }
    else if (strnicmp(HelpStr,"UTILS",5)==0)
    {
      MakeTextFile("DCDDFS 0.1\n  DISK\n  DISC\n",0);
    }
    else if (strnicmp(HelpStr,"DCDDFS",6)==0)
    {
      MakeTextFile("DCDDFS 0.1\n  DFS\n  UTILS\n",0);
    }
    else
    {
      MakeTextFile("DCDDFS 0.1\n",USEDEFAULTAREG);
    }
}
