/*******************************************************************************************


			GAME.C

         (c) MHG 1992,1997

         3 sept 97   MHG   Save bmp file
         14 feb 97   MHG   Parses game infomation file


*******************************************************************************************/
#include	<stdio.h>
#include	<string.h>
/*******************************************************************************************


         DEFINES


*******************************************************************************************/
#define	MAX_GAMES  1000
/*******************************************************************************************


         STRUCTURES


*******************************************************************************************/
typedef struct
{
	char	*title;
	char	*company;
	char	*disc_name;
	char	*drive;
	char	*directory;
	char	*run;
	char	*program;
} NAMES;

typedef struct
{
	char	*p[7];
} INDEX;

typedef union
{
	INDEX	index;
	NAMES name;
} GAME;
/*******************************************************************************************


         DATA


*******************************************************************************************/
GAME	game[MAX_GAMES];			//room for 1000 games !!!
int	num_games;
/*******************************************************************************************


      parse_gamefile

      load file called games.txt and parse it


*******************************************************************************************/
void	parse_gamefile()
{
	int	len;
	char	*mem;
	char	*mem_end;
   char  *p,*q;
   int   i,j;
	char	a;
   GAME tmp;
   int   indx;

	num_games=0;

   len=file_size("games.txt");
   if (len==0) return;

	mem=(char *)malloc(len);
	load_file("games.txt",mem);
	mem_end=mem+len;

   // zero out eol marker
	for(i=0;i<len;i++)
	{
		a=mem[i];
      if (a==0x1a || a==13 || a==10) mem[i]=0;
	}

	p=mem;
	// print each line
	while(p<mem_end)
	{
		len=strlen(p);
		if (len!=0)
		{
	  	//	printf("%s\n",p);
			strupr(p);
	 		if (parse_line(p,len,&game[num_games]))
	  			num_games++;
		}
		p+=len+1;
		if (num_games>=MAX_GAMES) break;
	}
	reset_insert();

   for(j=0;j<num_games;j++)
	{
      q=(char *)game[j].name.title;
		indx=j;

      for(i=j+1;i<num_games;i++)
		{
         p=(char *)game[i].name.title;

			if (strcmp(p,q)<0)
			{
				indx=i;
				q=p;
			}
		}

      memcpy(&tmp,&game[j],sizeof(GAME));
      memcpy(&game[j],&game[indx],sizeof(GAME));
      memcpy(&game[indx],&tmp,sizeof(GAME));
	}
}
/*******************************************************************************************


		parse one line


*******************************************************************************************/
int	parse_line(char *mem,int len,GAME *game)
{
	char	*p;
	char	*mem_end=mem+len;
	int	i;
	char	a;
	int	k;
   int   open_quote=0;

//
//    Ignore the line if it begins with a /
//
	if (mem[0]=='/') return(0);

//
//    Zero out separators unless they are within quotes ' or "
//
	for(i=0;i<len;i++)
	{
		a=mem[i];
      if (a==0x27 || a==0x22 || a==0x60) { open_quote^=1; mem[i]=0; }

      if (open_quote==0)
         if (a==32 || a==9 || a==',' || a==';' ) mem[i]=0;
	}

	p=mem;
	k=0;
	while(p<mem_end)
	{
		len=strlen(p);
		if (len!=0)
		{
       //   printf("%s ",p);
			game->index.p[k]=p;
			k++;
		}
		p+=len+1;
		if (k>7) return(0);
	}
	if (k!=7) return(0);

	//printf("\n");
   return(1);           //line parsed ok
}


#define	insert_string(a,b)	sprintf(buff,a,b); insert_text(buff)

/*******************************************************************************************

      load_game

      run game on a disc

		in:	index of game
      out:  name of disc that game is stored on

*******************************************************************************************/
char	*load_game(int index)
{
	GAME *p=&game[index];
   char  buff[64];

//		load_disc_image(p->a.disc_name);
	insert_string("*DR. %s\r",p->name.drive);   			//change drive
	insert_string("*DIR %s\r",p->name.directory);   	//change directory

	if (*p->name.run=='R')
	{
   	insert_string("*%s\r",p->name.program);
	}
	else
	{
		insert_string("CHAIN \"%s\"\r",p->name.program);
	}
	return(p->name.disc_name);
}
/*******************************************************************************************


		File stuff

      (C) 1992,97 MHG


*******************************************************************************************/
#include <stdio.h>
#include <dos.h>


int	load_file(char *name,char *buff)
{
	char 		*load_addr;
	FILE		*file;
	int		length;
	int		len2;

	file = fopen(name,"rb");
	if (file == NULL)
	{
		return(0);
	}
	fseek(file,0,SEEK_END);

	length = ftell(file);

	fseek(file,0,SEEK_SET);

	len2=fread(buff,1,length,file);
	if (len2!=length)
	{
		fclose(file);
		return(0);
	}

  	fclose(file);
	return(length);
}


int   save_file(char *name,char *buff,int len)
{
	char 		*load_addr;
	FILE		*file;
	int		length;

	file = fopen(name,"wb");
	if (file == NULL)
	{
		return(0);
	}

	len=fwrite(buff,1,len,file);

	fclose(file);

	return(len);
}


int	file_size(char *name)
{
	char 		*load_addr;
	FILE		*file;
	int		length;

	file = fopen(name,"rb");
	if (file == NULL)
	{
		return(0);
	}
	fseek(file,0,SEEK_END);
	length = ftell(file);
	fclose(file);
	return(length);
}



/*******************************************************************************************


      SAVE SCREEN AS A BMP FILE


*******************************************************************************************/
typedef  unsigned short WORD;


const WORD BMP_MAGIC = 'M'*256+'B';


typedef struct
{
	WORD 	fh_type; 			//signature - 'MB'
	long 	fh_size;    		//size of file in DWORD
	WORD 	fh_reserved1;
	WORD	fh_reserved2;
	long 	fh_offbits;			//image start offset in bytes
} BMP_FILE_HEADER;

typedef struct
{
	long ih_size;  		  		//size of image header 40
	long ih_width;
	long ih_height;
	WORD ih_planes;  		 		//always 1
	WORD ih_bit_count;     		//bits per pixel
	long ih_compression; 	 	//0 - none    1-rle
	long ih_size_image;	   	//compressed image size
	long ih_xpels_per_meter;
	long ih_ypels_per_meter;
	long ih_clr_used;
	long ih_clr_important;
} BMP_IMAGE_HEADER;



typedef struct
{
   char  r;
   char  g;
   char  b;
	char  a;
} RGB;

int   sc_no=0;

int   save_screen(char *screen)
{
   FILE  *file;
   int   len;
   char  title[32];
	BMP_FILE_HEADER 	fh;
   BMP_IMAGE_HEADER  ih;
   int   i;

   RGB   pal[256]=
   {
      0,0,0,0,
      0,0,255,0,
      0,255,0,0,
      0,255,255,0,
      255,0,0,0,
      255,0,255,0,
      255,255,0,0,
      255,255,255,0
   };

   sprintf(title,"pic%d.bmp",sc_no);
   sc_no++;
   file = fopen(title,"wb");
	if (file == NULL)
	{
		return(0);
	}
   memset(&fh,0,sizeof(BMP_FILE_HEADER));
   memset(&ih,0,sizeof(BMP_IMAGE_HEADER));

	fh.fh_type=BMP_MAGIC;
	fh.fh_size=sizeof(BMP_FILE_HEADER)+sizeof(BMP_IMAGE_HEADER)+4*256+320*256;
   fh.fh_offbits=4*256+sizeof(BMP_FILE_HEADER)+sizeof(BMP_IMAGE_HEADER);


	ih.ih_size=40;
	ih.ih_width=320;
	ih.ih_height=256;
	ih.ih_planes=1;
	ih.ih_bit_count=8;

   fwrite(&fh,1,sizeof(BMP_FILE_HEADER),file);
   fwrite(&ih,1,sizeof(BMP_IMAGE_HEADER),file);
   fwrite(&pal,1,4*256,file);
//   fwrite(screen,1,320*256,file);

   for(i=0;i<256;i++)
   	fwrite(&screen[320*(255-i)],1,320,file);

	fclose(file);
   return(1);
}



