#include <stdio.h>
#include <unistd.h>
/* #include <getopt.h> */
#include "manager.h"
#include "text.h"
#include "6502P.h"
#include "dis6502.h"

int debug = 0;

int main(int argc, char **argv) {
    extern char *optarg;
    time_t time = 0;
    int i, c;

    while (-1 != (c = getopt(argc, argv, "dD:"))) {
	switch (c) {
	case 'd':
	    debug = 1;
	    break;
	case 'D':
	    chdir(optarg);
	    break;
	case '?':
	case 'h':
	    puts("beeb [-d] [-D directory]");
	    return 1;
	}
    }

    /* initialise our modules */
    init_screen();
    for (i = 0; i < N_MODULES; i++) {
	module[i]->init();
    }

    for (;;) {
#ifdef DEBUG
	if (debug) {
	    printf("%04x: %02x %02x %02x, A=%02x, X=%02x, Y=%02x, S=%02x,"
		   " P=%02x ; ", PC, readbq(PC),
		   readbq(PC+1), readbq(PC+2),
		   A, X, Y, SP, P);
	    disassemble(readbq(PC));
	}
#endif
	opcode[readbq(PC)]();
    }

    return 0;
}
