#ifndef _6522_H_
#define _6522_H_

#if defined (USER_VIA) || defined(SYSTEM_VIA)

#include "defs.h"

typedef struct _6522_ {
    /* public */
#   include "public_template.h"
    byte (*read_func)(word addr);
    byte (*write_func)(word addr, byte val);
} t_6522;

extern t_6522 i_6522_system;
extern t_6522 i_6522_user;

/* should be 100 initially */
#define HZ_6502 1

/* IFR (and IER) defines */
#define IFR_CA2 0x01
#define IFR_CA1 0x02
#define IFR_SR  0x04
#define IFR_CB2 0x08
#define IFR_CB1 0x10
#define IFR_T2  0x20
#define IFR_T1  0x40
#define IFR_SET 0x80

#endif /* defined */

#endif /* _6522_H_ */
