/* XTI 1.2 - image creation, merging, splitting, routines */
/* filename: xti_misc.c */


void doRevert(char *Name)
{
 char TargetName[256];
 char *dotpt;
 unsigned char ref;
 int echec,i,S,T,s,t,Tops,refs,Tsize;

 getFormat(Name);
 if (theFormat == kDSK) { fprintf(stderr, "File is already dsk !\n"); exit(17); }
 if (theFormat != kEDK) { fprintf(stderr, "Can only revert edsk !\n"); exit(18); }

 sprintf (TargetName, "%s", Name);
 if ((dotpt = strchr(TargetName, '.')) == NULL) dotpt = TargetName + strlen(TargetName);
 sprintf (dotpt, sfODSK);
 if ( !strcmp(Name, TargetName) )
       {fprintf(stderr, "File naming conflict, cannot proceed\n"); exit(10); }
 Target = fopen(TargetName, "w");
 Source = fopen(Name, "rb");

 for(i=0; i<256; i++) { InputBuff[i] = fgetc(Source); fputc(0, Target); }
 echec = 0;
 ref = InputBuff[0x34];
 for(i=0; i<InputBuff[kTrackNumOffset]; i++)
      if (InputBuff[0x34+i] != ref) { echec = 1; break; }
 if (echec)
    { fprintf(stderr, "Variable track sizes, cannot revert to dsk !\n"); exit(19); }

 printf("Reverting to plain dsk...\n");

 fseek(Target, 0, SEEK_SET);
 fprintf(Target, "MV - CPCEMU Disk-File\r\nDiskInfo\r\n");
 fseek(Target, kTrackNumOffset, SEEK_SET);
 fputc(T = InputBuff[kTrackNumOffset], Target);
 fseek(Target, kSideNumOffset, SEEK_SET);
 fputc(S = InputBuff[kSideNumOffset], Target);
 fseek(Target, 0x33, SEEK_SET);
 fputc(ref, Target);
 fseek(Target, 0, SEEK_END);
 Tsize = 256L*(ref-1L);

 for(t = 0; t<T; t++)
  for(s = 0; s<S; s++)
   {
   for(i = 0; i<256; i++) InputBuff[i] = fgetc(Source);
   refs = NtoSize(InputBuff[14]);
   Tops = InputBuff[15];
   echec = 0;
   for(i = 0; i<Tops; i++)
       if ( (InputBuff[0x18+6+i]+256*InputBuff[0x18+7+i]) != refs)
         { echec = 1; break; }
   if (echec)
    { fprintf(stderr, "Variable sector sizes on track %d, cannot revert to dsk !\n", t);
      exit(20); }

   for(i=0; i<Tops; i++) InputBuff[0x18+6+i] = InputBuff[0x18+7+i] = 0;
   for(i=0; i<256; i++) fputc(InputBuff[i], Target);
   for(i=0; i<Tsize; i++) fputc(fgetc(Source), Target);
   }

 fclose(Source);
 fclose(Target);
}




void doNew(char *Name)
{
 int i,j,k,m;

 Target = fopen(Name, "w");

 SetUpDSKHeader(HeaderBuff, 40, 1);
 for(i=0; i<512; i++) SectorBuff[i] = 0xe5;
 switch (theFormat)
  { case kNEWD : k = 0xC1; m = 9; sprintf(HeaderBuff+128, "Data Disk\n");
                 printf("Creating new image with Data format\n"); break;
    case kNEWS : k = 0x41; m = 9; sprintf(HeaderBuff+128, "System Disk\n");
                 printf("Creating new image with Vendor format\n"); break;
    case kNEWI : k = 0x01; m = 8;
                 printf("Creating new image with IBM format\n"); break; }

 for(i=0; i<40; i++)
   {
   SetUpTrackHeader(TrackBuff, i, 0, 2, m, 0x4e, 0xe5);
   for(j=0; j<m; j++) AddSector(TrackBuff, SectorBuff, i, 0, j+k, 2, 0x80, 0, 512);
   StoreTrack(TrackBuff);
   }
 StoreHeader(HeaderBuff);

 fclose(Target);
}









void doMerger(char *Name1, char *Name2)
{
 int Nt1, Nt2, Ntf, Ns1, Ns2, i, j;
 int Ts1[100];
 int Ts2[100];
 char TargetName[256];
 char *dotpt;

 getFormat(Name1);
 if (theFormat != kEDK)
   { fprintf(stderr, "Improper format for file %s\n", Name1); exit(8); }
 getFormat(Name2);
 if (theFormat != kEDK)
   { fprintf(stderr, "Improper format for file %s\n", Name2); exit(8); }

 if ((Source = fopen(Name1,"rb")) == NULL)
     {
     fprintf(stderr, "Unable to open %s !\n", Name1);
     exit(2);
     }
 if ((Merger = fopen(Name2,"rb")) == NULL)
     {
     fprintf(stderr, "Unable to open %s !\n", Name2);
     exit(2);
     }

 for(i=0; i<256; i++) InputBuff[i] = fgetc(Source);
 Nt1 = InputBuff[kTrackNumOffset];
 Ns1 = InputBuff[kSideNumOffset];
 if ((Ns1 & 1) != 1) { fprintf(stderr, "File %s is not single sided\n", Name1); exit(9); }
 if (Nt1>100) { fprintf(stderr, "File %s has invalid structure\n", Name1); exit(6); }
 for(i=0; i<Nt1; i++) Ts1[i] = 256*InputBuff[i+0x34];

 for(i=0; i<256; i++) InputBuff[i] = fgetc(Merger);
 Nt2 = InputBuff[kTrackNumOffset];
 Ns2 = InputBuff[kSideNumOffset];
 if ((Ns2 & 1) != 1) { fprintf(stderr, "File %s is not single sided\n", Name2); exit(9); }
 if (Nt2>100) { fprintf(stderr, "File %s has invalid structure\n", Name2); exit(6); }
 for(i=0; i<Nt2; i++) Ts2[i] = 256*InputBuff[i+0x34];

 sprintf (TargetName, "%s", Name1);
 if ((dotpt = strchr(TargetName, '.')) == NULL) dotpt = TargetName + strlen(TargetName);
 sprintf (dotpt, sfDDSK);
 if ( (!strcmp(Name1, TargetName)) || (!strcmp(Name2, TargetName)) )
       {fprintf(stderr, "File naming conflict, cannot proceed\n"); exit(10); }
 Target = fopen(TargetName, "w");

 Ntf = max(Nt1, Nt2);
 DETrick = (Ns1 & 128) || (Ns2 & 128);
 SetUpDSKHeader(HeaderBuff, Ntf, 2);
 for(i=0; i<Ntf; i++)
   {
   if (i<Nt1)
     {
     SDataOffset = Ts1[i];
     if (SDataOffset > k16KB)
             { fprintf(stderr, "File %s has invalid structure\n", Name1); exit(6); }
     for(j=0; j<SDataOffset; j++) TrackBuff[j] = fgetc(Source);
     }
    else SDataOffset = 0;
   StoreTrack(TrackBuff);

   if (i<Nt2)
     {
     SDataOffset = Ts2[i];
     if (SDataOffset > k16KB)
             { fprintf(stderr, "File %s has invalid structure\n", Name2); exit(6); }
     for(j=0; j<SDataOffset; j++) TrackBuff[j] = fgetc(Merger);
     TrackBuff[0x11] = 1;
     }
    else SDataOffset = 0;
   StoreTrack(TrackBuff);
   }

 StoreHeader(HeaderBuff);
 fclose(Source);
 fclose(Merger);
 fclose(Target);
}




int extFlag(char *eflag)
{
 if (!strcmp(eflag, fES1)) { theSide = 0; return(1); }
 if (!strcmp(eflag, fES2)) { theSide = 1; return(1); }
 return(0);
}

void doExt(char *filename)
{
 char TargetName[256];
 char *dotpt;
 
 getFormat(filename);
 if (theFormat != kEDK)
   { fprintf(stderr, "Improper format for file %s !\n", filename); exit(11); }
 if ((Source = fopen(filename,"rb")) == NULL)
     {
     fprintf(stderr, "Unable to open %s !\n", filename);
     exit(2);
     }
 sprintf (TargetName, "%s", filename);
 if ((dotpt = strchr(TargetName, '.')) == NULL) dotpt = TargetName + strlen(TargetName);
 sprintf (dotpt, sfXDSK);
 if ( !strcmp(filename, TargetName))
       {fprintf(stderr, "File naming conflict, cannot proceed\n"); exit(10); }
 Target = fopen(TargetName, "w");

 extCall = 1;
 edsk2edsk();
 printf("Extracted side %d of image.\n", theSide+1);
 fclose(Source);
 fclose(Target);
}
