; Macros for handling left/right edge horizontal displacements properly
macro incc
ld a,c
inc c
xor c
and &C0
xor c
ld c,a
endm

macro decc
ld a,c
dec c
xor c
and &C0
xor c
ld c,a
endm

macro inc2c
ld a,c
add &c2
ld c,a
endm

macro dec2c
ld a,c
add &3e
ld c,a
endm

; Macros performing vertical screen displacements 
macro moveLineUp_phase1
ld a,b
sub &8           ; Decrements one line
ld b,a
bit 6,b
jr z, @end

ld a,c
add &c0
ld c,a
ld a,b
adc &3f
ld b,a

set 3,b          ; Fixes jump over top screen edge

@end
endm

macro moveLineDown_phase1
ld a,b
add &8           ; Increments one line
ld b,a
bit 6,b
jr z, @end      

ld a,c
add &40
ld c,a
ld a,b
adc &c0
ld b,a

res 3,b          ; Fixes jump over bottom screen edge

@end
endm

macro move2linesDown_phase1
ld a,b
add &10          ; Increments two lines
ld b,a
bit 6,b
jr z, @end      

ld a,c
add &40
ld c,a

ld a,b
adc &c0
xor b
and %11000111
xor b
ld b,a

@end
endm
