; First interrupt, occurs after VSYNC & before the end of panel area
.int1split
ex af,af'

; Set mode 0 for live area
res 1,c
out (c),c

; Save MODE and ROM state
push bc

; Adjust ink
ld c,1
out (c),c
ld a,(backgroundcolour)
out(c),a

; Set screen offset for live area
ld b,&bd
ld hl,liveareaoffset
write2_CRTC

; Restore MODE and ROM state
pop bc

; Update jump vector to the next interrupt
ld hl,int2split
exx
ex af,af'
ei
ret

; Second interrupt, occurs during the live area
.int2split
ex af,af'

; Increment time counter
inc de

; Save MODE and ROM state
push bc

; Set CRTC config values for live area
ld b,&bd
ld hl,liveareacfg
write3_CRTC

; If required, switch to the non-split set of interrupt
; routines
ld a,(flags)
bit 0,a
jp nz,cont_split
  pop bc
  ex af,af'
  jp int2nosplit_entry
.cont_split

; If not, continue writing the screen offset values for the
; panel area
write2_CRTC

; Restore MODE and ROM state
pop bc

; Update jump vector to the next interrupt
ld hl,int3split
ex af,af'
exx
ei
ret

; Third interrupt
; It does nothing, but serves as an entry point from the
; non-splitted configuration
.int3split
; Update jump vector to the next interrupt
ld hl,int4split
exx
ei
ret

; Fourth interrupt
; It does nothing but incrementing time counter
.int4split
; Increment time counter
inc de
; Update jump vector to the next interrupt
ld hl,int5split
exx
ei
ret

; Fifth interrupt
; It does nothing
.int5split
; Update jump vector to the next interrupt
ld hl,int6split
exx
ei
ret

; Sixth interrupt, it occurs one scanline before panel area

.int6split
ex af,af'

; Increment time counter
inc de

; Set mode 2 for panel area
set 1,c
out (c),c

; Save MODE and ROM state
push bc

; Increment 3-bit frame counter
ld hl,framecounter
inc (hl)
res 2,(hl)

; Ajust ink for the panel (we are in the border now)
; (DON'T TOUCH HL)
ld c,&01
out (c),c
ld a,(textcolour)
out(c),a

; Call full keyboard scan and set panel update flag if required
ld a,(hl)
or a
jp nz,skip_keyb_scan
ld hl,flags
set 2,(hl)
call scankeyb
call parsekeys_split
.skip_keyb_scan

; Check keyb for scroll
scroll

; Do we need to hide the panel during next frame?
ld hl,flags
bit 1,(hl)
jp z,skip_hide_panel
patch_CRTC_cfg_nosplit
.skip_hide_panel

;Update CRTC values for panel area
ld b,&bd
ld hl,panelcfg
write3_CRTC

; Restore MODE and ROM state
pop bc

; Update jump vector to the next interrupt
ld hl,int1split
exx
ex af,af'
ei
ret
