ROW0BUFFER equ &4200
ROW1BUFFER equ &4240
ROW2BUFFER equ &4280
ROW3BUFFER equ &42c0
ROW4BUFFER equ &4300

CHLIST equ &4340

org &4200
if WRITEDIRECT
write "bank1.bin"
endif
limit &4800

db 150
ds 62,154
db 156
db 149,"                                                              ",149
db 149,"G:     0 @   0.00 g/s                                         ",149
db 149,"ACP:   0% [        ]                                          ",149
db 147
ds 62,154
db 153

ds &c0

.textbuffer
ds 256

.percentbar
db &0,&80,&c0,&e0,&f0,&f8,&fc,&fe,&ff

.printnum
ld b,&39	; High address for numbers in ROM ascii charset

jp printnum_entry

.printnumloop
ld l,a
ld a,(hl)
add a
add a
add a
ld c,a

dec h: dec h
repeat 7

di
exx
res 2,c
out (c),c
exx
ld a,(bc)
exx
set 2,c
out (c),c
exx
ei

ld (hl),a
inc c
ld a,h
add 8
ld h,a
rend

ld h,&42
inc e
.printnum_entry
ld a,(de)
cp 0
jp nz,printnumloop
ret

.printpercentbar
ld b,printpercentbar/256
jr printpercentbar_entry

.printpercentbar_loop
ld l,a
ld a,(hl)
ld c,a

dec h: dec h
ld a,h
add 8
ld h,a
repeat 4
ld a,(bc)
ld (hl),a
ld a,h
add 8
ld h,a
rend
ld a,(bc)
ld (hl),a

ld h,&42
inc e
.printpercentbar_entry
ld a,(de)
cp 0
jp nz,printpercentbar_loop
ret

.printbuffer
ld c,d
ld b,a
.printbufferloop
ld a,(de)
ld h,&7
ld l,a
add hl,hl
add hl,hl
add hl,hl

dec d: dec d

repeat 7
di
exx
res 2,c
out (c),c
exx
ld a,(hl)
exx
set 2,c
out (c),c
exx
ei

ld (de),a
inc l
ld a,d
add 8
ld d,a
rend

di
exx
res 2,c
out (c),c
exx
ld a,(hl)
exx
set 2,c
out (c),c
exx
ei
ld (de),a

ld d,c
inc de
dec b
jp nz,printbufferloop
ret

.restorehighjumpblock
exx
res 2,c
out (c),c	; Activate lower ROM 
exx
call &44
exx
set 2,c
out (c),c	; Deactivate lower ROM
exx
ret

;Converts physical coordinates to screen addresses
.phys2screen
ld a,h
ld h,0
add hl,hl
add hl,hl
add hl,hl
add hl,hl
add hl,hl
add hl,hl
add l
ld l,a
set 6,h
set 7,h
ret

.txt_write_char
ld c,a

call phys2screen

ex de,hl

ld h,&7
ld l,c
add hl,hl
add hl,hl
add hl,hl

ld b,8
.txt_write_char_loop
ld a,(hl)
ld (de),a
inc l
ld a,d
add 8
ld d,a
djnz txt_write_char_loop
ret

.txt_draw_cursor
ld      a,(&b72e)
and     &03
jp     nz,txt_draw_cursor_end

call &bb69
push hl
call &bb78
dec h: dec l
pop de
add hl,de
call phys2screen

repeat 7
ld a,(hl)
cpl
ld (hl),a
ld a,h
add 8
ld h,a
rend
ld a,(hl)
cpl
ld (hl),a

.txt_draw_cursor_end
scf
ret
