;; Thrust 
;;
;; musical loader part
;;
;; music data is embedded in the data on the cassette
;; each byte is proceeded by a 3 bit code defining the function
;; 0 = program data, !=0 = music data
;;
;; each byte:
;; 3 bits code - 8 bits data

;; pilot: pulses, 2 sync pulses, a sync "byte"

;; high "byte" of load address, checksum up to this point

;; 256 bytes of data (mixed with music data), 2 byte execution address, and a 1 byte
;; running checksum.


3c00 f3        di      
3c01 cd433d    call    3d43h				; start cassette motor
3c04 3e38      ld      a,38h
3c06 32d63f    ld      (3fd6h),a
3c09 4f        ld      c,a
3c0a 3e07      ld      a,07h				; mixer register
3c0c cd833f    call    3f83h				; write PSG register
3c0f 97        sub     a
3c10 32c53c    ld      (3cc5h),a
3c13 32c53f    ld      (3fc5h),a
3c16 32ca3f    ld      (3fcah),a
3c19 32cf3f    ld      (3fcfh),a
3c1c 3c        inc     a
3c1d 32d13f    ld      (3fd1h),a
3c20 3e0e      ld      a,0eh
3c22 32d53f    ld      (3fd5h),a


;;-------------------------------------------------------
;; get pilot

3c25 0600      ld      b,00h
3c27 cdeb3c    call    3cebh			; get pulse
3c2a 3e26      ld      a,26h
3c2c bd        cp      l
3c2d 30f6      jr      nc,3c25h
3c2f 10f6      djnz    3c27h
;;-------------------------------------------------------
;; wait for end of pilot then first sync pulse
3c31 cdeb3c    call    3cebh			; get pulse
3c34 3e26      ld      a,26h
3c36 bd        cp      l
3c37 38f8      jr      c,3c31h
;;-------------------------------------------------------
;; 2nd sync pulse
3c39 cdeb3c    call    3cebh			; get pulse
3c3c 3e26      ld      a,26h
3c3e bd        cp      l
3c3f 38e4      jr      c,3c25h
;;-------------------------------------------------------
;; sync byte				 
;; 3 bits of code, 8 bits data
3c41 cdc63c    call    3cc6h				; get byte
3c44 3e65      ld      a,65h
3c46 ba        cp      d
3c47 20dc      jr      nz,3c25h
;;-------------------------------------------------------

;; get high byte of load address
3c49 cdc63c    call    3cc6h				; get byte
3c4c cdbb3c    call    3cbbh				; update check

;; setup load address
3c4f 62        ld      h,d
3c50 2e00      ld      l,00h

;; 2nd byte is a repeat of the high byte of the load address
3c52 cdc63c    call    3cc6h				; get byte
3c55 3ac53c    ld      a,(3cc5h)
3c58 ba        cp      d
3c59 c2043c    jp      nz,3c04h
;;-------------------------------------------------------
;; read 256 bytes of data at a time (data is mixed with music data)

3c5c cdc63c    call    3cc6h				; get byte
;; E = 0 - store data-byte
;; E = code
;; bits 1,0 = channel index

3c5f 7b        ld      a,e
3c60 e603      and     03h
3c62 c2263d    jp      nz,3d26h				; update music?

;; E = 0; data byte
3c65 72        ld      (hl),d
3c66 cdbb3c    call    3cbbh				; update check
3c69 2c        inc     l
3c6a 20f0      jr      nz,3c5ch

;; 256 bytes of data have been transfered

;;-------------------------------------------------------

3c6c 24        inc     h
3c6d cdc63c    call    3cc6h				; get byte
3c70 cdbb3c    call    3cbbh				; update check
3c73 4a        ld      c,d
3c74 cdc63c    call    3cc6h				; get byte
3c77 cdbb3c    call    3cbbh				; update check
3c7a 42        ld      b,d

;; BC = address to execute

;; get current checksum
3c7b cdc63c    call    3cc6h				; get byte
3c7e 3ac53c    ld      a,(3cc5h)
3c81 ba        cp      d
3c82 c24b3d    jp      nz,3d4bh

;; 256 bytes read ok, and current checksum is ok

3c85 7b        ld      a,e
3c86 e601      and     01h
3c88 c4fb3c    call    nz,3cfbh
3c8b c5        push    bc
3c8c c9        ret     


;;--------------------------------------------------------------

3c8d cdc63c    call    3cc6h				; get byte
3c90 cdbb3c    call    3cbbh				; update check
3c93 6a        ld      l,d

3c94 cdc63c    call    3cc6h				; get byte
3c97 cdbb3c    call    3cbbh				; update check
3c9a 62        ld      h,d

;; HL = execution address for program

3c9b cdc63c    call    3cc6h				; get byte
3c9e 3ac53c    ld      a,(3cc5h)
3ca1 ba        cp      d
3ca2 c24b3d    jp      nz,3d4bh

;; load is complete;; all checksums are correct

;; stop cassette motor
3ca5 0100f6    ld      bc,0f600h
3ca8 ed49      out     (c),c

;;-------------------------------------------------------
;; clear sound registers
3caa 3e00      ld      a,00h
3cac 060e      ld      b,0eh
3cae 0e00      ld      c,00h

3cb0 cd833f    call    3f83h				; write PSG register
3cb3 3c        inc     a
3cb4 10fa      djnz    3cb0h
;;-------------------------------------------------------

3cb6 cd113d    call    3d11h				; decrypt
3cb9 fb        ei      
3cba e9        jp      (hl)
;;-------------------------------------------------------
;; update check

3cbb f5        push    af
3cbc 3ac53c    ld      a,(3cc5h)
3cbf aa        xor     d
3cc0 32c53c    ld      (3cc5h),a
3cc3 f1        pop     af
3cc4 c9        ret     
;;-------------------------------------------------------

;; checksum so far
3cc5 00        nop     

;;-------------------------------------------------------
;; E = code
;; D = data byte

3cc6 c5        push    bc
3cc7 e5        push    hl
3cc8 f5        push    af

;; %00100000
3cc9 1e20      ld      e,20h

;; get 3 pulses
3ccb cdeb3c    call    3cebh			; get pulse
3cce cded3c    call    3cedh            ; get pulse
3cd1 3e4b      ld      a,4bh
3cd3 bd        cp      l
3cd4 cb13      rl      e
3cd6 30f3      jr      nc,3ccbh

;; get data-byte
;; %00000001
3cd8 1601      ld      d,01h
3cda cdeb3c    call    3cebh			; get pulse
3cdd cded3c    call    3cedh            ; get pulse
3ce0 3e4b      ld      a,4bh
3ce2 bd        cp      l
3ce3 cb12      rl      d
3ce5 30f3      jr      nc,3cdah
3ce7 f1        pop     af
3ce8 e1        pop     hl
3ce9 c1        pop     bc
3cea c9        ret     
;;-------------------------------------------------------

3ceb 2e00      ld      l,00h
3ced c5        push    bc
3cee 06f5      ld      b,0f5h
3cf0 ed48      in      c,(c)
3cf2 2c        inc     l
3cf3 ed78      in      a,(c)
3cf5 a9        xor     c
3cf6 f2f23c    jp      p,3cf2h
3cf9 c1        pop     bc
3cfa c9        ret     
;;-------------------------------------------------------

3cfb 3e07      ld      a,07h
3cfd 32c53f    ld      (3fc5h),a
3d00 32ca3f    ld      (3fcah),a
3d03 32cf3f    ld      (3fcfh),a
3d06 3ad53f    ld      a,(3fd5h)
3d09 3d        dec     a
3d0a f8        ret     m

3d0b 32d53f    ld      (3fd5h),a
3d0e 1e01      ld      e,01h
3d10 c9        ret     
;;-------------------------------------------------------

3d11 c5        push    bc
3d12 e5        push    hl
3d13 21004f    ld      hl,4f00h
3d16 010041    ld      bc,4100h
3d19 7e        ld      a,(hl)
3d1a ee5c      xor     5ch
3d1c 77        ld      (hl),a
3d1d 23        inc     hl
3d1e 0b        dec     bc
3d1f 78        ld      a,b
3d20 b1        or      c
3d21 20f6      jr      nz,3d19h
3d23 e1        pop     hl
3d24 c1        pop     bc
3d25 c9        ret     
;;-------------------------------------------------------
;; A = channel number; stored in bits 1,0 of code
;; D = data byte read
;; E = code
3d26 f5        push    af
3d27 c5        push    bc
3d28 d5        push    de
3d29 e5        push    hl
3d2a 32d03f    ld      (3fd0h),a

3d2d fd21bc3f  ld      iy,3fbch
3d31 010500    ld      bc,0005h

;; IY = IY + (BC*A)
3d34 fd09      add     iy,bc
3d36 3d        dec     a
3d37 20fb      jr      nz,3d34h

;; IY = address of channel's data
3d39 cd453e    call    3e45h
3d3c e1        pop     hl
3d3d d1        pop     de
3d3e c1        pop     bc
3d3f f1        pop     af

;; continue to fetch bytes
3d40 c35c3c    jp      3c5ch

;;-------------------------------------------------------


3d43 c5        push    bc
3d44 0110f6    ld      bc,0f610h
3d47 ed49      out     (c),c
3d49 c1        pop     bc
3d4a c9        ret     
;;-------------------------------------------------------
3d4b f3        di      
3d4c 0100f6    ld      bc,0f600h		;; stop motor
3d4f ed49      out     (c),c
3d51 cdc23d    call    3dc2h
;;-------------------------------------------------------


3d54 1d        dec     e
3d55 0606      ld      b,06h
3d57 1c        inc     e
3d58 010606    ld      bc,0606h
3d5b 1c        inc     e
3d5c 02        ld      (bc),a
3d5d 00        nop     
3d5e 00        nop     
3d5f 0e01      ld      c,01h
3d61 0f        rrca    
3d62 02        ld      (bc),a
3d63 04        inc     b
3d64 00        nop     
3d65 0c        inc     c
3d66 1f        rra     
3d67 07        rlca    
3d68 07        rlca    
3d69 2d        dec     l
3d6a 45        ld      b,l
3d6b 52        ld      d,d
3d6c 52        ld      d,d
3d6d 4f        ld      c,a
3d6e 52        ld      d,d
3d6f 2d        dec     l
3d70 1f        rra     
3d71 05        dec     b
3d72 0f        rrca    
3d73 50        ld      d,b
3d74 6c        ld      l,h
3d75 65        ld      h,l
3d76 61        ld      h,c
3d77 73        ld      (hl),e
3d78 65        ld      h,l
3d79 2052      jr      nz,3dcdh
3d7b 65        ld      h,l
3d7c 73        ld      (hl),e
3d7d 65        ld      h,l
3d7e 74        ld      (hl),h
3d7f 1f        rra     
3d80 09        add     hl,bc
3d81 11416e    ld      de,6e41h
3d84 64        ld      h,h
3d85 1f        rra     
3d86 0613      ld      b,13h
3d88 54        ld      d,h
3d89 72        ld      (hl),d
3d8a 79        ld      a,c
3d8b 2041      jr      nz,3dceh
3d8d 67        ld      h,a
3d8e 61        ld      h,c
3d8f 69        ld      l,c
3d90 6e        ld      l,(hl)
3d91 ff        rst     38h
3d92 0606      ld      b,06h
3d94 21b63d    ld      hl,3db6h
3d97 7e        ld      a,(hl)
3d98 23        inc     hl
3d99 4e        ld      c,(hl)
3d9a 23        inc     hl
3d9b cd833f    call    3f83h				; write PSG register
3d9e 10f7      djnz    3d97h
3da0 fb        ei      
3da1 0e3e      ld      c,3eh
3da3 79        ld      a,c
3da4 ee03      xor     03h
3da6 4f        ld      c,a
3da7 3e07      ld      a,07h
3da9 cd833f    call    3f83h				; write PSG register
3dac 11ffff    ld      de,0ffffh
3daf 1b        dec     de
3db0 7b        ld      a,e
3db1 b2        or      d
3db2 20fb      jr      nz,3dafh
3db4 18ed      jr      3da3h
3db6 00        nop     
3db7 be        cp      (hl)
3db8 010102    ld      bc,0201h
3dbb be        cp      (hl)
3dbc 03        inc     bc
3dbd 02        ld      (bc),a
3dbe 08        ex      af,af'
3dbf 0f        rrca    
3dc0 09        add     hl,bc
3dc1 0f        rrca    
3dc2 e1        pop     hl

;; display message
3dc3 7e        ld      a,(hl)
3dc4 23        inc     hl
3dc5 feff      cp      0ffh
3dc7 c45abb    call    nz,0bb5ah
3dca 20f7      jr      nz,3dc3h

3dcc e5        push    hl
3dcd c9        ret     
;;-------------------------------------------------------

3dce 3ad13f    ld      a,(3fd1h)
3dd1 3d        dec     a
3dd2 2004      jr      nz,3dd8h
3dd4 cdc63c    call    3cc6h				; get byte
3dd7 c9        ret     

3dd8 fd6e00    ld      l,(iy+00h)
3ddb fd6601    ld      h,(iy+01h)
3dde 56        ld      d,(hl)
3ddf 3ad03f    ld      a,(3fd0h)
3de2 5f        ld      e,a
3de3 cde53a    call    3ae5h
3de6 23        inc     hl
3de7 fd7500    ld      (iy+00h),l
3dea fd7401    ld      (iy+01h),h
3ded c9        ret     

3dee 3ad13f    ld      a,(3fd1h)
3df1 3d        dec     a
3df2 c8        ret     z

3df3 3ad43f    ld      a,(3fd4h)
3df6 feff      cp      0ffh
3df8 2826      jr      z,3e20h
3dfa a7        and     a
3dfb 201f      jr      nz,3e1ch
3dfd cda7bc    call    0bca7h
3e00 f3        di      
3e01 3e01      ld      a,01h
3e03 32be3f    ld      (3fbeh),a
3e06 32bf3f    ld      (3fbfh),a
3e09 32c03f    ld      (3fc0h),a
3e0c 1600      ld      d,00h
3e0e 1e01      ld      e,01h
3e10 cde53a    call    3ae5h
3e13 1c        inc     e
3e14 cde53a    call    3ae5h
3e17 1c        inc     e
3e18 cde53a    call    3ae5h
3e1b c9        ret     

3e1c 3d        dec     a
3e1d 32d43f    ld      (3fd4h),a
3e20 dde5      push    ix
3e22 d1        pop     de
3e23 dd6e2e    ld      l,(ix+2eh)
3e26 dd662f    ld      h,(ix+2fh)
3e29 19        add     hl,de
3e2a 22c13f    ld      (3fc1h),hl
3e2d dd6e30    ld      l,(ix+30h)
3e30 dd6631    ld      h,(ix+31h)
3e33 19        add     hl,de
3e34 22c63f    ld      (3fc6h),hl
3e37 dd6e32    ld      l,(ix+32h)
3e3a dd6633    ld      h,(ix+33h)
3e3d 19        add     hl,de
3e3e 22cb3f    ld      (3fcbh),hl
3e41 c9        ret     

;;-------------------------------------------------------

;; get byte
3e42 cdce3d    call    3dceh

;;-------------------------------------------------------
;; process sound data
;; IY = address of channel data
;; D = data byte
;; E = code byte
;; 
;; lower 4 bits of data:
;; 0d = code, upper 4 bits define 4 bit data, do not stop getting music data
;; 0e = code, upper 4 bits define 4 bit data, do not stop getting music data
;; 0f = code, upper 4 bits of data = f, stop
;; 0f = code, upper 4 bits of data != f, continue
 
;; none of the above, stop getting music data

3e45 3e0f      ld      a,0fh
3e47 a2        and     d
3e48 4f        ld      c,a
;; C = lower 4 bits

3e49 3ef0      ld      a,0f0h
3e4b a2        and     d
3e4c 0f        rrca    
3e4d 0f        rrca    
3e4e 0f        rrca    
3e4f 0f        rrca    
3e50 47        ld      b,a
;; B = upper 4 bits

3e51 3e0f      ld      a,0fh
3e53 a2        and     d
3e54 fe0d      cp      0dh				
3e56 2005      jr      nz,3e5dh

3e58 fd7002    ld      (iy+02h),b

;; get additional byte
3e5b 18e5      jr      3e42h  

;;-------------------------------------------------------

3e5d fe0e      cp      0eh				
3e5f 200e      jr      nz,3e6fh
;; 0x0e code

3e61 3ef0      ld      a,0f0h
3e63 a2        and     d
3e64 fef0      cp      0f0h
3e66 2002      jr      nz,3e6ah

3e68 d610      sub     10h
3e6a fd7703    ld      (iy+03h),a
;; get additional byte
3e6d 18d3      jr      3e42h

;;-------------------------------------------------------

3e6f fe0f      cp      0fh
3e71 c2c33e    jp      nz,3ec3h
;; 0x0f code

;; bits 7..4 of data define code

3e74 78        ld      a,b
3e75 fe0f      cp      0fh
3e77 caee3d    jp      z,3deeh

3e7a fd7e04    ld      a,(iy+04h)
3e7d fe07      cp      07h
3e7f 28c1      jr      z,3e42h		;; fetch more data
;; 0,1,2,3,4,5,6,8,9,a,b,c,d,e

3e81 fe0e      cp      0eh
3e83 2019      jr      nz,3e9eh

;; 0,1,2,3,4,5,6,8,9,a,b,c,d
;; 
3e85 c5        push    bc
3e86 3ad03f    ld      a,(3fd0h)
3e89 47        ld      b,a
3e8a 0e04      ld      c,04h
3e8c cb21      sla     c
3e8e 10fc      djnz    3e8ch
3e90 3ad63f    ld      a,(3fd6h)
3e93 b1        or      c
3e94 32d63f    ld      (3fd6h),a
3e97 4f        ld      c,a
3e98 3e07      ld      a,07h
3e9a cd833f    call    3f83h				; write PSG register
3e9d c1        pop     bc

3e9e 78        ld      a,b
3e9f fe0e      cp      0eh
3ea1 201a      jr      nz,3ebdh

3ea3 c5        push    bc
3ea4 3ad03f    ld      a,(3fd0h)
3ea7 47        ld      b,a
3ea8 0e3b      ld      c,3bh
3eaa 37        scf     
3eab cb11      rl      c
3ead 10fb      djnz    3eaah
3eaf 3ad63f    ld      a,(3fd6h)
3eb2 a1        and     c
3eb3 32d63f    ld      (3fd6h),a
3eb6 4f        ld      c,a
3eb7 3e07      ld      a,07h
3eb9 cd833f    call    3f83h				; write PSG register
3ebc c1        pop     bc

3ebd fd7004    ld      (iy+04h),b
3ec0 c3423e    jp      3e42h
;;-------------------------------------------------------

3ec3 3ad03f    ld      a,(3fd0h)
3ec6 21bd3f    ld      hl,3fbdh

3ec9 23        inc     hl
3eca 3d        dec     a
3ecb 20fc      jr      nz,3ec9h

;; update value?
3ecd fd7e03    ld      a,(iy+03h)
3ed0 80        add     a,b
3ed1 86        add     a,(hl)
3ed2 77        ld      (hl),a

3ed3 fd7e04    ld      a,(iy+04h)
3ed6 fe0e      cp      0eh
3ed8 2825      jr      z,3effh
3eda 79        ld      a,c
3edb a7        and     a
3edc 2821      jr      z,3effh
3ede 21a33f    ld      hl,3fa3h
3ee1 23        inc     hl
3ee2 23        inc     hl
3ee3 3d        dec     a
3ee4 20fb      jr      nz,3ee1h
3ee6 5e        ld      e,(hl)
3ee7 23        inc     hl
3ee8 56        ld      d,(hl)
3ee9 fd4602    ld      b,(iy+02h)
3eec 04        inc     b
3eed fd7e04    ld      a,(iy+04h)
3ef0 fe05      cp      05h
3ef2 2002      jr      nz,3ef6h
3ef4 04        inc     b
3ef5 04        inc     b

3ef6 05        dec     b
3ef7 2809      jr      z,3f02h
3ef9 cb3a      srl     d
3efb cb1b      rr      e
3efd 18f7      jr      3ef6h

3eff 110000    ld      de,0000h
3f02 3ad03f    ld      a,(3fd0h)
3f05 47        ld      b,a
3f06 c5        push    bc
3f07 3efe      ld      a,0feh
3f09 c602      add     a,02h
3f0b 10fc      djnz    3f09h

3f0d 4b        ld      c,e
3f0e cd833f    call    3f83h				; write PSG register
3f11 3c        inc     a
3f12 4a        ld      c,d
3f13 cd833f    call    3f83h				; write PSG register
3f16 c1        pop     bc
3f17 fd7e04    ld      a,(iy+04h)
3f1a fe01      cp      01h
3f1c 2815      jr      z,3f33h
3f1e fe02      cp      02h
3f20 281c      jr      z,3f3eh
3f22 fe04      cp      04h
3f24 2823      jr      z,3f49h
3f26 fe05      cp      05h
3f28 281f      jr      z,3f49h
3f2a fe0e      cp      0eh
3f2c 2839      jr      z,3f67h
3f2e fe07      cp      07h
3f30 2844      jr      z,3f76h
3f32 c9        ret     
;;-------------------------------------------------------

3f33 3e07      ld      a,07h
3f35 3c        inc     a
3f36 10fd      djnz    3f35h

3f38 0e0b      ld      c,0bh
3f3a cd833f    call    3f83h				; write PSG register
3f3d c9        ret     
;;-------------------------------------------------------
;; ?
3f3e 3e07      ld      a,07h
3f40 3c        inc     a
3f41 10fd      djnz    3f40h
3f43 0e0f      ld      c,0fh
3f45 cd833f    call    3f83h				; write PSG register
3f48 c9        ret     
;;-------------------------------------------------------

3f49 3e07      ld      a,07h
3f4b 3c        inc     a
3f4c 10fd      djnz    3f4bh
;; A = channel index 

3f4e 0e10      ld      c,10h
3f50 cd833f    call    3f83h				; write PSG register
3f53 3e0b      ld      a,0bh
3f55 0e00      ld      c,00h
3f57 cd833f    call    3f83h				; write PSG register
3f5a 3c        inc     a
3f5b 0e0c      ld      c,0ch
3f5d cd833f    call    3f83h				; write PSG register
3f60 3c        inc     a
3f61 0e09      ld      c,09h
3f63 cd833f    call    3f83h				; write PSG register
3f66 c9        ret     
;;-------------------------------------------------------


3f67 79        ld      a,c
3f68 0e1f      ld      c,1fh
3f6a 3d        dec     a
3f6b 2802      jr      z,3f6fh
3f6d 0e1d      ld      c,1dh
3f6f 3e06      ld      a,06h
3f71 cd833f    call    3f83h				; write PSG register
3f74 18d3      jr      3f49h

;;-------------------------------------------------------

3f76 3ad53f    ld      a,(3fd5h)
3f79 4f        ld      c,a
3f7a 3e07      ld      a,07h
3f7c 3c        inc     a
3f7d 10fd      djnz    3f7ch
3f7f cd833f    call    3f83h				; write PSG register
3f82 c9        ret     
;;-------------------------------------------------------
;; write PSG register
;; 
;; A = register index
;; C = register data
3f83 f5        push    af
3f84 c5        push    bc
3f85 06f4      ld      b,0f4h
3f87 ed79      out     (c),a
3f89 06f6      ld      b,0f6h
3f8b ed78      in      a,(c)
3f8d f6c0      or      0c0h
3f8f ed79      out     (c),a
3f91 e63f      and     3fh
3f93 ed79      out     (c),a
3f95 06f4      ld      b,0f4h
3f97 ed49      out     (c),c
3f99 06f6      ld      b,0f6h
3f9b 4f        ld      c,a
3f9c f680      or      80h
3f9e ed79      out     (c),a
3fa0 ed49      out     (c),c
3fa2 c1        pop     bc
3fa3 f1        pop     af
3fa4 c9        ret     
;;-------------------------------------------------------

3fa5 bc        cp      h
3fa6 03        inc     bc
3fa7 86        add     a,(hl)
3fa8 03        inc     bc
3fa9 53        ld      d,e
3faa 03        inc     bc
3fab 24        inc     h
3fac 03        inc     bc
3fad f602      or      02h
3faf cc02a4    call    z,0a402h
3fb2 02        ld      (bc),a
3fb3 7e        ld      a,(hl)
3fb4 02        ld      (bc),a
3fb5 5a        ld      e,d
3fb6 02        ld      (bc),a
3fb7 3802      jr      c,3fbbh
3fb9 1802      jr      3fbdh
3fbb fa0164    jp      m,6401h
3fbe 00        nop     
3fbf 00        nop     
3fc0 00        nop     
3fc1 00        nop     
3fc2 00        nop     
3fc3 00        nop     
3fc4 00        nop     
3fc5 00        nop     
3fc6 00        nop     
3fc7 00        nop     
3fc8 00        nop     
3fc9 00        nop     
3fca 00        nop     
3fcb 00        nop     
3fcc 00        nop     
3fcd 00        nop     
3fce 00        nop     
3fcf 00        nop     
3fd0 00        nop     
3fd1 010000    ld      bc,0000h
3fd4 00        nop     
3fd5 0e38      ld      c,38h
3fd7 00        nop     
3fd8 00        nop     
3fd9 00        nop     
3fda 00        nop     
3fdb 00        nop     
3fdc 00        nop     
3fdd 00        nop     
3fde 00        nop     
3fdf 00        nop     
3fe0 00        nop     
3fe1 00        nop     
3fe2 00        nop     
3fe3 00        nop     
3fe4 00        nop     
3fe5 00        nop     
3fe6 00        nop     
3fe7 00        nop     
3fe8 00        nop     
3fe9 00        nop     
3fea 00        nop     
3feb 00        nop     
3fec 00        nop     
3fed 00        nop     
3fee 00        nop     
3fef 00        nop     
3ff0 00        nop     
3ff1 00        nop     
3ff2 00        nop     
3ff3 00        nop     
3ff4 00        nop     
3ff5 00        nop     
3ff6 00        nop     
3ff7 00        nop     
3ff8 00        nop     
3ff9 00        nop     
3ffa 00        nop     
3ffb 00        nop     
3ffc 00        nop     
3ffd 00        nop     
3ffe 00        nop     
3fff 00        nop     
;;-------------------------------------------------------

4000 e5        push    hl
4001 7e        ld      a,(hl)
4002 cd90bb    call    0bb90h
4005 e1        pop     hl
4006 23        inc     hl
4007 56        ld      d,(hl)
4008 23        inc     hl
4009 5e        ld      e,(hl)
400a e5        push    hl
400b eb        ex      de,hl
400c cd75bb    call    0bb75h
400f e1        pop     hl
4010 23        inc     hl
4011 7e        ld      a,(hl)
4012 fe0d      cp      0dh
4014 2806      jr      z,401ch
4016 cd5abb    call    0bb5ah
4019 23        inc     hl
401a 18f5      jr      4011h
401c c9        ret     

401d f5        push    af
401e 3a0438    ld      a,(3804h)
4021 1600      ld      d,00h
4023 5f        ld      e,a
4024 19        add     hl,de
4025 7e        ld      a,(hl)
4026 47        ld      b,a
4027 4f        ld      c,a
4028 f1        pop     af
4029 cd32bc    call    0bc32h
402c c9        ret     

402d 01ae08    ld      bc,08aeh
4030 0b        dec     bc
4031 78        ld      a,b
4032 feff      cp      0ffh
4034 20fa      jr      nz,4030h
4036 1d        dec     e
4037 20f4      jr      nz,402dh
4039 c9        ret     

403a 3e00      ld      a,00h
403c 1e00      ld      e,00h
403e 3e11      ld      a,11h
4040 4f        ld      c,a
4041 0600      ld      b,00h
4043 21ef3a    ld      hl,3aefh
4046 09        add     hl,bc
4047 3600      ld      (hl),00h
4049 215e3b    ld      hl,3b5eh
404c 09        add     hl,bc
404d 3650      ld      (hl),50h
404f 0c        inc     c
4050 f24340    jp      p,4043h
4053 0620      ld      b,20h
4055 21638b    ld      hl,8b63h
4058 7e        ld      a,(hl)
4059 e6fe      and     0feh
405b 77        ld      (hl),a
405c 23        inc     hl
405d 10f9      djnz    4058h
405f 0620      ld      b,20h
4061 21202f    ld      hl,2f20h
4064 3e00      ld      a,00h
4066 77        ld      (hl),a
4067 23        inc     hl
4068 10fc      djnz    4066h
406a 21a0c0    ld      hl,0c0a0h
406d 3e17      ld      a,17h
406f e5        push    hl
4070 0e08      ld      c,08h
4072 e5        push    hl
4073 0650      ld      b,50h
4075 3600      ld      (hl),00h
4077 23        inc     hl
4078 10fb      djnz    4075h
407a e1        pop     hl
407b 110008    ld      de,0800h
407e 19        add     hl,de
407f 0d        dec     c
4080 20f0      jr      nz,4072h
4082 e1        pop     hl
4083 115000    ld      de,0050h
4086 19        add     hl,de
4087 3d        dec     a
4088 20e5      jr      nz,406fh
408a c9        ret     

408b e5        push    hl
408c d5        push    de
408d c5        push    bc
408e f5        push    af
408f 3a3b28    ld      a,(283bh)
4092 c611      add     a,11h
4094 323b28    ld      (283bh),a
4097 3a3a28    ld      a,(283ah)
409a c60d      add     a,0dh
409c 17        rla     
409d 323a28    ld      (283ah),a
40a0 3a3b28    ld      a,(283bh)
40a3 2a1e38    ld      hl,(381eh)
40a6 86        add     a,(hl)
40a7 eeaa      xor     0aah
40a9 cb1f      rr      a
40ab 3c        inc     a
40ac 321e38    ld      (381eh),a
40af cd0dbd    call    0bd0dh
40b2 3a1e38    ld      a,(381eh)
40b5 85        add     a,l
40b6 321e38    ld      (381eh),a
40b9 f1        pop     af
40ba c1        pop     bc
40bb d1        pop     de
40bc e1        pop     hl
40bd 3a1e38    ld      a,(381eh)
40c0 c9        ret     

40c1 3a1928    ld      a,(2819h)
40c4 e603      and     03h
40c6 c8        ret     z

40c7 3e47      ld      a,47h
40c9 cd9141    call    4191h
40cc 2804      jr      z,40d2h
40ce 210d28    ld      hl,280dh
40d1 35        dec     (hl)
40d2 3e3f      ld      a,3fh
40d4 cd9141    call    4191h
40d7 2804      jr      z,40ddh
40d9 210d28    ld      hl,280dh
40dc 34        inc     (hl)
40dd 3a0d28    ld      a,(280dh)
40e0 e61f      and     1fh
40e2 320d28    ld      (280dh),a
40e5 c9        ret     

40e6 a7        and     a
40e7 2a0728    ld      hl,(2807h)
40ea ed5b1228  ld      de,(2812h)
40ee ed5a      adc     hl,de
40f0 220728    ld      (2807h),hl
40f3 3a0928    ld      a,(2809h)
40f6 211428    ld      hl,2814h
40f9 8e        adc     a,(hl)
40fa 320928    ld      (2809h),a
40fd a7        and     a
40fe 3a1528    ld      a,(2815h)
4101 210a28    ld      hl,280ah
4104 8e        adc     a,(hl)
4105 77        ld      (hl),a
4106 3a1628    ld      a,(2816h)
4109 f5        push    af
410a fe00      cp      00h
410c fa1d41    jp      m,411dh
410f f1        pop     af
4110 210b28    ld      hl,280bh
4113 8e        adc     a,(hl)
4114 77        ld      (hl),a
4115 3012      jr      nc,4129h
4117 210c28    ld      hl,280ch
411a 34        inc     (hl)
411b 180c      jr      4129h
411d f1        pop     af
411e 210b28    ld      hl,280bh
4121 8e        adc     a,(hl)
4122 77        ld      (hl),a
4123 3804      jr      c,4129h
4125 210c28    ld      hl,280ch
4128 35        dec     (hl)
4129 3a4428    ld      a,(2844h)
412c fe00      cp      00h
412e f23841    jp      p,4138h
4131 3a2228    ld      a,(2822h)
4134 fe00      cp      00h
4136 2817      jr      z,414fh
4138 2a1e28    ld      hl,(281eh)
413b ed5b1b28  ld      de,(281bh)
413f a7        and     a
4140 ed5a      adc     hl,de
4142 221b28    ld      (281bh),hl
4145 3a2028    ld      a,(2820h)
4148 211d28    ld      hl,281dh
414b 8e        adc     a,(hl)
414c e61f      and     1fh
414e 77        ld      (hl),a
414f c9        ret     

4150 210000    ld      hl,0000h
4153 110000    ld      de,0000h
4156 cd0dbd    call    0bd0dh
4159 c9        ret     

415a 3e09      ld      a,09h
415c cd9141    call    4191h
415f 282f      jr      z,4190h
4161 010303    ld      bc,0303h
4164 cd38bc    call    0bc38h
4167 3e00      ld      a,00h
4169 010000    ld      bc,0000h
416c cd32bc    call    0bc32h
416f 3a2728    ld      a,(2827h)
4172 fe00      cp      00h
4174 201a      jr      nz,4190h
4176 3e01      ld      a,01h
4178 326128    ld      (2861h),a
417b 3e4f      ld      a,4fh
417d cd9141    call    4191h
4180 28f4      jr      z,4176h
4182 010000    ld      bc,0000h
4185 cd38bc    call    0bc38h
4188 cd5041    call    4150h
418b 3e00      ld      a,00h
418d 326128    ld      (2861h),a
4190 c9        ret     

4191 f5        push    af
4192 3a0128    ld      a,(2801h)
4195 fe00      cp      00h
4197 2820      jr      z,41b9h
4199 f1        pop     af
419a 0605      ld      b,05h
419c 21c98c    ld      hl,8cc9h
419f be        cp      (hl)
41a0 2805      jr      z,41a7h
41a2 2b        dec     hl
41a3 10fa      djnz    419fh
41a5 180e      jr      41b5h
41a7 110500    ld      de,0005h
41aa 19        add     hl,de
41ab 7e        ld      a,(hl)
41ac 0601      ld      b,01h
41ae 213038    ld      hl,3830h
41b1 a6        and     (hl)
41b2 2001      jr      nz,41b5h
41b4 05        dec     b
41b5 78        ld      a,b
41b6 fe00      cp      00h
41b8 c9        ret     

41b9 f1        pop     af
41ba cd1ebb    call    0bb1eh
41bd c9        ret     

41be 01df00    ld      bc,00dfh
41c1 5f        ld      e,a
41c2 3a0128    ld      a,(2801h)
41c5 fe00      cp      00h
41c7 c0        ret     nz

41c8 3a8138    ld      a,(3881h)
41cb e6f0      and     0f0h
41cd 47        ld      b,a
41ce a7        and     a
41cf 3a8038    ld      a,(3880h)
41d2 8b        adc     a,e
41d3 27        daa     
41d4 328038    ld      (3880h),a
41d7 3a8138    ld      a,(3881h)
41da ce00      adc     a,00h
41dc 27        daa     
41dd 328138    ld      (3881h),a
41e0 3a8238    ld      a,(3882h)
41e3 ce00      adc     a,00h
41e5 27        daa     
41e6 328238    ld      (3882h),a
41e9 3a8138    ld      a,(3881h)
41ec e6f0      and     0f0h
41ee b8        cp      b
41ef 2806      jr      z,41f7h
41f1 cd4d43    call    434dh
41f4 cd2b43    call    432bh
41f7 3e0f      ld      a,0fh
41f9 2188c8    ld      hl,0c888h
41fc 118238    ld      de,3882h
41ff 320538    ld      (3805h),a
4202 220638    ld      (3806h),hl
4205 010003    ld      bc,0300h
4208 eb        ex      de,hl
4209 e5        push    hl
420a 7e        ld      a,(hl)
420b 1f        rra     
420c 1f        rra     
420d 1f        rra     
420e 1f        rra     
420f e60f      and     0fh
4211 cd2142    call    4221h
4214 e1        pop     hl
4215 e5        push    hl
4216 7e        ld      a,(hl)
4217 e60f      and     0fh
4219 cd2142    call    4221h
421c e1        pop     hl
421d 2b        dec     hl
421e 10e9      djnz    4209h
4220 c9        ret     

4221 5f        ld      e,a
4222 fe00      cp      00h
4224 2009      jr      nz,422fh
4226 79        ld      a,c
4227 fe00      cp      00h
4229 2004      jr      nz,422fh
422b 3e20      ld      a,20h
422d 1820      jr      424fh
422f 3e30      ld      a,30h
4231 83        add     a,e
4232 4f        ld      c,a
4233 181a      jr      424fh
4235 3a5628    ld      a,(2856h)
4238 fe00      cp      00h
423a c0        ret     nz

423b 3a2c38    ld      a,(382ch)
423e fe00      cp      00h
4240 f8        ret     m

4241 3e0f      ld      a,0fh
4243 325628    ld      (2856h),a
4246 2156c8    ld      hl,0c856h
4249 119238    ld      de,3892h
424c c3ff41    jp      41ffh
424f c5        push    bc
4250 d5        push    de
4251 e5        push    hl
4252 f5        push    af
4253 320938    ld      (3809h),a
4256 fe2e      cp      2eh
4258 281f      jr      z,4279h
425a fe20      cp      20h
425c da1f43    jp      c,431fh
425f 281f      jr      z,4280h
4261 fe7f      cp      7fh
4263 2836      jr      z,429bh
4265 fe30      cp      30h
4267 3804      jr      c,426dh
4269 fe3a      cp      3ah
426b 3842      jr      c,42afh
426d f620      or      20h
426f fe61      cp      61h
4271 da7942    jp      c,4279h
4274 fe7b      cp      7bh
4276 daa742    jp      c,42a7h
4279 3e00      ld      a,00h
427b 218187    ld      hl,8781h
427e 1848      jr      42c8h
4280 cd8642    call    4286h
4283 c31f43    jp      431fh
4286 2a0638    ld      hl,(3806h)
4289 3e00      ld      a,00h
428b 0605      ld      b,05h
428d 110008    ld      de,0800h
4290 77        ld      (hl),a
4291 23        inc     hl
4292 77        ld      (hl),a
4293 2b        dec     hl
4294 19        add     hl,de
4295 10f9      djnz    4290h
4297 cdff42    call    42ffh
429a c9        ret     

429b cd0843    call    4308h
429e cd8642    call    4286h
42a1 cd0843    call    4308h
42a4 c31f43    jp      431fh
42a7 a7        and     a
42a8 de60      sbc     a,60h
42aa cdb742    call    42b7h
42ad 1819      jr      42c8h
42af a7        and     a
42b0 de30      sbc     a,30h
42b2 cdbc42    call    42bch
42b5 1811      jr      42c8h
42b7 218187    ld      hl,8781h
42ba 1803      jr      42bfh
42bc 210888    ld      hl,8808h
42bf 5f        ld      e,a
42c0 1600      ld      d,00h
42c2 0605      ld      b,05h
42c4 19        add     hl,de
42c5 10fd      djnz    42c4h
42c7 c9        ret     

42c8 eb        ex      de,hl
42c9 2a0638    ld      hl,(3806h)
42cc 0605      ld      b,05h
42ce 1a        ld      a,(de)
42cf f5        push    af
42d0 f5        push    af
42d1 f5        push    af
42d2 e6f0      and     0f0h
42d4 4f        ld      c,a
42d5 f1        pop     af
42d6 1f        rra     
42d7 1f        rra     
42d8 1f        rra     
42d9 1f        rra     
42da e60f      and     0fh
42dc b1        or      c
42dd cd2443    call    4324h
42e0 23        inc     hl
42e1 f1        pop     af
42e2 e60f      and     0fh
42e4 4f        ld      c,a
42e5 f1        pop     af
42e6 17        rla     
42e7 17        rla     
42e8 17        rla     
42e9 17        rla     
42ea e6f0      and     0f0h
42ec b1        or      c
42ed cd2443    call    4324h
42f0 2b        dec     hl
42f1 d5        push    de
42f2 110008    ld      de,0800h
42f5 19        add     hl,de
42f6 d1        pop     de
42f7 13        inc     de
42f8 10d4      djnz    42ceh
42fa cdff42    call    42ffh
42fd 1820      jr      431fh
42ff 2a0638    ld      hl,(3806h)
4302 23        inc     hl
4303 23        inc     hl
4304 220638    ld      (3806h),hl
4307 c9        ret     

4308 3e00      ld      a,00h
430a 2a0638    ld      hl,(3806h)
430d 110008    ld      de,0800h
4310 0605      ld      b,05h
4312 77        ld      (hl),a
4313 19        add     hl,de
4314 10fc      djnz    4312h
4316 2a0638    ld      hl,(3806h)
4319 2b        dec     hl
431a 2b        dec     hl
431b 220638    ld      (3806h),hl
431e c9        ret     

431f f1        pop     af
4320 e1        pop     hl
4321 d1        pop     de
4322 c1        pop     bc
4323 c9        ret     

4324 4f        ld      c,a
4325 3a0538    ld      a,(3805h)
4328 a1        and     c
4329 77        ld      (hl),a
432a c9        ret     

432b 213243    ld      hl,4332h
432e cdaabc    call    0bcaah
4331 c9        ret     

4332 82        add     a,d
4333 00        nop     
4334 00        nop     
4335 3c        inc     a
4336 00        nop     
4337 00        nop     
4338 0f        rrca    
4339 0a        ld      a,(bc)
433a 00        nop     
433b 3a3338    ld      a,(3833h)
433e a7        and     a
433f de01      sbc     a,01h
4341 27        daa     
4342 323338    ld      (3833h),a
4345 fe00      cp      00h
4347 f25743    jp      p,4357h
434a 06ff      ld      b,0ffh
434c c9        ret     

434d 3a3338    ld      a,(3833h)
4350 a7        and     a
4351 ce01      adc     a,01h
4353 27        daa     
4354 323338    ld      (3833h),a
4357 2174c8    ld      hl,0c874h
435a 220638    ld      (3806h),hl
435d fe00      cp      00h
435f 2809      jr      z,436ah
4361 010001    ld      bc,0100h
4364 213338    ld      hl,3833h
4367 c30942    jp      4209h
436a 3e20      ld      a,20h
436c cd4f42    call    424fh
436f 3e30      ld      a,30h
4371 cd4f42    call    424fh
4374 0600      ld      b,00h
4376 c9        ret     

4377 217e43    ld      hl,437eh
437a cdaabc    call    0bcaah
437d c9        ret     

437e 81        add     a,c
437f 0600      ld      b,00h
4381 00        nop     
4382 00        nop     
4383 1f        rra     
4384 0f        rrca    
4385 00        nop     
4386 00        nop     
4387 c9        ret     

4388 218f43    ld      hl,438fh
438b cdaabc    call    0bcaah
438e c9        ret     

438f 82        add     a,d
4390 00        nop     
4391 00        nop     
4392 220000    ld      (0000h),hl
4395 0f        rrca    
4396 0a        ld      a,(bc)
4397 00        nop     
4398 219f43    ld      hl,439fh
439b cdaabc    call    0bcaah
439e c9        ret     

439f 81        add     a,c
43a0 00        nop     
43a1 00        nop     
43a2 00        nop     
43a3 00        nop     
43a4 17        rla     
43a5 0a        ld      a,(bc)
43a6 1e00      ld      e,00h
43a8 21af43    ld      hl,43afh
43ab cdaabc    call    0bcaah
43ae c9        ret     

43af 02        ld      (bc),a
43b0 00        nop     
43b1 00        nop     
43b2 2003      jr      nz,43b7h
43b4 00        nop     
43b5 0a        ld      a,(bc)
43b6 0b        dec     bc
43b7 00        nop     
43b8 c9        ret     

43b9 21c043    ld      hl,43c0h
43bc cdaabc    call    0bcaah
43bf c9        ret     

43c0 82        add     a,d
43c1 05        dec     b
43c2 01b400    ld      bc,00b4h
43c5 00        nop     
43c6 0f        rrca    
43c7 0c        inc     c
43c8 00        nop     
43c9 21d143    ld      hl,43d1h
43cc cdaabc    call    0bcaah
43cf c9        ret     

43d0 c9        ret     

43d1 84        add     a,h
43d2 00        nop     
43d3 00        nop     
43d4 be        cp      (hl)
43d5 00        nop     
43d6 00        nop     
43d7 0f        rrca    
43d8 0a        ld      a,(bc)
43d9 00        nop     
43da 3a6028    ld      a,(2860h)
43dd fe00      cp      00h
43df c8        ret     z

43e0 3d        dec     a
43e1 326028    ld      (2860h),a
43e4 c9        ret     

43e5 77        ld      (hl),a
43e6 54        ld      d,h
43e7 5d        ld      e,l
43e8 13        inc     de
43e9 edb0      ldir    
43eb c9        ret     

43ec 110008    ld      de,0800h
43ef 77        ld      (hl),a
43f0 19        add     hl,de
43f1 10fc      djnz    43efh
43f3 c9        ret     

43f4 2104d8    ld      hl,0d804h
43f7 014700    ld      bc,0047h
43fa 3ef0      ld      a,0f0h
43fc cde543    call    43e5h
43ff 2104e8    ld      hl,0e804h
4402 014700    ld      bc,0047h
4405 3ef0      ld      a,0f0h
4407 cde543    call    43e5h
440a 2103c0    ld      hl,0c003h
440d 014900    ld      bc,0049h
4410 3e0f      ld      a,0fh
4412 cde543    call    43e5h
4415 2155f8    ld      hl,0f855h
4418 014500    ld      bc,0045h
441b 3e0f      ld      a,0fh
441d cde543    call    43e5h
4420 2102c0    ld      hl,0c002h
4423 0608      ld      b,08h
4425 3e01      ld      a,01h
4427 cdec43    call    43ech
442a 214dc0    ld      hl,0c04dh
442d 0608      ld      b,08h
442f 3e08      ld      a,08h
4431 cdec43    call    43ech
4434 2153c0    ld      hl,0c053h
4437 0604      ld      b,04h
4439 3e08      ld      a,08h
443b 77        ld      (hl),a
443c cb3f      srl     a
443e 19        add     hl,de
443f 10fa      djnz    443bh
4441 23        inc     hl
4442 0604      ld      b,04h
4444 3e08      ld      a,08h
4446 77        ld      (hl),a
4447 cb3f      srl     a
4449 19        add     hl,de
444a 10fa      djnz    4446h
444c 219cc0    ld      hl,0c09ch
444f 0604      ld      b,04h
4451 3e01      ld      a,01h
4453 77        ld      (hl),a
4454 cb27      sla     a
4456 19        add     hl,de
4457 10fa      djnz    4453h
4459 2b        dec     hl
445a 0604      ld      b,04h
445c 3e01      ld      a,01h
445e 77        ld      (hl),a
445f cb27      sla     a
4461 19        add     hl,de
4462 10fa      djnz    445eh
4464 2a3680    ld      hl,(8036h)
4467 cd9144    call    4491h
446a 2a3880    ld      hl,(8038h)
446d cd9144    call    4491h
4470 2a3a80    ld      hl,(803ah)
4473 181c      jr      4491h
4475 2a1880    ld      hl,(8018h)
4478 1817      jr      4491h
447a 2a1a80    ld      hl,(801ah)
447d 1812      jr      4491h
447f 2a1c80    ld      hl,(801ch)
4482 180d      jr      4491h
4484 2a1e80    ld      hl,(801eh)
4487 1808      jr      4491h
4489 2a2080    ld      hl,(8020h)
448c 1803      jr      4491h
448e 2a2280    ld      hl,(8022h)
4491 7e        ld      a,(hl)
4492 320638    ld      (3806h),a
4495 23        inc     hl
4496 7e        ld      a,(hl)
4497 320738    ld      (3807h),a
449a 23        inc     hl
449b 7e        ld      a,(hl)
449c 320538    ld      (3805h),a
449f 23        inc     hl
44a0 7e        ld      a,(hl)
44a1 fe0d      cp      0dh
44a3 2805      jr      z,44aah
44a5 cd4f42    call    424fh
44a8 18f5      jr      449fh
44aa 3e0f      ld      a,0fh
44ac 320538    ld      (3805h),a
44af c9        ret     

44b0 2a2480    ld      hl,(8024h)
44b3 18dc      jr      4491h
44b5 2a2680    ld      hl,(8026h)
44b8 23        inc     hl
44b9 18df      jr      449ah
44bb 2a2880    ld      hl,(8028h)
44be 23        inc     hl
44bf 18d9      jr      449ah
44c1 2a2a80    ld      hl,(802ah)
44c4 18cb      jr      4491h
44c6 2a2c80    ld      hl,(802ch)
44c9 23        inc     hl
44ca 18ce      jr      449ah
44cc 2a2e80    ld      hl,(802eh)
44cf 18c0      jr      4491h
44d1 2a3080    ld      hl,(8030h)
44d4 18bb      jr      4491h
44d6 2a3280    ld      hl,(8032h)
44d9 18b6      jr      4491h
44db 2a3480    ld      hl,(8034h)
44de 18b1      jr      4491h
44e0 c9        ret     

44e1 3a1728    ld      a,(2817h)
44e4 fe00      cp      00h
44e6 2008      jr      nz,44f0h
44e8 3a638b    ld      a,(8b63h)
44eb e603      and     03h
44ed fe03      cp      03h
44ef c0        ret     nz

44f0 3a3538    ld      a,(3835h)
44f3 fe00      cp      00h
44f5 f8        ret     m

44f6 3a2728    ld      a,(2827h)
44f9 fe00      cp      00h
44fb 2004      jr      nz,4501h
44fd 326828    ld      (2868h),a
4500 c9        ret     

4501 3a4428    ld      a,(2844h)
4504 fe00      cp      00h
4506 f0        ret     p

4507 3a6828    ld      a,(2868h)
450a 324528    ld      (2845h),a
450d cd5048    call    4850h
4510 fe75      cp      75h
4512 3805      jr      c,4519h
4514 fe84      cp      84h
4516 300a      jr      nc,4522h
4518 c9        ret     

4519 3e01      ld      a,01h
451b 326828    ld      (2868h),a
451e 324528    ld      (2845h),a
4521 c9        ret     

4522 3a6828    ld      a,(2868h)
4525 fe00      cp      00h
4527 c8        ret     z

4528 3eff      ld      a,0ffh
452a 322228    ld      (2822h),a
452d 323538    ld      (3835h),a
4530 323438    ld      (3834h),a
4533 2a3228    ld      hl,(2832h)
4536 ed5b6428  ld      de,(2864h)
453a a7        and     a
453b ed5a      adc     hl,de
453d cb1c      rr      h
453f cb1d      rr      l
4541 220828    ld      (2808h),hl
4544 3a2e28    ld      a,(282eh)
4547 a7        and     a
4548 ce80      adc     a,80h
454a 320a28    ld      (280ah),a
454d 2a2f28    ld      hl,(282fh)
4550 ed5b6628  ld      de,(2866h)
4554 ed5a      adc     hl,de
4556 cb1c      rr      h
4558 cb1d      rr      l
455a 220b28    ld      (280bh),hl
455d 210a28    ld      hl,280ah
4560 cb1e      rr      (hl)
4562 211628    ld      hl,2816h
4565 7e        ld      a,(hl)
4566 cb17      rl      a
4568 cb1e      rr      (hl)
456a 2b        dec     hl
456b cb1e      rr      (hl)
456d 211428    ld      hl,2814h
4570 7e        ld      a,(hl)
4571 17        rla     
4572 cb1e      rr      (hl)
4574 2b        dec     hl
4575 cb1e      rr      (hl)
4577 2b        dec     hl
4578 cb1e      rr      (hl)
457a 3f        ccf     
457b 2a3228    ld      hl,(2832h)
457e ed5b0828  ld      de,(2808h)
4582 ed52      sbc     hl,de
4584 227428    ld      (2874h),hl
4587 217428    ld      hl,2874h
458a cb16      rl      (hl)
458c 23        inc     hl
458d cb16      rl      (hl)
458f 2b        dec     hl
4590 cb16      rl      (hl)
4592 23        inc     hl
4593 cb16      rl      (hl)
4595 7e        ld      a,(hl)
4596 327228    ld      (2872h),a
4599 3f        ccf     
459a 2a2e28    ld      hl,(282eh)
459d ed5b0a28  ld      de,(280ah)
45a1 ed52      sbc     hl,de
45a3 227628    ld      (2876h),hl
45a6 217628    ld      hl,2876h
45a9 cb16      rl      (hl)
45ab 23        inc     hl
45ac cb16      rl      (hl)
45ae 7e        ld      a,(hl)
45af 327328    ld      (2873h),a
45b2 3e0a      ld      a,0ah
45b4 327b28    ld      (287bh),a
45b7 3eab      ld      a,0abh
45b9 327a28    ld      (287ah),a
45bc 3e07      ld      a,07h
45be 327c28    ld      (287ch),a
45c1 210000    ld      hl,0000h
45c4 221c28    ld      (281ch),hl
45c7 3eff      ld      a,0ffh
45c9 327128    ld      (2871h),a
45cc 3e03      ld      a,03h
45ce 327828    ld      (2878h),a
45d1 cdcd48    call    48cdh
45d4 212328    ld      hl,2823h
45d7 cb16      rl      (hl)
45d9 23        inc     hl
45da cb16      rl      (hl)
45dc 2b        dec     hl
45dd cb16      rl      (hl)
45df 23        inc     hl
45e0 cb16      rl      (hl)
45e2 23        inc     hl
45e3 cb16      rl      (hl)
45e5 23        inc     hl
45e6 cb16      rl      (hl)
45e8 3a2428    ld      a,(2824h)
45eb a7        and     a
45ec 217528    ld      hl,2875h
45ef 9e        sbc     a,(hl)
45f0 f2f645    jp      p,45f6h
45f3 eeff      xor     0ffh
45f5 3c        inc     a
45f6 328828    ld      (2888h),a
45f9 a7        and     a
45fa 3a2628    ld      a,(2826h)
45fd 217728    ld      hl,2877h
4600 9e        sbc     a,(hl)
4601 f20746    jp      p,4607h
4604 eeff      xor     0ffh
4606 3c        inc     a
4607 328928    ld      (2889h),a
460a cda448    call    48a4h
460d 217128    ld      hl,2871h
4610 be        cp      (hl)
4611 3009      jr      nc,461ch
4613 327128    ld      (2871h),a
4616 2a1c28    ld      hl,(281ch)
4619 227d28    ld      (287dh),hl
461c 2a1c28    ld      hl,(281ch)
461f ed5b7a28  ld      de,(287ah)
4623 19        add     hl,de
4624 7c        ld      a,h
4625 e61f      and     1fh
4627 67        ld      h,a
4628 221c28    ld      (281ch),hl
462b 217828    ld      hl,2878h
462e 35        dec     (hl)
462f 20a0      jr      nz,45d1h
4631 2a7d28    ld      hl,(287dh)
4634 221c28    ld      (281ch),hl
4637 217b28    ld      hl,287bh
463a a7        and     a
463b cb1e      rr      (hl)
463d 2b        dec     hl
463e cb1e      rr      (hl)
4640 217c28    ld      hl,287ch
4643 35        dec     (hl)
4644 2814      jr      z,465ah
4646 2a1c28    ld      hl,(281ch)
4649 ed5b7a28  ld      de,(287ah)
464d a7        and     a
464e ed52      sbc     hl,de
4650 7c        ld      a,h
4651 e61f      and     1fh
4653 67        ld      h,a
4654 221c28    ld      (281ch),hl
4657 c3c745    jp      45c7h
465a 3a1428    ld      a,(2814h)
465d 218828    ld      hl,2888h
4660 77        ld      (hl),a
4661 3a1328    ld      a,(2813h)
4664 cb17      rl      a
4666 cb16      rl      (hl)
4668 cb17      rl      a
466a cb16      rl      (hl)
466c cb17      rl      a
466e cb16      rl      (hl)
4670 cb17      rl      a
4672 cb16      rl      (hl)
4674 3a7328    ld      a,(2873h)
4677 cd8449    call    4984h
467a 2a8928    ld      hl,(2889h)
467d 228e28    ld      (288eh),hl
4680 3a1628    ld      a,(2816h)
4683 218828    ld      hl,2888h
4686 77        ld      (hl),a
4687 3a1528    ld      a,(2815h)
468a cb17      rl      a
468c cb16      rl      (hl)
468e cb17      rl      a
4690 cb16      rl      (hl)
4692 cb17      rl      a
4694 cb16      rl      (hl)
4696 cb17      rl      a
4698 cb16      rl      (hl)
469a 3a7228    ld      a,(2872h)
469d cd8449    call    4984h
46a0 2a8928    ld      hl,(2889h)
46a3 ed5b8e28  ld      de,(288eh)
46a7 a7        and     a
46a8 ed52      sbc     hl,de
46aa 7d        ld      a,l
46ab 321f28    ld      (281fh),a
46ae 7c        ld      a,h
46af cb17      rl      a
46b1 7c        ld      a,h
46b2 cb1f      rr      a
46b4 211f28    ld      hl,281fh
46b7 cb1e      rr      (hl)
46b9 47        ld      b,a
46ba cb17      rl      a
46bc 78        ld      a,b
46bd cb1f      rr      a
46bf cb1e      rr      (hl)
46c1 322028    ld      (2820h),a
46c4 cd8843    call    4388h
46c7 c9        ret     

46c8 cd7743    call    4377h
46cb 010800    ld      bc,0008h
46ce 3a8d28    ld      a,(288dh)
46d1 fe04      cp      04h
46d3 2013      jr      nz,46e8h
46d5 0e03      ld      c,03h
46d7 3a1928    ld      a,(2819h)
46da e601      and     01h
46dc 3c        inc     a
46dd 328d28    ld      (288dh),a
46e0 cd8b40    call    408bh
46e3 e61f      and     1fh
46e5 328c28    ld      (288ch),a
46e8 79        ld      a,c
46e9 320b38    ld      (380bh),a
46ec cd0248    call    4802h
46ef 3a8828    ld      a,(2888h)
46f2 21002e    ld      hl,2e00h
46f5 19        add     hl,de
46f6 77        ld      (hl),a
46f7 3a8928    ld      a,(2889h)
46fa 21202e    ld      hl,2e20h
46fd 19        add     hl,de
46fe 77        ld      (hl),a
46ff 3a8a28    ld      a,(288ah)
4702 21602e    ld      hl,2e60h
4705 19        add     hl,de
4706 77        ld      (hl),a
4707 3a8b28    ld      a,(288bh)
470a 21802e    ld      hl,2e80h
470d 19        add     hl,de
470e 77        ld      (hl),a
470f cd8b40    call    408bh
4712 e603      and     03h
4714 218c28    ld      hl,288ch
4717 86        add     a,(hl)
4718 e61f      and     1fh
471a 4f        ld      c,a
471b 21378d    ld      hl,8d37h
471e 09        add     hl,bc
471f 7e        ld      a,(hl)
4720 327628    ld      (2876h),a
4723 21578d    ld      hl,8d57h
4726 09        add     hl,bc
4727 7e        ld      a,(hl)
4728 327728    ld      (2877h),a
472b 21f78c    ld      hl,8cf7h
472e 09        add     hl,bc
472f 7e        ld      a,(hl)
4730 327828    ld      (2878h),a
4733 21178d    ld      hl,8d17h
4736 09        add     hl,bc
4737 7e        ld      a,(hl)
4738 327928    ld      (2879h),a
473b 3a7728    ld      a,(2877h)
473e 17        rla     
473f f5        push    af
4740 f5        push    af
4741 f5        push    af
4742 f5        push    af
4743 0604      ld      b,04h
4745 f1        pop     af
4746 217728    ld      hl,2877h
4749 cb1e      rr      (hl)
474b 2b        dec     hl
474c cb1e      rr      (hl)
474e 10f5      djnz    4745h
4750 3a7928    ld      a,(2879h)
4753 17        rla     
4754 f5        push    af
4755 f5        push    af
4756 f5        push    af
4757 f5        push    af
4758 0604      ld      b,04h
475a f1        pop     af
475b 217928    ld      hl,2879h
475e cb1e      rr      (hl)
4760 2b        dec     hl
4761 cb1e      rr      (hl)
4763 10f5      djnz    475ah
4765 3e00      ld      a,00h
4767 57        ld      d,a
4768 21a02e    ld      hl,2ea0h
476b 19        add     hl,de
476c 77        ld      (hl),a
476d 21c02e    ld      hl,2ec0h
4770 19        add     hl,de
4771 77        ld      (hl),a
4772 21e02e    ld      hl,2ee0h
4775 19        add     hl,de
4776 77        ld      (hl),a
4777 21002f    ld      hl,2f00h
477a 19        add     hl,de
477b 77        ld      (hl),a
477c cd8b40    call    408bh
477f e603      and     03h
4781 4f        ld      c,a
4782 0c        inc     c
4783 0c        inc     c
4784 47        ld      b,a
4785 a7        and     a
4786 3a7628    ld      a,(2876h)
4789 21a02e    ld      hl,2ea0h
478c f5        push    af
478d 19        add     hl,de
478e f1        pop     af
478f 8e        adc     a,(hl)
4790 77        ld      (hl),a
4791 3a7728    ld      a,(2877h)
4794 21c02e    ld      hl,2ec0h
4797 f5        push    af
4798 19        add     hl,de
4799 f1        pop     af
479a 8e        adc     a,(hl)
479b 77        ld      (hl),a
479c a7        and     a
479d 3a7828    ld      a,(2878h)
47a0 21e02e    ld      hl,2ee0h
47a3 f5        push    af
47a4 19        add     hl,de
47a5 f1        pop     af
47a6 8e        adc     a,(hl)
47a7 77        ld      (hl),a
47a8 3a7928    ld      a,(2879h)
47ab 21002f    ld      hl,2f00h
47ae f5        push    af
47af 19        add     hl,de
47b0 f1        pop     af
47b1 8e        adc     a,(hl)
47b2 77        ld      (hl),a
47b3 0d        dec     c
47b4 20cf      jr      nz,4785h
47b6 78        ld      a,b
47b7 17        rla     
47b8 17        rla     
47b9 17        rla     
47ba ee1f      xor     1fh
47bc 327628    ld      (2876h),a
47bf 21202f    ld      hl,2f20h
47c2 19        add     hl,de
47c3 7e        ld      a,(hl)
47c4 e680      and     80h
47c6 47        ld      b,a
47c7 cd8b40    call    408bh
47ca e60f      and     0fh
47cc 1f        rra     
47cd 80        add     a,b
47ce 47        ld      b,a
47cf 3a7628    ld      a,(2876h)
47d2 80        add     a,b
47d3 c608      add     a,08h
47d5 77        ld      (hl),a
47d6 3a8d28    ld      a,(288dh)
47d9 21a02f    ld      hl,2fa0h
47dc 19        add     hl,de
47dd 77        ld      (hl),a
47de 3a8c28    ld      a,(288ch)
47e1 c604      add     a,04h
47e3 e61f      and     1fh
47e5 328c28    ld      (288ch),a
47e8 7b        ld      a,e
47e9 4f        ld      c,a
47ea 0600      ld      b,00h
47ec cdd649    call    49d6h
47ef cdd649    call    49d6h
47f2 3a0b38    ld      a,(380bh)
47f5 4f        ld      c,a
47f6 0d        dec     c
47f7 c2e846    jp      nz,46e8h
47fa c9        ret     

47fb a7        and     a
47fc 218728    ld      hl,2887h
47ff 8e        adc     a,(hl)
4800 77        ld      (hl),a
4801 c9        ret     

4802 111f00    ld      de,001fh
4805 21202f    ld      hl,2f20h
4808 19        add     hl,de
4809 7e        ld      a,(hl)
480a e67f      and     7fh
480c 2818      jr      z,4826h
480e 1d        dec     e
480f 20f4      jr      nz,4805h
4811 1e1f      ld      e,1fh
4813 19        add     hl,de
4814 7e        ld      a,(hl)
4815 e67f      and     7fh
4817 fe0a      cp      0ah
4819 380b      jr      c,4826h
481b 1d        dec     e
481c 20f5      jr      nz,4813h
481e cd8b40    call    408bh
4821 e60f      and     0fh
4823 ce04      adc     a,04h
4825 5f        ld      e,a
4826 c9        ret     

4827 21378d    ld      hl,8d37h
482a 19        add     hl,de
482b 7e        ld      a,(hl)
482c 21a02e    ld      hl,2ea0h
482f 09        add     hl,bc
4830 77        ld      (hl),a
4831 21578d    ld      hl,8d57h
4834 19        add     hl,de
4835 7e        ld      a,(hl)
4836 21c02e    ld      hl,2ec0h
4839 09        add     hl,bc
483a 77        ld      (hl),a
483b 21f78c    ld      hl,8cf7h
483e 19        add     hl,de
483f 7e        ld      a,(hl)
4840 21e02e    ld      hl,2ee0h
4843 09        add     hl,bc
4844 77        ld      (hl),a
4845 21178d    ld      hl,8d17h
4848 19        add     hl,de
4849 7e        ld      a,(hl)
484a 21002f    ld      hl,2f00h
484d 09        add     hl,bc
484e 77        ld      (hl),a
484f c9        ret     

4850 a7        and     a
4851 3a5028    ld      a,(2850h)
4854 215328    ld      hl,2853h
4857 9e        sbc     a,(hl)
4858 3003      jr      nc,485dh
485a eeff      xor     0ffh
485c 3c        inc     a
485d 328928    ld      (2889h),a
4860 3a4e28    ld      a,(284eh)
4863 a7        and     a
4864 215128    ld      hl,2851h
4867 9e        sbc     a,(hl)
4868 327228    ld      (2872h),a
486b 3a4f28    ld      a,(284fh)
486e 57        ld      d,a
486f 215228    ld      hl,2852h
4872 9e        sbc     a,(hl)
4873 3808      jr      c,487dh
4875 5f        ld      e,a
4876 aa        xor     d
4877 cb7f      bit     7,a
4879 204f      jr      nz,48cah
487b 1806      jr      4883h
487d 5f        ld      e,a
487e aa        xor     d
487f cb7f      bit     7,a
4881 2847      jr      z,48cah
4883 7b        ld      a,e
4884 1600      ld      d,00h
4886 e6e0      and     0e0h
4888 2805      jr      z,488fh
488a fee0      cp      0e0h
488c c2ca48    jp      nz,48cah
488f 7b        ld      a,e
4890 217228    ld      hl,2872h
4893 cb16      rl      (hl)
4895 17        rla     
4896 cb16      rl      (hl)
4898 17        rla     
4899 fe00      cp      00h
489b f2a148    jp      p,48a1h
489e eeff      xor     0ffh
48a0 3c        inc     a
48a1 328828    ld      (2888h),a
48a4 3a8828    ld      a,(2888h)
48a7 218928    ld      hl,2889h
48aa be        cp      (hl)
48ab d2b948    jp      nc,48b9h
48ae f5        push    af
48af 3a8928    ld      a,(2889h)
48b2 328828    ld      (2888h),a
48b5 f1        pop     af
48b6 328928    ld      (2889h),a
48b9 3a8928    ld      a,(2889h)
48bc a7        and     a
48bd 218828    ld      hl,2888h
48c0 8e        adc     a,(hl)
48c1 3807      jr      c,48cah
48c3 8e        adc     a,(hl)
48c4 3804      jr      c,48cah
48c6 8e        adc     a,(hl)
48c7 3801      jr      c,48cah
48c9 d0        ret     nc

48ca 3eff      ld      a,0ffh
48cc c9        ret     

48cd 3a1c28    ld      a,(281ch)
48d0 a7        and     a
48d1 ce08      adc     a,08h
48d3 327a28    ld      (287ah),a
48d6 3a1d28    ld      a,(281dh)
48d9 ce00      adc     a,00h
48db e61f      and     1fh
48dd 5f        ld      e,a
48de 1600      ld      d,00h
48e0 21378d    ld      hl,8d37h
48e3 19        add     hl,de
48e4 7e        ld      a,(hl)
48e5 322328    ld      (2823h),a
48e8 21578d    ld      hl,8d57h
48eb 19        add     hl,de
48ec 7e        ld      a,(hl)
48ed 322428    ld      (2824h),a
48f0 21f78c    ld      hl,8cf7h
48f3 19        add     hl,de
48f4 7e        ld      a,(hl)
48f5 322528    ld      (2825h),a
48f8 21178d    ld      hl,8d17h
48fb 19        add     hl,de
48fc 7e        ld      a,(hl)
48fd 322628    ld      (2826h),a
4900 3a5428    ld      a,(2854h)
4903 4f        ld      c,a
4904 0600      ld      b,00h
4906 3a7a28    ld      a,(287ah)
4909 e6f0      and     0f0h
490b 213e88    ld      hl,883eh
490e 09        add     hl,bc
490f be        cp      (hl)
4910 2005      jr      nz,4917h
4912 1c        inc     e
4913 7b        ld      a,e
4914 e61f      and     1fh
4916 5f        ld      e,a
4917 a7        and     a
4918 21378d    ld      hl,8d37h
491b f5        push    af
491c 19        add     hl,de
491d f1        pop     af
491e 7e        ld      a,(hl)
491f 212328    ld      hl,2823h
4922 8e        adc     a,(hl)
4923 77        ld      (hl),a
4924 21578d    ld      hl,8d57h
4927 f5        push    af
4928 19        add     hl,de
4929 f1        pop     af
492a 7e        ld      a,(hl)
492b 212428    ld      hl,2824h
492e 8e        adc     a,(hl)
492f 77        ld      (hl),a
4930 a7        and     a
4931 21f78c    ld      hl,8cf7h
4934 f5        push    af
4935 19        add     hl,de
4936 f1        pop     af
4937 7e        ld      a,(hl)
4938 212528    ld      hl,2825h
493b 8e        adc     a,(hl)
493c 77        ld      (hl),a
493d 21178d    ld      hl,8d17h
4940 f5        push    af
4941 19        add     hl,de
4942 f1        pop     af
4943 7e        ld      a,(hl)
4944 212628    ld      hl,2826h
4947 8e        adc     a,(hl)
4948 77        ld      (hl),a
4949 0d        dec     c
494a f20649    jp      p,4906h
494d 212428    ld      hl,2824h
4950 7e        ld      a,(hl)
4951 17        rla     
4952 cb1e      rr      (hl)
4954 2b        dec     hl
4955 cb1e      rr      (hl)
4957 214d28    ld      hl,284dh
495a cb1e      rr      (hl)
495c 212428    ld      hl,2824h
495f 7e        ld      a,(hl)
4960 17        rla     
4961 cb1e      rr      (hl)
4963 2b        dec     hl
4964 cb1e      rr      (hl)
4966 214d28    ld      hl,284dh
4969 cb1e      rr      (hl)
496b 3a2628    ld      a,(2826h)
496e 17        rla     
496f 212628    ld      hl,2826h
4972 cb1e      rr      (hl)
4974 2b        dec     hl
4975 cb1e      rr      (hl)
4977 3a2628    ld      a,(2826h)
497a 17        rla     
497b 212628    ld      hl,2826h
497e cb1e      rr      (hl)
4980 2b        dec     hl
4981 cb1e      rr      (hl)
4983 c9        ret     

4984 328b28    ld      (288bh),a
4987 3e00      ld      a,00h
4989 328928    ld      (2889h),a
498c 328a28    ld      (288ah),a
498f 328c28    ld      (288ch),a
4992 3a8828    ld      a,(2888h)
4995 fe00      cp      00h
4997 f2a949    jp      p,49a9h
499a eeff      xor     0ffh
499c 3c        inc     a
499d 328828    ld      (2888h),a
49a0 3a8b28    ld      a,(288bh)
49a3 eeff      xor     0ffh
49a5 3c        inc     a
49a6 328b28    ld      (288bh),a
49a9 3a8b28    ld      a,(288bh)
49ac fe00      cp      00h
49ae f2b649    jp      p,49b6h
49b1 3eff      ld      a,0ffh
49b3 328c28    ld      (288ch),a
49b6 0608      ld      b,08h
49b8 218828    ld      hl,2888h
49bb cb1e      rr      (hl)
49bd 300b      jr      nc,49cah
49bf 2a8b28    ld      hl,(288bh)
49c2 ed5b8928  ld      de,(2889h)
49c6 19        add     hl,de
49c7 228928    ld      (2889h),hl
49ca a7        and     a
49cb 218b28    ld      hl,288bh
49ce cb16      rl      (hl)
49d0 23        inc     hl
49d1 cb16      rl      (hl)
49d3 10e3      djnz    49b8h
49d5 c9        ret     

49d6 a7        and     a
49d7 21a02e    ld      hl,2ea0h
49da f5        push    af
49db 09        add     hl,bc
49dc f1        pop     af
49dd 7e        ld      a,(hl)
49de 21002e    ld      hl,2e00h
49e1 f5        push    af
49e2 09        add     hl,bc
49e3 f1        pop     af
49e4 8e        adc     a,(hl)
49e5 77        ld      (hl),a
49e6 21c02e    ld      hl,2ec0h
49e9 f5        push    af
49ea 09        add     hl,bc
49eb f1        pop     af
49ec 7e        ld      a,(hl)
49ed 21202e    ld      hl,2e20h
49f0 f5        push    af
49f1 09        add     hl,bc
49f2 f1        pop     af
49f3 8e        adc     a,(hl)
49f4 77        ld      (hl),a
49f5 a7        and     a
49f6 21e02e    ld      hl,2ee0h
49f9 f5        push    af
49fa 09        add     hl,bc
49fb f1        pop     af
49fc 7e        ld      a,(hl)
49fd 21402e    ld      hl,2e40h
4a00 f5        push    af
4a01 09        add     hl,bc
4a02 f1        pop     af
4a03 8e        adc     a,(hl)
4a04 77        ld      (hl),a
4a05 21002f    ld      hl,2f00h
4a08 f5        push    af
4a09 09        add     hl,bc
4a0a f1        pop     af
4a0b 7e        ld      a,(hl)
4a0c 21602e    ld      hl,2e60h
4a0f f5        push    af
4a10 09        add     hl,bc
4a11 f1        pop     af
4a12 8e        adc     a,(hl)
4a13 77        ld      (hl),a
4a14 f5        push    af
4a15 21002f    ld      hl,2f00h
4a18 09        add     hl,bc
4a19 7e        ld      a,(hl)
4a1a fe00      cp      00h
4a1c fa234a    jp      m,4a23h
4a1f 3e00      ld      a,00h
4a21 1802      jr      4a25h
4a23 3eff      ld      a,0ffh
4a25 47        ld      b,a
4a26 f1        pop     af
4a27 78        ld      a,b
4a28 0600      ld      b,00h
4a2a 21802e    ld      hl,2e80h
4a2d f5        push    af
4a2e 09        add     hl,bc
4a2f f1        pop     af
4a30 8e        adc     a,(hl)
4a31 77        ld      (hl),a
4a32 c9        ret     

4a33 3a4428    ld      a,(2844h)
4a36 fe00      cp      00h
4a38 fa584a    jp      m,4a58h
4a3b 3a2228    ld      a,(2822h)
4a3e fe00      cp      00h
4a40 2016      jr      nz,4a58h
4a42 3a4228    ld      a,(2842h)
4a45 fe00      cp      00h
4a47 200f      jr      nz,4a58h
4a49 3e00      ld      a,00h
4a4b 321628    ld      (2816h),a
4a4e 321528    ld      (2815h),a
4a51 321428    ld      (2814h),a
4a54 321328    ld      (2813h),a
4a57 c9        ret     

4a58 3a1928    ld      a,(2819h)
4a5b e60f      and     0fh
4a5d 2815      jr      z,4a74h
4a5f fe03      cp      03h
4a61 2811      jr      z,4a74h
4a63 fe05      cp      05h
4a65 280d      jr      z,4a74h
4a67 fe08      cp      08h
4a69 2809      jr      z,4a74h
4a6b fe0b      cp      0bh
4a6d 2805      jr      z,4a74h
4a6f fe0d      cp      0dh
4a71 2801      jr      z,4a74h
4a73 c9        ret     

4a74 2a1528    ld      hl,(2815h)
4a77 ed5ba628  ld      de,(28a6h)
4a7b 19        add     hl,de
4a7c 221528    ld      (2815h),hl
4a7f 3a4428    ld      a,(2844h)
4a82 fe00      cp      00h
4a84 f2154c    jp      p,4c15h
4a87 3a5728    ld      a,(2857h)
4a8a fe00      cp      00h
4a8c c2154c    jp      nz,4c15h
4a8f 3e15      ld      a,15h
4a91 cd9141    call    4191h
4a94 ca154c    jp      z,4c15h
4a97 cda04c    call    4ca0h
4a9a cd9843    call    4398h
4a9d 110400    ld      de,0004h
4aa0 3a2228    ld      a,(2822h)
4aa3 fe00      cp      00h
4aa5 2801      jr      z,4aa8h
4aa7 1c        inc     e
4aa8 3a0d28    ld      a,(280dh)
4aab 4f        ld      c,a
4aac 0600      ld      b,00h
4aae 21f78c    ld      hl,8cf7h
4ab1 09        add     hl,bc
4ab2 7e        ld      a,(hl)
4ab3 327028    ld      (2870h),a
4ab6 21178d    ld      hl,8d17h
4ab9 09        add     hl,bc
4aba 7e        ld      a,(hl)
4abb 1f        rra     
4abc 217028    ld      hl,2870h
4abf cb1e      rr      (hl)
4ac1 1d        dec     e
4ac2 20f7      jr      nz,4abbh
4ac4 e601      and     01h
4ac6 eeff      xor     0ffh
4ac8 3c        inc     a
4ac9 327128    ld      (2871h),a
4acc 1e04      ld      e,04h
4ace 3a2228    ld      a,(2822h)
4ad1 fe00      cp      00h
4ad3 2801      jr      z,4ad6h
4ad5 1c        inc     e
4ad6 21378d    ld      hl,8d37h
4ad9 09        add     hl,bc
4ada 7e        ld      a,(hl)
4adb 327228    ld      (2872h),a
4ade 21578d    ld      hl,8d57h
4ae1 09        add     hl,bc
4ae2 7e        ld      a,(hl)
4ae3 1f        rra     
4ae4 217228    ld      hl,2872h
4ae7 cb1e      rr      (hl)
4ae9 217f28    ld      hl,287fh
4aec cb1e      rr      (hl)
4aee 1d        dec     e
4aef 20f2      jr      nz,4ae3h
4af1 e601      and     01h
4af3 eeff      xor     0ffh
4af5 3c        inc     a
4af6 327328    ld      (2873h),a
4af9 a7        and     a
4afa 3a1228    ld      a,(2812h)
4afd 217f28    ld      hl,287fh
4b00 8e        adc     a,(hl)
4b01 321228    ld      (2812h),a
4b04 3a1328    ld      a,(2813h)
4b07 217228    ld      hl,2872h
4b0a 8e        adc     a,(hl)
4b0b 321328    ld      (2813h),a
4b0e 3a1428    ld      a,(2814h)
4b11 23        inc     hl
4b12 8e        adc     a,(hl)
4b13 321428    ld      (2814h),a
4b16 a7        and     a
4b17 3a1528    ld      a,(2815h)
4b1a 217028    ld      hl,2870h
4b1d 8e        adc     a,(hl)
4b1e 321528    ld      (2815h),a
4b21 3a1628    ld      a,(2816h)
4b24 23        inc     hl
4b25 8e        adc     a,(hl)
4b26 321628    ld      (2816h),a
4b29 3a1928    ld      a,(2819h)
4b2c e60f      and     0fh
4b2e fe03      cp      03h
4b30 ca154c    jp      z,4c15h
4b33 fe0b      cp      0bh
4b35 ca154c    jp      z,4c15h
4b38 3e00      ld      a,00h
4b3a 327928    ld      (2879h),a
4b3d a7        and     a
4b3e 211c28    ld      hl,281ch
4b41 9e        sbc     a,(hl)
4b42 327e28    ld      (287eh),a
4b45 3a0d28    ld      a,(280dh)
4b48 23        inc     hl
4b49 9e        sbc     a,(hl)
4b4a 5f        ld      e,a
4b4b 3a7e28    ld      a,(287eh)
4b4e a7        and     a
4b4f ce08      adc     a,08h
4b51 327e28    ld      (287eh),a
4b54 7b        ld      a,e
4b55 ce00      adc     a,00h
4b57 e61f      and     1fh
4b59 5f        ld      e,a
4b5a 1600      ld      d,00h
4b5c 21378d    ld      hl,8d37h
4b5f 19        add     hl,de
4b60 7e        ld      a,(hl)
4b61 327a28    ld      (287ah),a
4b64 21578d    ld      hl,8d57h
4b67 19        add     hl,de
4b68 7e        ld      a,(hl)
4b69 327828    ld      (2878h),a
4b6c 010e00    ld      bc,000eh
4b6f 3a7e28    ld      a,(287eh)
4b72 e6f0      and     0f0h
4b74 213e88    ld      hl,883eh
4b77 09        add     hl,bc
4b78 be        cp      (hl)
4b79 2005      jr      nz,4b80h
4b7b 1c        inc     e
4b7c 7b        ld      a,e
4b7d e61f      and     1fh
4b7f 5f        ld      e,a
4b80 21378d    ld      hl,8d37h
4b83 19        add     hl,de
4b84 7e        ld      a,(hl)
4b85 a7        and     a
4b86 217a28    ld      hl,287ah
4b89 8e        adc     a,(hl)
4b8a 77        ld      (hl),a
4b8b 21578d    ld      hl,8d57h
4b8e f5        push    af
4b8f 19        add     hl,de
4b90 f1        pop     af
4b91 7e        ld      a,(hl)
4b92 217828    ld      hl,2878h
4b95 8e        adc     a,(hl)
4b96 77        ld      (hl),a
4b97 0d        dec     c
4b98 f26f4b    jp      p,4b6fh
4b9b 3a7828    ld      a,(2878h)
4b9e 17        rla     
4b9f 217828    ld      hl,2878h
4ba2 cb1e      rr      (hl)
4ba4 217a28    ld      hl,287ah
4ba7 cb1e      rr      (hl)
4ba9 3a7828    ld      a,(2878h)
4bac fe00      cp      00h
4bae f2b64b    jp      p,4bb6h
4bb1 3eff      ld      a,0ffh
4bb3 327928    ld      (2879h),a
4bb6 a7        and     a
4bb7 3a1e28    ld      a,(281eh)
4bba 327d28    ld      (287dh),a
4bbd 217a28    ld      hl,287ah
4bc0 8e        adc     a,(hl)
4bc1 321e28    ld      (281eh),a
4bc4 3a1f28    ld      a,(281fh)
4bc7 327b28    ld      (287bh),a
4bca 217828    ld      hl,2878h
4bcd 8e        adc     a,(hl)
4bce 321f28    ld      (281fh),a
4bd1 3a2028    ld      a,(2820h)
4bd4 327c28    ld      (287ch),a
4bd7 217928    ld      hl,2879h
4bda 8e        adc     a,(hl)
4bdb 322028    ld      (2820h),a
4bde 3a7c28    ld      a,(287ch)
4be1 0606      ld      b,06h
4be3 57        ld      d,a
4be4 17        rla     
4be5 7a        ld      a,d
4be6 1f        rra     
4be7 217b28    ld      hl,287bh
4bea cb1e      rr      (hl)
4bec 217d28    ld      hl,287dh
4bef cb1e      rr      (hl)
4bf1 10f0      djnz    4be3h
4bf3 327c28    ld      (287ch),a
4bf6 3a1e28    ld      a,(281eh)
4bf9 217d28    ld      hl,287dh
4bfc a7        and     a
4bfd 9e        sbc     a,(hl)
4bfe 321e28    ld      (281eh),a
4c01 3a1f28    ld      a,(281fh)
4c04 217b28    ld      hl,287bh
4c07 9e        sbc     a,(hl)
4c08 321f28    ld      (281fh),a
4c0b 3a2028    ld      a,(2820h)
4c0e 217c28    ld      hl,287ch
4c11 9e        sbc     a,(hl)
4c12 322028    ld      (2820h),a
4c15 3a1228    ld      a,(2812h)
4c18 327028    ld      (2870h),a
4c1b 3a1328    ld      a,(2813h)
4c1e 327128    ld      (2871h),a
4c21 3a1428    ld      a,(2814h)
4c24 0606      ld      b,06h
4c26 57        ld      d,a
4c27 17        rla     
4c28 7a        ld      a,d
4c29 1f        rra     
4c2a 217128    ld      hl,2871h
4c2d cb1e      rr      (hl)
4c2f 2b        dec     hl
4c30 cb1e      rr      (hl)
4c32 10f2      djnz    4c26h
4c34 327228    ld      (2872h),a
4c37 a7        and     a
4c38 2a1228    ld      hl,(2812h)
4c3b ed5b7028  ld      de,(2870h)
4c3f ed52      sbc     hl,de
4c41 221228    ld      (2812h),hl
4c44 3a1428    ld      a,(2814h)
4c47 217228    ld      hl,2872h
4c4a 9e        sbc     a,(hl)
4c4b 321428    ld      (2814h),a
4c4e 3e00      ld      a,00h
4c50 327328    ld      (2873h),a
4c53 3a1628    ld      a,(2816h)
4c56 fe00      cp      00h
4c58 f2604c    jp      p,4c60h
4c5b 3eff      ld      a,0ffh
4c5d 327328    ld      (2873h),a
4c60 2a1528    ld      hl,(2815h)
4c63 227028    ld      (2870h),hl
4c66 3a7328    ld      a,(2873h)
4c69 0608      ld      b,08h
4c6b 57        ld      d,a
4c6c 17        rla     
4c6d 7a        ld      a,d
4c6e 1f        rra     
4c6f 217128    ld      hl,2871h
4c72 cb1e      rr      (hl)
4c74 2b        dec     hl
4c75 cb1e      rr      (hl)
4c77 10f2      djnz    4c6bh
4c79 327228    ld      (2872h),a
4c7c a7        and     a
4c7d 2a1528    ld      hl,(2815h)
4c80 ed5b7028  ld      de,(2870h)
4c84 ed52      sbc     hl,de
4c86 221528    ld      (2815h),hl
4c89 3a7328    ld      a,(2873h)
4c8c 217228    ld      hl,2872h
4c8f 9e        sbc     a,(hl)
4c90 327328    ld      (2873h),a
4c93 c9        ret     

4c94 3a0128    ld      a,(2801h)
4c97 fe00      cp      00h
4c99 c0        ret     nz

4c9a 3e11      ld      a,11h
4c9c 0e00      ld      c,00h
4c9e 182c      jr      4ccch
4ca0 3a0128    ld      a,(2801h)
4ca3 fe00      cp      00h
4ca5 c0        ret     nz

4ca6 3e00      ld      a,00h
4ca8 325728    ld      (2857h),a
4cab 219038    ld      hl,3890h
4cae 7e        ld      a,(hl)
4caf 23        inc     hl
4cb0 b6        or      (hl)
4cb1 23        inc     hl
4cb2 b6        or      (hl)
4cb3 2014      jr      nz,4cc9h
4cb5 2160c8    ld      hl,0c860h
4cb8 220638    ld      (3806h),hl
4cbb 3e30      ld      a,30h
4cbd cd4f42    call    424fh
4cc0 3eff      ld      a,0ffh
4cc2 322c38    ld      (382ch),a
4cc5 325728    ld      (2857h),a
4cc8 c9        ret     

4cc9 3e99      ld      a,99h
4ccb 4f        ld      c,a
4ccc 219038    ld      hl,3890h
4ccf a7        and     a
4cd0 8e        adc     a,(hl)
4cd1 27        daa     
4cd2 77        ld      (hl),a
4cd3 79        ld      a,c
4cd4 23        inc     hl
4cd5 8e        adc     a,(hl)
4cd6 27        daa     
4cd7 77        ld      (hl),a
4cd8 79        ld      a,c
4cd9 23        inc     hl
4cda 8e        adc     a,(hl)
4cdb 27        daa     
4cdc 77        ld      (hl),a
4cdd 2b        dec     hl
4cde b6        or      (hl)
4cdf 2b        dec     hl
4ce0 b6        or      (hl)
4ce1 28d2      jr      z,4cb5h
4ce3 3e00      ld      a,00h
4ce5 325628    ld      (2856h),a
4ce8 c9        ret     

4ce9 210084    ld      hl,8400h
4cec 09        add     hl,bc
4ced a6        and     (hl)
4cee c3274f    jp      4f27h
4cf1 c3ea4e    jp      4eeah
4cf4 cdcd48    call    48cdh
4cf7 3aa728    ld      a,(28a7h)
4cfa fe00      cp      00h
4cfc fc7750    call    m,5077h
4cff 3a1828    ld      a,(2818h)
4d02 fe00      cp      00h
4d04 2857      jr      z,4d5dh
4d06 3e00      ld      a,00h
4d08 322728    ld      (2827h),a
4d0b 322828    ld      (2828h),a
4d0e 3a4428    ld      a,(2844h)
4d11 fe00      cp      00h
4d13 f23d4d    jp      p,4d3dh
4d16 3a5728    ld      a,(2857h)
4d19 fe00      cp      00h
4d1b 2020      jr      nz,4d3dh
4d1d 3e2f      ld      a,2fh
4d1f cd9141    call    4191h
4d22 2819      jr      z,4d3dh
4d24 3eff      ld      a,0ffh
4d26 322728    ld      (2827h),a
4d29 3a1a28    ld      a,(281ah)
4d2c e601      and     01h
4d2e fe00      cp      00h
4d30 280b      jr      z,4d3dh
4d32 3e01      ld      a,01h
4d34 322828    ld      (2828h),a
4d37 cda04c    call    4ca0h
4d3a cda843    call    43a8h
4d3d 3e00      ld      a,00h
4d3f 321828    ld      (2818h),a
4d42 21e94c    ld      hl,4ce9h
4d45 22a238    ld      (38a2h),hl
4d48 2a0e28    ld      hl,(280eh)
4d4b 227228    ld      (2872h),hl
4d4e 3a1128    ld      a,(2811h)
4d51 327628    ld      (2876h),a
4d54 3a1028    ld      a,(2810h)
4d57 32fa38    ld      (38fah),a
4d5a cd934e    call    4e93h
4d5d 21f14c    ld      hl,4cf1h
4d60 22a238    ld      (38a2h),hl
4d63 3a0d28    ld      a,(280dh)
4d66 327628    ld      (2876h),a
4d69 321128    ld      (2811h),a
4d6c 3a2828    ld      a,(2828h)
4d6f fe00      cp      00h
4d71 2808      jr      z,4d7bh
4d73 3eff      ld      a,0ffh
4d75 327628    ld      (2876h),a
4d78 321128    ld      (2811h),a
4d7b a7        and     a
4d7c 3a0a28    ld      a,(280ah)
4d7f 212528    ld      hl,2825h
4d82 8e        adc     a,(hl)
4d83 327928    ld      (2879h),a
4d86 3a4c28    ld      a,(284ch)
4d89 212628    ld      hl,2826h
4d8c 8e        adc     a,(hl)
4d8d 325028    ld      (2850h),a
4d90 3a0d28    ld      a,(280dh)
4d93 4f        ld      c,a
4d94 0600      ld      b,00h
4d96 3a7628    ld      a,(2876h)
4d99 fe00      cp      00h
4d9b f2c54d    jp      p,4dc5h
4d9e 21f78c    ld      hl,8cf7h
4da1 09        add     hl,bc
4da2 7e        ld      a,(hl)
4da3 327b28    ld      (287bh),a
4da6 21178d    ld      hl,8d17h
4da9 09        add     hl,bc
4daa 7e        ld      a,(hl)
4dab 327c28    ld      (287ch),a
4dae 217c28    ld      hl,287ch
4db1 17        rla     
4db2 cb1e      rr      (hl)
4db4 3a7b28    ld      a,(287bh)
4db7 1f        rra     
4db8 217928    ld      hl,2879h
4dbb 8e        adc     a,(hl)
4dbc 77        ld      (hl),a
4dbd 3a7c28    ld      a,(287ch)
4dc0 215028    ld      hl,2850h
4dc3 8e        adc     a,(hl)
4dc4 77        ld      (hl),a
4dc5 217928    ld      hl,2879h
4dc8 cb16      rl      (hl)
4dca 215028    ld      hl,2850h
4dcd cb16      rl      (hl)
4dcf a7        and     a
4dd0 3a0728    ld      a,(2807h)
4dd3 214d28    ld      hl,284dh
4dd6 8e        adc     a,(hl)
4dd7 3a0828    ld      a,(2808h)
4dda 212328    ld      hl,2823h
4ddd 8e        adc     a,(hl)
4dde 5f        ld      e,a
4ddf 324e28    ld      (284eh),a
4de2 3a4b28    ld      a,(284bh)
4de5 212428    ld      hl,2824h
4de8 8e        adc     a,(hl)
4de9 327728    ld      (2877h),a
4dec 324f28    ld      (284fh),a
4def 3a7628    ld      a,(2876h)
4df2 fe00      cp      00h
4df4 f2224e    jp      p,4e22h
4df7 21378d    ld      hl,8d37h
4dfa 09        add     hl,bc
4dfb 7e        ld      a,(hl)
4dfc 327b28    ld      (287bh),a
4dff 21578d    ld      hl,8d57h
4e02 09        add     hl,bc
4e03 7e        ld      a,(hl)
4e04 327c28    ld      (287ch),a
4e07 17        rla     
4e08 217c28    ld      hl,287ch
4e0b cb1e      rr      (hl)
4e0d 217b28    ld      hl,287bh
4e10 cb1e      rr      (hl)
4e12 7b        ld      a,e
4e13 217b28    ld      hl,287bh
4e16 8e        adc     a,(hl)
4e17 5f        ld      e,a
4e18 3a7728    ld      a,(2877h)
4e1b 217c28    ld      hl,287ch
4e1e 8e        adc     a,(hl)
4e1f 327728    ld      (2877h),a
4e22 7b        ld      a,e
4e23 17        rla     
4e24 17        rla     
4e25 17        rla     
4e26 e603      and     03h
4e28 32fa38    ld      (38fah),a
4e2b 321028    ld      (2810h),a
4e2e 327028    ld      (2870h),a
4e31 2160bf    ld      hl,0bf60h
4e34 3a5028    ld      a,(2850h)
4e37 cb3f      srl     a
4e39 cb3f      srl     a
4e3b cb3f      srl     a
4e3d 47        ld      b,a
4e3e 115000    ld      de,0050h
4e41 fe00      cp      00h
4e43 2803      jr      z,4e48h
4e45 19        add     hl,de
4e46 10fd      djnz    4e45h
4e48 227228    ld      (2872h),hl
4e4b 3a4228    ld      a,(2842h)
4e4e fe00      cp      00h
4e50 fa5b4e    jp      m,4e5bh
4e53 3e00      ld      a,00h
4e55 324228    ld      (2842h),a
4e58 c37750    jp      5077h
4e5b 3a2a28    ld      a,(282ah)
4e5e fe00      cp      00h
4e60 2028      jr      nz,4e8ah
4e62 3e01      ld      a,01h
4e64 321828    ld      (2818h),a
4e67 3a7728    ld      a,(2877h)
4e6a 5f        ld      e,a
4e6b 1600      ld      d,00h
4e6d 2a7228    ld      hl,(2872h)
4e70 19        add     hl,de
4e71 3a5028    ld      a,(2850h)
4e74 e607      and     07h
4e76 47        ld      b,a
4e77 110008    ld      de,0800h
4e7a fe00      cp      00h
4e7c 2803      jr      z,4e81h
4e7e 19        add     hl,de
4e7f 10fd      djnz    4e7eh
4e81 227228    ld      (2872h),hl
4e84 220e28    ld      (280eh),hl
4e87 cd934e    call    4e93h
4e8a 3aa728    ld      a,(28a7h)
4e8d fe00      cp      00h
4e8f f47750    call    p,5077h
4e92 c9        ret     

4e93 210884    ld      hl,8408h
4e96 22a638    ld      (38a6h),hl
4e99 21feff    ld      hl,0fffeh
4e9c 22fe4e    ld      (4efeh),hl
4e9f 3a7628    ld      a,(2876h)
4ea2 fe00      cp      00h
4ea4 f2b14e    jp      p,4eb1h
4ea7 210084    ld      hl,8400h
4eaa 22a638    ld      (38a6h),hl
4ead 3e11      ld      a,11h
4eaf 1811      jr      4ec2h
4eb1 fe11      cp      11h
4eb3 380d      jr      c,4ec2h
4eb5 21ee1f    ld      hl,1feeh
4eb8 22fe4e    ld      (4efeh),hl
4ebb 3a7628    ld      a,(2876h)
4ebe ee1f      xor     1fh
4ec0 ce00      adc     a,00h
4ec2 5f        ld      e,a
4ec3 1600      ld      d,00h
4ec5 215d87    ld      hl,875dh
4ec8 19        add     hl,de
4ec9 7e        ld      a,(hl)
4eca 32aa38    ld      (38aah),a
4ecd 216f87    ld      hl,876fh
4ed0 19        add     hl,de
4ed1 7e        ld      a,(hl)
4ed2 32ab38    ld      (38abh),a
4ed5 3a7328    ld      a,(2873h)
4ed8 cb3f      srl     a
4eda cb3f      srl     a
4edc cb3f      srl     a
4ede e607      and     07h
4ee0 ee07      xor     07h
4ee2 327028    ld      (2870h),a
4ee5 010000    ld      bc,0000h
4ee8 1805      jr      4eefh
4eea 3a7a28    ld      a,(287ah)
4eed 4f        ld      c,a
4eee 0c        inc     c
4eef 79        ld      a,c
4ef0 327a28    ld      (287ah),a
4ef3 2aaa38    ld      hl,(38aah)
4ef6 09        add     hl,bc
4ef7 7e        ld      a,(hl)
4ef8 fe00      cp      00h
4efa fa334f    jp      m,4f33h
4efd a7        and     a
4efe feff      cp      0ffh
4f00 21704f    ld      hl,4f70h
4f03 3e10      ld      a,10h
4f05 77        ld      (hl),a
4f06 3e16      ld      a,16h
4f08 23        inc     hl
4f09 77        ld      (hl),a
4f0a 3e01      ld      a,01h
4f0c 23        inc     hl
4f0d 77        ld      (hl),a
4f0e 3e06      ld      a,06h
4f10 23        inc     hl
4f11 77        ld      (hl),a
4f12 cd3e4f    call    4f3eh
4f15 cd744f    call    4f74h
4f18 210050    ld      hl,5000h
4f1b 1100c0    ld      de,0c000h
4f1e 010040    ld      bc,4000h
4f21 edb0      ldir    
4f23 cd3e4f    call    4f3eh
4f26 01b80b    ld      bc,0bb8h
4f29 0b        dec     bc
4f2a 78        ld      a,b
4f2b b1        or      c
4f2c 20fb      jr      nz,4f29h
4f2e 21704f    ld      hl,4f70h
4f31 34        inc     (hl)
4f32 23        inc     hl
4f33 34        inc     (hl)
4f34 23        inc     hl
4f35 34        inc     (hl)
4f36 23        inc     hl
4f37 34        inc     (hl)
4f38 7e        ld      a,(hl)
4f39 fe1f      cp      1fh
4f3b 20e6      jr      nz,4f23h
4f3d c9        ret     

4f3e c5        push    bc
4f3f e5        push    hl
4f40 21704f    ld      hl,4f70h
4f43 0601      ld      b,01h
4f45 4e        ld      c,(hl)
4f46 cd614f    call    4f61h
4f49 0602      ld      b,02h
4f4b 23        inc     hl
4f4c 4e        ld      c,(hl)
4f4d cd614f    call    4f61h
4f50 0606      ld      b,06h
4f52 23        inc     hl
4f53 4e        ld      c,(hl)
4f54 cd614f    call    4f61h
4f57 0607      ld      b,07h
4f59 23        inc     hl
4f5a 4e        ld      c,(hl)
4f5b cd614f    call    4f61h
4f5e e1        pop     hl
4f5f c1        pop     bc
4f60 c9        ret     

4f61 c5        push    bc
4f62 cd19bd    call    0bd19h
4f65 48        ld      c,b
4f66 06bc      ld      b,0bch
4f68 ed49      out     (c),c
4f6a c1        pop     bc
4f6b 06bd      ld      b,0bdh
4f6d ed49      out     (c),c
4f6f c9        ret     

4f70 29        add     hl,hl
4f71 2f        cpl     
4f72 1a        ld      a,(de)
4f73 1f        rra     
4f74 3aee4f    ld      a,(4feeh)
4f77 cd0ebc    call    0bc0eh
4f7a 3aef4f    ld      a,(4fefh)
4f7d 47        ld      b,a
4f7e 4f        ld      c,a
4f7f cd38bc    call    0bc38h
4f82 3e0f      ld      a,0fh
4f84 21ff4f    ld      hl,4fffh
4f87 46        ld      b,(hl)
4f88 48        ld      c,b
4f89 f5        push    af
4f8a e5        push    hl
4f8b cd32bc    call    0bc32h
4f8e e1        pop     hl
4f8f 2b        dec     hl
4f90 f1        pop     af
4f91 3d        dec     a
4f92 f2874f    jp      p,4f87h
4f95 c9        ret     

