;; FORGOTTEN WORLDS
;;
;; level loader
;;
;; IX = load address
;; DE = length
;; A = sync byte
;;
;;
;; - checksum stored on cassette doesn't include final checksum byte; so final byte is added to it
;; - checksum generated from encrypted bytes only.
;; - the final checksum byte is encrypted! it is decrypted to RAM *then* compared
;; - checksum initialised with 0


b001 1805      jr      $b008            ; (+$05)
b003 00        nop     
b004 00        nop     
b005 00        nop     
b006 40        ld      b,b
b007 1a        ld      a,(de)
b008 f3        di      
b009 ed53c0b0  ld      ($b0c0),de
b00d dd22c4b0  ld      ($b0c4),ix
b011 6f        ld      l,a
b012 67        ld      h,a
b013 22b2b0    ld      ($b0b2),hl
b016 af        xor     a
b017 3204b0    ld      ($b004),a
b01a 3e1a      ld      a,$1a
b01c 3207b0    ld      ($b007),a
b01f 21aeb0    ld      hl,$b0ae
b022 22acb0    ld      ($b0ac),hl
b025 3e10      ld      a,$10
b027 06f6      ld      b,$f6
b029 ed79      out     (c),a
b02b 2632      ld      h,$32
b02d 069c      ld      b,$9c
b02f 3e16      ld      a,$16
b031 cde1b0    call    $b0e1
b034 30f5      jr      nc,$b02b         ; (-$0b)
b036 3ec6      ld      a,$c6
b038 b8        cp      b
b039 30f0      jr      nc,$b02b         ; (-$10)
b03b 25        dec     h
b03c 20ef      jr      nz,$b02d         ; (-$11)
b03e 06c9      ld      b,$c9
b040 cde5b0    call    $b0e5
b043 30e6      jr      nc,$b02b         ; (-$1a)
b045 78        ld      a,b
b046 fed4      cp      $d4
b048 30f4      jr      nc,$b03e         ; (-$0c)
b04a cde5b0    call    $b0e5
b04d 30dc      jr      nc,$b02b         ; (-$24)
b04f 00        nop     

b050 dd2105b0  ld      ix,$b005
b054 110200    ld      de,$0002		; sync bytes
b057 ed5f      ld      a,r
b059 0612      ld      b,$12
b05b 2e01      ld      l,$01
b05d 78        ld      a,b
b05e 06d7      ld      b,$d7
b060 cde1b0    call    $b0e1
b063 d214b1    jp      nc,$b114
b066 3ee7      ld      a,$e7
b068 b8        cp      b
b069 cb15      rl      l
b06b 3e00      ld      a,$00
b06d 00        nop     
b06e 3e15      ld      a,$15
b070 d25eb0    jp      nc,$b05e
;; update crc
b073 3a04b0    ld      a,($b004)
b076 85        add     a,l
b077 3204b0    ld      ($b004),a

b07a 65        ld      h,l
b07b 3a07b0    ld      a,($b007)
b07e aa        xor     d
b07f ab        xor     e
b080 00        nop     
b081 00        nop     
b082 00        nop     
b083 00        nop     
b084 ad        xor     l
b085 dd7700    ld      (ix+$00),a
b088 0609      ld      b,$09
b08a cb63      bit     4,e
b08c 280d      jr      z,$b09b          ; (+$0d)
b08e 3a07b0    ld      a,($b007)
b091 c636      add     a,$36
b093 83        add     a,e
b094 92        sub     d
b095 3207b0    ld      ($b007),a
b098 05        dec     b
b099 05        dec     b
b09a 05        dec     b
b09b 3a07b0    ld      a,($b007)
b09e c684      add     a,$84
b0a0 3207b0    ld      ($b007),a
b0a3 dd23      inc     ix
b0a5 1b        dec     de
b0a6 7a        ld      a,d
b0a7 b3        or      e
b0a8 c25bb0    jp      nz,$b05b
b0ab c3aeb0    jp      $b0ae

b0ae 2a05b0    ld      hl,($b005)
b0b1 110101    ld      de,$0101
b0b4 ed52      sbc     hl,de
b0b6 c216b0    jp      nz,$b016
b0b9 21cbb0    ld      hl,$b0cb
b0bc 22acb0    ld      ($b0ac),hl

b0bf 11004a    ld      de,$0				;; length
b0c2 dd210036  ld      ix,$0				;; load address
b0c6 0601      ld      b,$01
b0c8 c35bb0    jp      $b05b

b0cb 1104b1    ld      de,$b104
b0ce ed53acb0  ld      ($b0ac),de
b0d2 ed5f      ld      a,r
b0d4 13        inc     de
b0d5 110100    ld      de,$0001				;; load checksum adjustment
b0d8 dd2103b0  ld      ix,$b003
b0dc 0603      ld      b,$03
b0de c35bb0    jp      $b05b

;;-------------------------------------------------------------------------------------

b0e1 cde7b0    call    $b0e7
b0e4 d0        ret     nc

b0e5 3e16      ld      a,$16
b0e7 3d        dec     a
b0e8 20fd      jr      nz,$b0e7         ; (-$03)
b0ea a7        and     a
b0eb 04        inc     b
b0ec c8        ret     z

b0ed 3ef5      ld      a,$f5
b0ef dbff      in      a,($ff)
b0f1 1f        rra     
b0f2 c8        ret     z

b0f3 a9        xor     c
b0f4 e640      and     $40
b0f6 28f3      jr      z,$b0eb          ; (-$0d)
b0f8 79        ld      a,c
b0f9 2f        cpl     
b0fa 4f        ld      c,a
b0fb 3e00      ld      a,$00
b0fd 00        nop     
b0fe 00        nop     
b0ff c302b1    jp      $b102
b102 37        scf     
b103 c9        ret     

;;-------------------------------------------------------------------------------------

;; H = last byte read

b104 7c        ld      a,h		; last byte read
b105 2103b0    ld      hl,$b003		; checksum read
b108 86        add     a,(hl)		; add
b109 23        inc     hl
b10a be        cp      (hl)		; compare against checksum generated
b10b 2007      jr      nz,$b114      

;; stop cassette motor
b10d af        xor     a
b10e 06f6      ld      b,$f6
b110 ed79      out     (c),a
;; successful load
b112 37        scf     
b113 c9        ret     


;;-------------------------------------------------------------------------------------

;; load fail
b114 a7        and     a
b115 c9        ret     

;;-------------------------------------------------------------------------------------


b25b 110011    ld      de,$1100
b25e ed53232d  ld      ($2d23),de
b262 112fb1    ld      de,$b12f
b265 ed53252d  ld      ($2d25),de
b269 3eff      ld      a,$ff
b26b a7        and     a
b26c fd21c1b3  ld      iy,$b3c1
b270 cc0bb3    call    z,$b30b
b273 3aa914    ld      a,($14a9)
b276 fe00      cp      $00
b278 c8        ret     z

b279 3277b2    ld      ($b277),a
b27c 3a77b2    ld      a,($b277)
b27f a7        and     a
b280 fd211fb3  ld      iy,$b31f
b284 cc05b3    call    z,$b305
b287 fd2140b3  ld      iy,$b340
b28b cdc42c    call    $2cc4
b28e dd210036  ld      ix,$3600
b292 11004a    ld      de,$4a00
b295 3aa914    ld      a,($14a9)
b298 4f        ld      c,a
b299 87        add     a,a
b29a 81        add     a,c
b29b c601      add     a,$01
b29d cd00b0    call    $b000
b2a0 3805      jr      c,$b2a7          ; (+$05)
b2a2 cdf4b2    call    $b2f4
b2a5 18e7      jr      $b28e            ; (-$19)
b2a7 dd2144b8  ld      ix,$b844
b2ab 11bc07    ld      de,$07bc
b2ae 3aa914    ld      a,($14a9)
b2b1 4f        ld      c,a
b2b2 87        add     a,a
b2b3 81        add     a,c
b2b4 c602      add     a,$02
b2b6 cd00b0    call    $b000
b2b9 3805      jr      c,$b2c0          ; (+$05)
b2bb cdf4b2    call    $b2f4
b2be 18e7      jr      $b2a7            ; (-$19)
b2c0 dd2100f0  ld      ix,$f000
b2c4 11000c    ld      de,$0c00
b2c7 3aa914    ld      a,($14a9)
b2ca 4f        ld      c,a
b2cb 87        add     a,a
b2cc 81        add     a,c
b2cd c603      add     a,$03
b2cf cd00b0    call    $b000
b2d2 3805      jr      c,$b2d9          ; (+$05)
b2d4 cdf4b2    call    $b2f4
b2d7 18e7      jr      $b2c0            ; (-$19)
b2d9 fd2161b3  ld      iy,$b361
b2dd cdc42c    call    $2cc4
b2e0 cd15b3    call    $b315
b2e3 11ed5b    ld      de,$5bed
b2e6 ed53232d  ld      ($2d23),de
b2ea 111436    ld      de,$3614
b2ed ed53252d  ld      ($2d25),de
b2f1 c3ae2c    jp      $2cae
b2f4 fd2182b3  ld      iy,$b382
b2f8 cdc42c    call    $2cc4
b2fb cd15b3    call    $b315
b2fe fd2140b3  ld      iy,$b340
b302 c3c42c    jp      $2cc4
b305 cdc42c    call    $2cc4
b308 c315b3    jp      $b315
b30b 3d        dec     a
b30c 326ab2    ld      ($b26a),a
b30f cdc42c    call    $2cc4
b312 cd15b3    call    $b315
b315 06fa      ld      b,$fa
b317 c5        push    bc
b318 cda205    call    $05a2
b31b c1        pop     bc
b31c 10f9      djnz    $b317            ; (-$07)
b31e c9        ret     

b31f 0a        ld      a,(bc)
b320 8a        adc     a,d
b321 52        ld      d,d
b322 45        ld      b,l
b323 57        ld      d,a
b324 49        ld      c,c
b325 4e        ld      c,(hl)
b326 44        ld      b,h
b327 2054      jr      nz,$b37d         ; (+$54)
b329 4f        ld      c,a
b32a 205a      jr      nz,$b386         ; (+$5a)
b32c 45        ld      b,l
b32d 52        ld      d,d
b32e 4f        ld      c,a
b32f 204f      jr      nz,$b380         ; (+$4f)
b331 4e        ld      c,(hl)
b332 2054      jr      nz,$b388         ; (+$54)
b334 41        ld      b,c
b335 50        ld      d,b
b336 45        ld      b,l
b337 2043      jr      nz,$b37c         ; (+$43)
b339 4f        ld      c,a
b33a 55        ld      d,l
b33b 4e        ld      c,(hl)
b33c 54        ld      d,h
b33d 45        ld      b,l
b33e 52        ld      d,d
b33f ff        rst     $38
b340 0a        ld      a,(bc)
b341 8a        adc     a,d
b342 2020      jr      nz,$b364         ; (+$20)
b344 2020      jr      nz,$b366         ; (+$20)
b346 2020      jr      nz,$b368         ; (+$20)
b348 4c        ld      c,h
b349 4f        ld      c,a
b34a 41        ld      b,c
b34b 44        ld      b,h
b34c 49        ld      c,c
b34d 4e        ld      c,(hl)
b34e 47        ld      b,a
b34f 2050      jr      nz,$b3a1         ; (+$50)
b351 4c        ld      c,h
b352 41        ld      b,c
b353 59        ld      e,c
b354 2054      jr      nz,$b3aa         ; (+$54)
b356 41        ld      b,c
b357 50        ld      d,b
b358 45        ld      b,l
b359 2020      jr      nz,$b37b         ; (+$20)
b35b 2020      jr      nz,$b37d         ; (+$20)
b35d 2020      jr      nz,$b37f         ; (+$20)
b35f 20ff      jr      nz,$b360         ; (-$01)
b361 0a        ld      a,(bc)
b362 8a        adc     a,d
b363 2020      jr      nz,$b385         ; (+$20)
b365 2020      jr      nz,$b387         ; (+$20)
b367 2020      jr      nz,$b389         ; (+$20)
b369 2020      jr      nz,$b38b         ; (+$20)
b36b 53        ld      d,e
b36c 54        ld      d,h
b36d 4f        ld      c,a
b36e 50        ld      d,b
b36f 2054      jr      nz,$b3c5         ; (+$54)
b371 48        ld      c,b
b372 45        ld      b,l
b373 2054      jr      nz,$b3c9         ; (+$54)
b375 41        ld      b,c
b376 50        ld      d,b
b377 45        ld      b,l
b378 2020      jr      nz,$b39a         ; (+$20)
b37a 2020      jr      nz,$b39c         ; (+$20)
b37c 2020      jr      nz,$b39e         ; (+$20)
b37e 2020      jr      nz,$b3a0         ; (+$20)
b380 20ff      jr      nz,$b381         ; (-$01)
b382 0a        ld      a,(bc)
b383 8a        adc     a,d
b384 45        ld      b,l
b385 52        ld      d,d
b386 52        ld      d,d
b387 4f        ld      c,a
b388 52        ld      d,d
b389 2052      jr      nz,$b3dd         ; (+$52)
b38b 45        ld      b,l
b38c 57        ld      d,a
b38d 49        ld      c,c
b38e 4e        ld      c,(hl)
b38f 44        ld      b,h
b390 2054      jr      nz,$b3e6         ; (+$54)
b392 4f        ld      c,a
b393 2053      jr      nz,$b3e8         ; (+$53)
b395 54        ld      d,h
b396 41        ld      b,c
b397 52        ld      d,d
b398 54        ld      d,h
b399 204f      jr      nz,$b3ea         ; (+$4f)
b39b 46        ld      b,(hl)
b39c 2042      jr      nz,$b3e0         ; (+$42)
b39e 4c        ld      c,h
b39f 4f        ld      c,a
b3a0 43        ld      b,e
b3a1 4b        ld      c,e
b3a2 ff        rst     $38
b3a3 00        nop     
b3a4 00        nop     
b3a5 00        nop     
b3a6 00        nop     
b3a7 00        nop     
b3a8 00        nop     
b3a9 00        nop     
b3aa 00        nop     
b3ab 00        nop     
b3ac 00        nop     
b3ad 00        nop     
b3ae 00        nop     
b3af 00        nop     
b3b0 00        nop     
b3b1 00        nop     
b3b2 00        nop     
b3b3 00        nop     
b3b4 00        nop     
b3b5 00        nop     
b3b6 95        sub     l
b3b7 95        sub     l
b3b8 00        nop     
b3b9 00        nop     
b3ba 00        nop     
b3bb 00        nop     
b3bc 00        nop     
b3bd 00        nop     
b3be 00        nop     
b3bf 00        nop     
b3c0 00        nop     
b3c1 0a        ld      a,(bc)
b3c2 8a        adc     a,d
b3c3 2020      jr      nz,$b3e5         ; (+$20)
b3c5 2020      jr      nz,$b3e7         ; (+$20)
b3c7 2020      jr      nz,$b3e9         ; (+$20)
b3c9 205a      jr      nz,$b425         ; (+$5a)
b3cb 45        ld      b,l
b3cc 52        ld      d,d
b3cd 4f        ld      c,a
b3ce 2054      jr      nz,$b424         ; (+$54)
b3d0 41        ld      b,c
b3d1 50        ld      d,b
b3d2 45        ld      b,l
b3d3 2043      jr      nz,$b418         ; (+$43)
b3d5 4f        ld      c,a
b3d6 55        ld      d,l
b3d7 4e        ld      c,(hl)
b3d8 54        ld      d,h
b3d9 45        ld      b,l
b3da 52        ld      d,d
b3db 2020      jr      nz,$b3fd         ; (+$20)
b3dd 2020      jr      nz,$b3ff         ; (+$20)
b3df 2020      jr      nz,$b401         ; (+$20)
b3e1 ff        rst     $38
b3e2 00        nop     
b3e3 00        nop     
b3e4 00        nop     
b3e5 00        nop     
b3e6 00        nop     

