/**************************************************************************/
/*                                                                        */
/*            em6502 - An X Based 6502 Emulator & Teaching Aid            */
/*            ------------------------------------------------            */
/*              (c) Neil Pollard, University of Bristol 1994              */
/*                                                                        */
/*            Please read the file README for more information            */
/*                                                                        */
/**************************************************************************/
/* snapshot.c */

/* Snapshot Functions.
 * A snapshot contains all the processor registers
 * and the entire contents of RAM.
 * Saving a snapshot effectively captures the state of the machine
 * ready for reloading at a later date.
 * There is no option to change the filename at present, which is always
 * 'Snapshot.in' for loading and 'Snapshot.out' for saving */

#include <stdio.h>
#include "memory.h"

extern char *progname;

/* Main registers from cpu6502.c */
extern int A, X, Y, PCH, PCL, LB, HB, S;
extern unsigned char NEGATIVE, OVERFLOW, BRK, DECIMAL, IRQD, ZERO, CARRY;

/*======================================================================*/
/* Load a snapshot from disk.
 * No error checking is performed, other than when the file
 * is first opened.
 * Any errors at this stage return "Can't open file" */

void load_snapshot()
{
FILE *fd;
int noread, returncode;

if (fd = fopen("Snapshot.in","r"))
	{
	A = getc(fd);
	X = getc(fd);
	Y = getc(fd);
	PCH = getc(fd);
	PCL = getc(fd);
 	S = getc(fd);
	CARRY = getc(fd);
	ZERO = getc(fd);
	IRQD = getc(fd);
	DECIMAL = getc(fd);
	BRK = getc(fd);
	OVERFLOW = getc(fd);	
	NEGATIVE = getc(fd);
	noread = fread(M, 1, 0x8000, fd);
	returncode = fclose(fd);
	fprintf(stderr,"%s: Read Snapshot, 0x%x bytes\n",progname,noread);

	}
else
	fprintf(stderr,"%s: Can't open snapshot file\n",progname);
}

/*======================================================================*/
/* Save a snapshot to disk.
 * No error checking is performed, other than when the file
 * is first opened for writing.
 * Any errors at this stage return "Can't open file" */

void save_snapshot()
{
FILE *fd;
int nowrite, returncode, put;

if (fd = fopen("Snapshot.out","w"))
	{
	put = putc(A,fd);
	put = putc(X,fd);
	put = putc(Y,fd);
	put = putc(PCH,fd);
	put = putc(PCL,fd);
 	put = putc(S,fd);
	put = putc(CARRY,fd);
	put = putc(ZERO,fd);
	put = putc(IRQD,fd);
	put = putc(DECIMAL,fd);
	put = putc(BRK,fd);
	put = putc(OVERFLOW,fd);	
	put = putc(NEGATIVE,fd);
	nowrite = fwrite(M, 1, 0x8000, fd);
	returncode = fclose(fd);
	fprintf(stderr,"%s: Written Snapshot, 0x%x bytes\n",progname,nowrite);

	}
else
	fprintf(stderr,"%s: Can't open snapshot file for writing\n",progname);
}

/*======================================================================*/
/* TO DO:
 *
 * Add facility to change snapshot name (and integrate it into monitor).
 * Provide full memory snapshot including ROM and paged ROMs.
 * Provide more complete error checking on save and load.
 */
