/**************************************************************************/
/*                                                                        */
/*            em6502 - An X Based 6502 Emulator & Teaching Aid            */
/*            ------------------------------------------------            */
/*              (c) Neil Pollard, University of Bristol 1994              */
/*                                                                        */
/*            Please read the file README for more information            */
/*                                                                        */
/**************************************************************************/
/* decode.c */

#include <strings.h>
#include "decode.h"

/* This function takes a single byte value and returns a mnemonic string
 * and a addressing mode (defined in "decode.h").
 * It is used for disassembly */

void decode(unsigned char ad, unsigned char *addr_mode, char *mnemonic)
{

switch (ad) {
	case 0 : *addr_mode=IMP; strcpy(mnemonic,"BRK"); break;
	case 1 : *addr_mode=INDX; strcpy(mnemonic,"ORA"); break;
	case 5 : *addr_mode=ZP; strcpy(mnemonic,"ORA"); break;
	case 6 : *addr_mode=ZP; strcpy(mnemonic,"ASL"); break;
	case 8 : *addr_mode=IMP; strcpy(mnemonic,"PHP"); break;
	case 9 : *addr_mode=IMM; strcpy(mnemonic,"ORA"); break;
	case 10 : *addr_mode=ACC; strcpy(mnemonic,"ASL"); break;
	case 13 : *addr_mode=ABS; strcpy(mnemonic,"ORA"); break;
	case 14 : *addr_mode=ABS; strcpy(mnemonic,"ASL"); break;
	case 16 : *addr_mode=REL; strcpy(mnemonic,"BPL"); break;
	case 17 : *addr_mode=INDY; strcpy(mnemonic,"ORA"); break;
	case 21 : *addr_mode=ZPX; strcpy(mnemonic,"ORA"); break;
	case 22 : *addr_mode=ZPX; strcpy(mnemonic,"ASL"); break;
	case 24 : *addr_mode=IMP; strcpy(mnemonic,"CLC"); break;
	case 25 : *addr_mode=ABSY; strcpy(mnemonic,"ORA"); break;
	case 29 : *addr_mode=ABSX; strcpy(mnemonic,"ORA"); break;
	case 30 : *addr_mode=ABSX; strcpy(mnemonic,"ASL"); break;
	case 32 : *addr_mode=ABS; strcpy(mnemonic,"JSR"); break;
	case 33 : *addr_mode=INDX; strcpy(mnemonic,"AND"); break;
	case 36 : *addr_mode=ZP; strcpy(mnemonic,"BIT"); break;
	case 37 : *addr_mode=ZP; strcpy(mnemonic,"AND"); break;
	case 38 : *addr_mode=ZP; strcpy(mnemonic,"ROL"); break;
	case 40 : *addr_mode=IMP; strcpy(mnemonic,"PLP"); break;
	case 41 : *addr_mode=IMM; strcpy(mnemonic,"AND"); break;
	case 42 : *addr_mode=ACC; strcpy(mnemonic,"ROL"); break;
	case 44 : *addr_mode=ABS; strcpy(mnemonic,"BIT"); break;
	case 45 : *addr_mode=ABS; strcpy(mnemonic,"AND"); break;
	case 46 : *addr_mode=ABS; strcpy(mnemonic,"ROL"); break;
	case 48 : *addr_mode=REL; strcpy(mnemonic,"BMI"); break;
	case 49 : *addr_mode=INDY; strcpy(mnemonic,"AND"); break;
	case 53 : *addr_mode=ZPX; strcpy(mnemonic,"AND"); break;
	case 54 : *addr_mode=ZPX; strcpy(mnemonic,"ROL"); break;
	case 56 : *addr_mode=IMP; strcpy(mnemonic,"SEC"); break;
	case 57 : *addr_mode=ABSY; strcpy(mnemonic,"AND"); break;
	case 61 : *addr_mode=ABSX; strcpy(mnemonic,"AND"); break;
	case 62 : *addr_mode=ABSX; strcpy(mnemonic,"ROL"); break;
	case 64 : *addr_mode=IMP; strcpy(mnemonic,"RTI"); break;
	case 65 : *addr_mode=INDX; strcpy(mnemonic,"EOR"); break;
	case 69 : *addr_mode=ZP; strcpy(mnemonic,"EOR"); break;
	case 70 : *addr_mode=ZP; strcpy(mnemonic,"LSR"); break;
	case 72 : *addr_mode=IMP; strcpy(mnemonic,"PHA"); break;
	case 73 : *addr_mode=IMM; strcpy(mnemonic,"EOR"); break;
	case 74 : *addr_mode=ACC; strcpy(mnemonic,"LSR"); break;
	case 76 : *addr_mode=ABS; strcpy(mnemonic,"JMP"); break;
	case 77 : *addr_mode=ABS; strcpy(mnemonic,"EOR"); break;
	case 78 : *addr_mode=ABS; strcpy(mnemonic,"LSR"); break;
	case 80 : *addr_mode=REL; strcpy(mnemonic,"BVC"); break; 
	case 81 : *addr_mode=INDY; strcpy(mnemonic,"EOR"); break;
	case 85 : *addr_mode=ZPX; strcpy(mnemonic,"EOR"); break;
	case 86 : *addr_mode=ZPX; strcpy(mnemonic,"LSR"); break;
	case 88 : *addr_mode=IMP; strcpy(mnemonic,"CLI"); break;
	case 89 : *addr_mode=ABSY; strcpy(mnemonic,"EOR"); break;
	case 93 : *addr_mode=ABSX; strcpy(mnemonic,"EOR"); break;
	case 94 : *addr_mode=ABSX; strcpy(mnemonic,"LSR"); break;
	case 96 : *addr_mode=IMP; strcpy(mnemonic,"RTS"); break;
	case 97 : *addr_mode=INDX; strcpy(mnemonic,"ADC"); break;
	case 101 : *addr_mode=ZP; strcpy(mnemonic,"ADC"); break;
	case 102 : *addr_mode=ZP; strcpy(mnemonic,"ROR"); break;
	case 104 : *addr_mode=IMP; strcpy(mnemonic,"PLA"); break;
	case 105 : *addr_mode=IMM; strcpy(mnemonic,"ADC"); break;
	case 106 : *addr_mode=ACC; strcpy(mnemonic,"ROR"); break;
	case 108 : *addr_mode=INDABS; strcpy(mnemonic,"JMP"); break;
	case 109 : *addr_mode=ABS; strcpy(mnemonic,"ADC"); break;
	case 110 : *addr_mode=ABS; strcpy(mnemonic,"ROR"); break;
	case 112 : *addr_mode=REL; strcpy(mnemonic,"BVS"); break;
	case 113 : *addr_mode=INDY; strcpy(mnemonic,"ADC"); break;
	case 117 : *addr_mode=ZPX; strcpy(mnemonic,"ADC"); break;
	case 118 : *addr_mode=ZPX; strcpy(mnemonic,"ROR"); break;
	case 120 : *addr_mode=IMP; strcpy(mnemonic,"SEI"); break;
	case 121 : *addr_mode=ABSY; strcpy(mnemonic,"ADC"); break;
	case 124 : *addr_mode=ABSX; strcpy(mnemonic,"JMP"); break;
	case 125 : *addr_mode=ABSX; strcpy(mnemonic,"ADC"); break;
	case 126 : *addr_mode=ABSX; strcpy(mnemonic,"ROR"); break;
	case 129 : *addr_mode=INDX; strcpy(mnemonic,"STA"); break;
	case 132 : *addr_mode=ZP; strcpy(mnemonic,"STY"); break;
	case 133 : *addr_mode=ZP; strcpy(mnemonic,"STA"); break;
	case 134 : *addr_mode=ZP; strcpy(mnemonic,"STX"); break;
	case 136 : *addr_mode=IMP; strcpy(mnemonic,"DEY"); break;
	case 138 : *addr_mode=IMP; strcpy(mnemonic,"TXA"); break;
	case 140 : *addr_mode=ABS; strcpy(mnemonic,"STY"); break;
	case 141 : *addr_mode=ABS; strcpy(mnemonic,"STA"); break;
	case 142 : *addr_mode=ABS; strcpy(mnemonic,"STX"); break;
	case 144 : *addr_mode=REL; strcpy(mnemonic,"BCC"); break;
	case 145 : *addr_mode=INDY; strcpy(mnemonic,"STA"); break;
	case 148 : *addr_mode=ZPX; strcpy(mnemonic,"STY"); break;
	case 149 : *addr_mode=ZPX; strcpy(mnemonic,"STA"); break;
	case 150 : *addr_mode=ZPY; strcpy(mnemonic,"STX"); break;
	case 152 : *addr_mode=IMP; strcpy(mnemonic,"TYA"); break;
	case 153 : *addr_mode=ABSY; strcpy(mnemonic,"STA"); break;
	case 154 : *addr_mode=IMP; strcpy(mnemonic,"TXS"); break;
	case 157 : *addr_mode=ABSX; strcpy(mnemonic,"STA"); break;
	case 160 : *addr_mode=IMM; strcpy(mnemonic,"LDY"); break;
	case 161 : *addr_mode=INDX; strcpy(mnemonic,"LDA"); break;
	case 162 : *addr_mode=IMM; strcpy(mnemonic,"LDX"); break;
	case 164 : *addr_mode=ZP; strcpy(mnemonic,"LDY"); break;
	case 165 : *addr_mode=ZP; strcpy(mnemonic,"LDA"); break;
	case 166 : *addr_mode=ZP; strcpy(mnemonic,"LDX"); break;
	case 168 : *addr_mode=IMP; strcpy(mnemonic,"TAY"); break;
	case 169 : *addr_mode=IMM; strcpy(mnemonic,"LDA"); break;
	case 170 : *addr_mode=IMP; strcpy(mnemonic,"TAX"); break;
	case 172 : *addr_mode=ABS; strcpy(mnemonic,"LDY"); break;
	case 173 : *addr_mode=ABS; strcpy(mnemonic,"LDA"); break;
	case 174 : *addr_mode=ABS; strcpy(mnemonic,"LDX"); break;
	case 176 : *addr_mode=REL; strcpy(mnemonic,"BCS"); break;
	case 177 : *addr_mode=INDY; strcpy(mnemonic,"LDA"); break;
	case 180 : *addr_mode=ZPX; strcpy(mnemonic,"LDY"); break;
	case 181 : *addr_mode=ZPX; strcpy(mnemonic,"LDA"); break;
	case 182 : *addr_mode=ZPY; strcpy(mnemonic,"LDX"); break;
	case 184 : *addr_mode=IMP; strcpy(mnemonic,"CLV"); break;
	case 185 : *addr_mode=ABSY; strcpy(mnemonic,"LDA"); break;
	case 186 : *addr_mode=IMP; strcpy(mnemonic,"TSX"); break;
	case 188 : *addr_mode=ABSX; strcpy(mnemonic,"LDY"); break;
	case 189 : *addr_mode=ABSX; strcpy(mnemonic,"LDA"); break;
	case 190 : *addr_mode=ABSY; strcpy(mnemonic,"LDX"); break;
	case 192 : *addr_mode=IMM; strcpy(mnemonic,"CPY"); break;
	case 193 : *addr_mode=INDX; strcpy(mnemonic,"CMP"); break;
	case 196 : *addr_mode=ZP; strcpy(mnemonic,"CPY"); break;
	case 197 : *addr_mode=ZP; strcpy(mnemonic,"CMP"); break;
	case 198 : *addr_mode=ZP; strcpy(mnemonic,"DEC"); break;
	case 200 : *addr_mode=IMP; strcpy(mnemonic,"INY"); break;
	case 201 : *addr_mode=IMM; strcpy(mnemonic,"CMP"); break;
	case 202 : *addr_mode=IMP; strcpy(mnemonic,"DEX"); break;
	case 204 : *addr_mode=ABS; strcpy(mnemonic,"CPY"); break;
	case 205 : *addr_mode=ABS; strcpy(mnemonic,"CMP"); break;
	case 206 : *addr_mode=ABS; strcpy(mnemonic,"DEC"); break;
	case 208 : *addr_mode=REL; strcpy(mnemonic,"BNE"); break;
	case 209 : *addr_mode=INDY; strcpy(mnemonic,"CMP"); break;
	case 213 : *addr_mode=ZPX; strcpy(mnemonic,"CMP"); break;
	case 214 : *addr_mode=ZPX; strcpy(mnemonic,"DEC"); break;
	case 216 : *addr_mode=IMP; strcpy(mnemonic,"CLD"); break;
	case 217 : *addr_mode=ABSY; strcpy(mnemonic,"CMP"); break;
	case 221 : *addr_mode=ABSX; strcpy(mnemonic,"CMP"); break;
	case 222 : *addr_mode=ABSX; strcpy(mnemonic,"DEC"); break;
	case 224 : *addr_mode=IMM; strcpy(mnemonic,"CPX"); break;
	case 225 : *addr_mode=INDX; strcpy(mnemonic,"SBC"); break;
	case 228 : *addr_mode=ZP; strcpy(mnemonic,"CPX"); break;
	case 229 : *addr_mode=ZP; strcpy(mnemonic,"SBC"); break;
	case 230 : *addr_mode=ZP; strcpy(mnemonic,"INC"); break;
	case 232 : *addr_mode=IMP; strcpy(mnemonic,"INX"); break;
	case 233 : *addr_mode=IMM; strcpy(mnemonic,"SBC"); break;
	case 234 : *addr_mode=IMP; strcpy(mnemonic,"NOP"); break;
	case 236 : *addr_mode=ABS; strcpy(mnemonic,"CPX"); break;
	case 237 : *addr_mode=ABS; strcpy(mnemonic,"SBC"); break;
	case 238 : *addr_mode=ABS; strcpy(mnemonic,"INC"); break;
	case 240 : *addr_mode=REL; strcpy(mnemonic,"BEQ"); break;
	case 241 : *addr_mode=INDY; strcpy(mnemonic,"SBC"); break;
	case 245 : *addr_mode=ZPX; strcpy(mnemonic,"SBC"); break;
	case 246 : *addr_mode=ZPX; strcpy(mnemonic,"INC"); break;
	case 248 : *addr_mode=IMP; strcpy(mnemonic,"SED"); break;
	case 249 : *addr_mode=ABSY; strcpy(mnemonic,"SBC"); break;
	case 253 : *addr_mode=ABSX; strcpy(mnemonic,"SBC"); break;
	case 254 : *addr_mode=ABSX; strcpy(mnemonic,"INC");  break;
	default : *addr_mode=IMP; strcpy(mnemonic,"???");
	break;
	}
}
/**************************************************************************/

