/**************************************************************************/
/*                                                                        */
/*            em6502 - An X Based 6502 Emulator & Teaching Aid            */
/*            ------------------------------------------------            */
/*              (c) Neil Pollard, University of Bristol 1994              */
/*                                                                        */
/*            Please read the file README for more information            */
/*                                                                        */
/**************************************************************************/
/* cpu6502.h */

/* Header file for all cpu based functions */

/* Macro to advance Program Counter to next instruction */
#define nxt PCL=(PCL)+BYTES; if (PCL>255) {(PCH)+=1; PCL=(PCL%256);}
#define nxt1 PCL+=1; if (PCL==256) {(PCH)+=1; PCL=0;}
#define nxt2 PCL+=2; if (PCL>255) {(PCH)+=1; PCL=(PCL%256);}

/* Macro to set Z and N flags in the Status Register if necessary */
#define flags(q) if (!(q)) ZERO=1; else ZERO=0; if ((q) & 128) NEGATIVE =1; else NEGATIVE =0;

/* The 13 addressing modes macros and the number of bytes associated with 
each */ 

/* Implied addressing */
#define IMP BYTES=1;

/* Relative addressing */
#define REL BYTES=2;

/* Absolute Addressing */
#define ABS AD=(LB+(HB << 8)); BYTES = 3;

/* Zero Page Addressing */
#define ZP AD = (LB); BYTES = 2;

/* Zero Page Indexed X */
#define ZPX AD = ((LB+X) % 0xff); BYTES = 2;

/* Zero Page Indexed Y */
#define ZPY AD = ((LB+Y) % 0xff); BYTES = 2;

/* Absolute Indexed X */
#define ABSX AD = (X+LB+(HB << 8)); BYTES = 3;

/* Absolute Indexed Y */
#define ABSY AD = (Y+LB+(HB << 8)); BYTES = 3;

/* Indexed Indirect X */
#define INDX AD = ( (M[(LB+X)%0xff]) + ((M[(1+LB+X)%0xff]) << 8) ); BYTES = 2;

/* Indirect Indexed Y */
#define INDY AD = ( Y + (M[LB] ) + ( (M[1+LB]) << 8) ); BYTES = 2;

/* Absolute Indirect */
#define INDABS AD = ( (M[LB+(HB << 8)]) + ((M[1+LB+(HB << 8)]) << 8) );

/* Main registers */
int A, X, Y, PCH, PCL, LB, HB, S;

/* No. of bytes used for instruction */
unsigned char BYTES;

/* Calculated address */
int AD;

/* The CPU flags */
unsigned char CARRY, ZERO, IRQD, DECIMAL, BRK, OVERFLOW, NEGATIVE;

/* 64Kb of memory */
extern unsigned char M[0x10000];

/* Screen Memory */
unsigned char SCREEN[0x400];

/* Breakpoints to activate monitor */
int BREAK_LOW;
int BREAK_HI;
