/*
 * Copyright (c) James Fidell 1994.
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the copyright holder
 * not be used in advertising or publicity pertaining to distribution
 * of the software without specific, written prior permission. The
 * copyright holder makes no representations about the suitability of
 * this software for any purpose. It is provided "as is" without express
 * or implied warranty.
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */


#ifndef	SCREEN_H
#define	SCREEN_H

extern	void			InitialiseScreen ( void );
extern	void			ShutdownScreen ( void );
extern	void			CheckEvents ( void );
extern	void			UpdateScreenImage ( void );
extern	void			ScreenAddressStartHi ( unsigned char );
extern	void			ScreenAddressStartLo ( unsigned char );

extern	unsigned char	ScreenChanged;

#ifdef	_XLIB_H_

extern	GC				TtextTextGC;
extern	GC				TtextMosaicGC;

extern	Font			TtextText;
extern	Font			TtextTextDblU;
extern	Font			TtextTextDblL;
extern	Font			TtextContiguousMosaic;
extern	Font			TtextSeparateMosaic;

extern	Display			*dpy;
extern	Window			BeebScreen;
extern	GC				DefaultGraphicsContext;
extern	GC				CursorGC;

#endif

#define	Black			0
#define	Red				1
#define	Greed			2
#define	Yellow			3
#define	Blue			4
#define	Magenta			5
#define	Cyan			6
#define	White			7

#endif
