#ifndef TOM6502DEFS_H_
#define TOM6502DEFS_H_

//////////////////////////////////////////////////////////////////////////
// How to say "this WILL be inline"
#if (defined _MSC_VER)
#define FINLINE __forceinline
#else
#define FINLINE inline
#endif

//////////////////////////////////////////////////////////////////////////
// TSP_STATIC	used to indicate a template specialization of a member
//				function is static.
// TSP_INLINE	ditto but for inline.
// TSP_FINLINE	ditto but for FINLINE.
// (icl follows the non-specialized declaration. VC++ wants it afresh each
// time.)
// NOPROLOG		generate fn without prologue/epilogue code.
// t65TYPENAME	how this compiler likes 'typename' (for inner types of template
//				types)
// t65_X86		defined if this is compiling for x86
// t65_COMPILER	one of:
//				icl - Intel C++
//				msvc - MS Visual C++
//				gcc - GNU C++ compiler
//
// Note: support for the above is iffy at best. Getting it to compile on
// VC++7 was a major pain; gcc was even worse. So far as I can tell, gcc
// won't accept inline specializations of member functions. Since this is
// the only syntax VC++7 and icl seem to accept, this results in at best
// major #define hackery or bizarre #include ugliness.
//
// I might have my C++ syntax rather wrong here. Where are all the decent
// compilers...
#define t65_icl (0)
#define t65_msvc (1)
#define t65_gcc (2)

#if defined(__INTEL_COMPILER)
//Intel C++ (designed for 6.0)
#define TSP_STATIC
#define TSP_INLINE
#define TSP_FINLINE
#define NOPROLOG __declspec(naked)
#define t65TYPENAME
#define t65_X86
#define t65_COMPILER t65_icl
#elif defined(_MSC_VER)
//MS Visual C++ (designed for 7.0)
#define TSP_STATIC static
#define TSP_INLINE inline
#define TSP_FINLINE FINLINE
#define NOPROLOG __declspec(naked)
#define t65TYPENAME
#define t65_X86
#define t65_COMPILER t65_msvc
#elif (defined __GNUC__)
//GNU C++ (designed for 3.2)
#define TSP_STATIC static
#define TSP_INLINE inline
#define TSP_FINLINE FINLINE
#define NOPROLOG
#define t65TYPENAME typename
#define t65_COMPILER t65_gcc
#ifdef __i386__
#define t65_X86
#endif
#endif

//you can make this a function if you want, but this pops the debugger to the
//point of SoftBreak call rather than inside the function, so you don't have
//to mess with vc's buggy call stack view.

#ifndef t65_X86
#define SoftBreak() assert(false)
#else
#if t65_COMPILER==t65_gcc
#define SoftBreak() asm("int $3")
#else
#define SoftBreak() do{__asm {int 3}}while(false)
#endif
#endif//t65_X86

namespace t65 {
	typedef signed char int8;
	typedef unsigned char byte;
	
	typedef signed short int16;
	typedef unsigned short word;
	
	typedef signed long int32;
	typedef unsigned long dword;

#if (t65_COMPILER==t65_msvc)||(t65_COMPILER==t65_icl)
	typedef signed __int64 int64;
	typedef unsigned __int64 qword;
#elif t65_COMPILER==t65_gcc
	typedef signed long long int64;
	typedef unsigned long long qword;
#else
#error
#endif
	
	//no constructor for this, because I want the compiler to know it's 100% a
	//pod.
	union Word {
		word w;
		struct {
			byte l,h;
		};
	};

	inline Word MakeWord(word w) {
		Word r;
		r.w=w;
		return r;
	}

	inline Word MakeWord(byte l,byte h) {
		Word r;
		r.l=l;
		r.h=h;
		return r;
	}
}

#endif
