#ifndef mbROMSCONFIGDIALOG_H_
#define mbROMSCONFIGDIALOG_H_

#include "mbConfig.h"

class wxGenericValidator;

class mbRomsConfigDialog:
public wxDialog
{
public:
	enum {
		SAVE=1,
		RESET=2,
	};
	mbRomsConfigDialog(wxWindow *parent,wxWindowID id,const mbRomsConfig &cfg);
	~mbRomsConfigDialog();

	void GetResult(mbRomsConfig *cfg) const;
protected:
private:
	DECLARE_EVENT_TABLE();
	
	mbRomsConfig cfg_;

	struct RomControls {
		int slot;
		wxBoxSizer *sizer;
		wxStaticText *slot_number;
		wxTextCtrl *file_name;
		wxButton *select_file;
		wxCheckBox *is_ram;

		wxTextValidator *file_name_vd;
		wxGenericValidator *is_ram_vd;

		RomControls();
#ifdef __WXDEBUG__
		bool AllOk() const;
#endif
	};

	//Controls
	std::vector<RomControls *> rom_controls_;
//	wxBoxSizer *roms_sizer_;
//	wxScrolledWindow *scrollw_;
	wxTextValidator *os_file_name_vd_;
	int result_flags_;

	void ResetRomControls();
	void RefreshRomControls();
	void RefreshDialog();

	//cmds
	void OnFileSelect(wxCommandEvent &event);
	void OnOk(wxCommandEvent &event);
	void OnCancel(wxCommandEvent &event);
	void OnApplyReset(wxCommandEvent &event);
	void DataOk(int flags);
};

#endif
