#ifndef mbMAINFRAME_H_
#define mbMAINFRAME_H_

#include "HostWin32.h"
#include "mbKeymap.h"
#include "mbConfig.h"
#include "mbStatusBar.h"
#ifdef bbcDEBUG_PANELS
#include "mbDebugPanel.h"
#endif
#include <t65.h>
#include <bbcFdd.h>
#include <deque>
#include <bbcDebugTrace.h>

class BeebRomsConfigDialog;

class mbMainFrame:
public wxFrame
{
public:
	mbMainFrame(const std::vector<wxString> &argv);

	bool Ok() const;
	void PowerOnBeeb();
	void SetAutoPaint(bool auto_paint);
	void SetSoundEnabled(bool new_sound_enabled);
	void GetConfig(mbConfig *cfg) const;
protected:
	void OnClose(wxCloseEvent &event);
	void Idle(wxIdleEvent &event);
private:
	struct DriveUi {
//		bool loaded;
		wxFileName disc_image;
		bool no_save;

		wxString last_path;
		int last_filter_index;

		DriveUi();
	};
	DECLARE_EVENT_TABLE();
	
	bool auto_paint_;
	bool ok_;
	mbKeymap *keymap_;
	mbConfig cfg_;
	HostGfxState *hostgfx_;
	HostInpState *hostinp_;
	HostSndState *hostsnd_;
	
	HostTmr_HfValue hf_freq_;
	
	void DoBeebTick();
	bool ApplyConfig();
	
	unsigned num_frames_;
	
	int next_update_keys_;
	int next_update_sys_;
	int next_update_sound_;
	int last_update_sys_time_;
	
	bool debouncing_break_;

	HostTmr_HfValue last_update_sound_hf_time_;

	//
	void SetKeymap(const wxString &keymap_name);
	void DoUpdateKeys();
	void DoUpdateSound();
	void DoUpdateSys();
	void InitMenuBar();

	//Menu handlers
	void OnMenuOpen(wxMenuEvent &event);
	void OnMenuClose(wxMenuEvent &event);
	void OnExit(wxCommandEvent &event);
	void OnToggleSound(wxCommandEvent &event);
	void OnToggleLimitSpeed(wxCommandEvent &event);
	void OnToggleToolbar(wxCommandEvent &event);
	void OnShowAboutBox(wxCommandEvent &event);
	void OnQuickstart(wxCommandEvent &event);
/*
	mbMainFrame_DECLARE_DRIVE_HANDLERS(0);
	mbMainFrame_DECLARE_DRIVE_HANDLERS(1);
	mbMainFrame_DECLARE_DRIVE_HANDLERS(2);
	mbMainFrame_DECLARE_DRIVE_HANDLERS(3);
*/
	void OnDriveXCommand(wxCommandEvent &event);
	void OnTest(wxCommandEvent &event);
	void OnRomsDialog(wxCommandEvent &event);
	void OnSoundDialog(wxCommandEvent &event);
	void OnKeymapDialog(wxCommandEvent &event);
	void OnKeymap(wxCommandEvent &event);
	void OnToggleFastForwardDiscAccess(wxCommandEvent &event);
	
	//Drive handlers
	void OnDriveLoad(wxCommandEvent &event,int drive);
	void OnDriveLoadInternal(wxCommandEvent &event,int drive);
	void OnDriveSave(wxCommandEvent &event,int drive);
	void OnDriveUnload(wxCommandEvent &event,int drive);
	
	//Other handlers
	void OnPaint(wxPaintEvent &event);
	void OnEraseBackground(wxEraseEvent &event);
	void OnSize(wxSizeEvent &event);
	void OnMove(wxMoveEvent &event);
#ifdef BEEB_DEBUG_SAVE_CHALLENGER_RAM
	void OnSaveChallengerRam(wxCommandEvent &event);
#endif
#ifdef BEEB_DEBUG_DISASSEMBLE_RAM
	void OnDisassembleRam(wxCommandEvent &event);
#endif
	void OnResolution(wxCommandEvent &event);
	void OnScreenshotSaveAs(wxCommandEvent &event);
	void OnToggleStatusBar(wxCommandEvent &event);
#ifdef bbcDEBUG_PANELS
	void OnToggleDbgpanelSysvia(wxCommandEvent &event);
	void OnToggleDbgpanelUsrvia(wxCommandEvent &event);
	void OnToggleDbgpanelVideo(wxCommandEvent &event);
#endif
#ifdef bbcDEBUG_TRACE
	void OnStartDisassembly(wxCommandEvent &event);
	void OnStopDisassembly(wxCommandEvent &event);
#endif
#ifdef bbcDEBUG_VIDEO
	void OnToggleShowAll(wxCommandEvent &event);
	void OnLogVideoFrames(wxCommandEvent &event);
	void OnToggleShowT1Timeouts(wxCommandEvent &event);
#endif
	void OnSoundRecordStart(wxCommandEvent &event);
	void OnSoundRecordStop(wxCommandEvent &event);
	void OnHardReset(wxCommandEvent &event);
	void OnSetScreenType(wxCommandEvent &event);
	void OnVolume(wxCommandEvent &event);
	void OnDropFile(wxCommandEvent &event);
//	void OnToggleVertical2x(wxCommandEvent &event);
	void OnActivate(wxActivateEvent &event);
	void OnToggleFullScreen(wxCommandEvent &event);
	void OnScanlines(wxCommandEvent &event);
	void OnJoysticksDialog(wxCommandEvent &event);
	void OnRightUp(wxMouseEvent &event);
	
	void ModalBackground();
	bool CloseConfirmed();

	//with a user defined modal dialog
	//showing, idle events are still sent to the mbMainFrame and the BBC
	//continues to run in the background. Set this to true to pause the
	//beeb.
	//
	//It is not set by ModalBackground(), as there aren't too many user
	//defined modal dialogs in this program.
	bool beeb_paused_;

	enum {
		update_keys_freq=200,
		update_sys_freq=25,
		update_sound_freq=50,

		update_keys_cycles=2000000/update_keys_freq,
		update_sys_cycles=2000000/update_sys_freq,
		update_sound_cycles=2000000/update_sound_freq,
	};

	void SetMenuItemEnabled(int menu_item_id,bool enabled);
	void SetMenuItemCheck(int menu_item_id,bool checked);
	void RefreshWindow();

	DriveUi drive_uis_[bbcFdd::num_drives];

	//Ui things do a complete user interface type sequence (msgboxs etc.)
	bool UiLoadDisc(int drive,wxFileName file_name);

//	void ResetBreak();
//	void ResetHard();

	wxMenu *keymaps_submenu_;
	wxSize ResolutionFromId(int id);

	//Screenshot stuff.
	//
	//Screenshots can only be taken when the frame has been fully drawn,
	//i.e. when VideoSystem::buffer_dirty, so this uses a notification
	//rather than saving straight away.
	//The screenshot countdown is really lame.
	//It starts at N.
	//If >1, background is cleaned
	//If ==1, a screenshot is taken.
	//If ==0, nothing happens.
	//Then, If >0 it is decremented.
	int screenshot_countdown_;//screenshot countdown
	wxString screenshot_name_;//name of the screenshot.
	void DoScreenshot();

	typedef void (mbMainFrame::*DriveCommandMfn)(wxCommandEvent &,int);
	static const DriveCommandMfn drive_subactions[];
	
	//User interface for unloading drive 'drive'
	//Dialogs if contents changed.
	//Returns true if drive should be unloaded.
	//false if not.
	bool UiUnloadDrive(int drive);

	struct SbState {
		struct Drive {
			char what;
			int track,sector;
		};
		Drive drives[bbcFdd::num_drives];
		bool caps,shift;

		SbState();
	};

	SbState state_;

	void UpdateStatusBar();

	wxWindow *beeb_screen_;
	mbStatusBar *status_bar_;

	void SetBeebScreenSize(const wxSize &screen_size);

	bool beeb_fastforward_;

	bool DoCommandLine(const std::vector<wxString> &argv);

	//Command line options -- cl_whatever_ are specified via command line.
	bool cl_select_ini_;
	wxString cl_drive_mounts_[bbcFdd::num_drives];
	bool cl_autoboot_;
	wxString cl_ini_file_;
	bool cl_ini_save_;
	std::vector<wxString> cl_ini_override_files_;
	bool cl_verbose_;

	//menu
	wxMenuBar *menu_bar_;
	wxMenu *popup_menu_;
};

#endif
