#ifndef mbCONFIG_H_
#define mbCONFIG_H_

#include "mbKeymap.h"
#include "HostWin32.h"

//the wxWindows config type this program uses
//wxFIle Config, I cannot stand the registry!!
typedef wxFileConfig mbWxConfig;

//////////////////////////////////////////////////////////////////////////
// ROM configuration
struct mbRomsConfig {
	//Configuration for a ROM slot
	struct Rom {
		wxString filename;
		bool ram;

		Rom();
	};
	Rom roms[16];
	wxString os_filename;
	wxRect dlg_rect;

	mbRomsConfig();
	void Load(mbWxConfig *cfg);
	void Save(mbWxConfig *cfg) const;
};

//////////////////////////////////////////////////////////////////////////
// Sound configuration
struct mbSoundConfig {
	bool enabled;
	bool stereo;
	int hz,bits;
	int len_frames;
	bool is_stereo_left[4],is_stereo_right[4];
	wxRect dlg_rect;
	int volume;

	mbSoundConfig();
	
	void Load(mbWxConfig *cfg);
	void Save(mbWxConfig *cfg) const;
};

//////////////////////////////////////////////////////////////////////////
// Keyboard configuration
struct mbKeyboardConfig {
	bool keylinks[8];
	mbKeymap::C keymaps;
	wxString selected_keymap;
	wxRect dlg_rect;

	mbKeyboardConfig();
	
	void Load(mbWxConfig *cfg);
	void Save(mbWxConfig *cfg) const;
};

//////////////////////////////////////////////////////////////////////////
//
struct mbVideoConfig {
	int width,height;
	int frame_skip;
	int cleanup_frequency;
	bool full_screen;
	int full_screen_refresh_rate;
	HostGfx_ScanlinesMode full_screen_scanlines;
	HostGfx_ScanlinesMode windowed_scanlines;
	
	mbVideoConfig();
	
	void Load(mbWxConfig *cfg);
	void Save(mbWxConfig *cfg) const;
};

//////////////////////////////////////////////////////////////////////////
//
struct mbMiscConfig {
	bool limit_speed;
	wxString disc_interface;
	bool show_status_bar;
	bool show_menu;
	bool fast_forward_disc_access;
	wxString model;
	wxRect window_rect;
	bool window_is_maximized;

	mbMiscConfig();
	
	void Load(mbWxConfig *cfg);
	void Save(mbWxConfig *cfg) const;
};

//////////////////////////////////////////////////////////////////////////
//
struct mbQuickstartConfig {
	wxRect dialog_pos;
	std::vector<wxFileName> dirs;
	
	mbQuickstartConfig();

	void Load(mbWxConfig *cfg);
	void Save(mbWxConfig *cfg) const;
};

struct mbConfig {
	mbRomsConfig roms;
	mbSoundConfig sound;
	mbKeyboardConfig keyboard;
	mbVideoConfig video;
	mbMiscConfig misc;
	mbQuickstartConfig quickstart;
	wxString file_name;
	bool read_only;
	
	mbConfig();
	void SetFilename(const wxString &config_file_name,bool is_read_only);
	void Load(const wxString &config_file_name);
	void Save() const;
	void GetConfig(mbWxConfig *cfg) const;
};

#endif
