#ifndef HOSTWIN32_H_
#define HOSTWIN32_H_

//TODO split into HostGeneric and HostXXX, some stuff will be constant.

//////////////////////////////////////////////////////////////////////////
// Timer

//Starts the timer services.
void HostTmr_Start();

//Stops the timer services.
void HostTmr_Stop();

//Standard millisecond timer -- sets *value to the number of milliseconds
//elapsed since whenever.
inline void HostTmr_ReadMilliseconds(int *value) {
	*value=GetTickCount();
}

//High frequency timer -- read current reading, or query its frequency.
//(This should be much higher frequency than milliseconds.)
#define READHF_INLINE

typedef LONGLONG HostTmr_HfValue;

#ifdef READHF_INLINE
inline void HostTmr_ReadHf(HostTmr_HfValue *value) {
	QueryPerformanceCounter(reinterpret_cast<LARGE_INTEGER *>(value));
}
#else//READHF_INLINE
void HostTmr_ReadHf(HostTmr_HfValue *value);
#endif//READHF_INLINE

int HostTmr_GetHfFrequency(HostTmr_HfValue *frequency);

//////////////////////////////////////////////////////////////////////////
// Graphics
struct HostGfxState;

//Create a HostGfxState that can be used to draw into the client area of
//the specified window.
HostGfxState *HostGfx_Start(wxWindow *owner,wxWindow *target);

//Destroy the given HostGfxState.
void HostGfx_Stop(HostGfxState *state);

//Set new display contents. Bitmap is 3 bit 00000BGR format.
void HostGfx_Present(HostGfxState *state,const unsigned char *bitmap_3bit,int w,int h,
	unsigned pitch);

//Refresh the display using the current contents.
void HostGfx_ShowWindowed(HostGfxState *state);

//Full screen page flip
void HostGfx_FlipFullScreen(HostGfxState *state);

//Set screen type.
enum HostGfx_BeebScreenType {
	HostGfx_COLOUR,
	HostGfx_BNW,
	HostGfx_GREEN,
	HostGfx_AMBER,
};

enum HostGfx_ScanlinesMode {
	HostGfx_SINGLE=0,
	HostGfx_INTERLACE=1,
	HostGfx_DOUBLE=2,
};

HostGfx_BeebScreenType HostGfx_ScreenType(HostGfxState *state);
void HostGfx_SetScreenType(HostGfxState *state,HostGfx_BeebScreenType type);

//void HostGfx_SetVertical2x(HostGfxState *state,bool vertical_2x);
void HostGfx_SetScanlinesMode(HostGfxState *state,
	HostGfx_ScanlinesMode new_scanlines_mode);

//Set full screen mode.
void HostGfx_SetFullScreen(HostGfxState *state,bool full_screen,
	int full_screen_refresh_rate);

//Whether full screen or not.
bool HostGfx_IsFullScreen(HostGfxState *state);

//Bits 2-0 of this value should be clear.
//It is the base of the 8 palette entries the emulator will use.
//This way the system palette can be left as-is, allowing the display
//of system widgets in full screen mode.
enum HostGfx_Config {
	HostGfx_FULL_SCREEN_PALETTE_BASE=128,
};

void HostGfx_Cls(HostGfxState *state);

//////////////////////////////////////////////////////////////////////////
// Sound
struct HostSndState;

//Create a HostSndState that is tagged to the given window.
HostSndState *HostSnd_Start(wxWindow *window);

//Destroy the given HostSndState.
void HostSnd_Stop(HostSndState *state);

//Set HostSndState parameters -- freq, nbits, num channels and length of buffer.
//If these are the same as the existing ones, it should reset play position and
//clear buffer.
void HostSnd_SetSoundParameters(HostSndState *state,int hz,int bits,int channels,
	int len_samples);

//Start and stop playing -- like pause and resume, PlayStart doesn't reset play
//position or anything.
void HostSnd_PlayStart(HostSndState *state);
void HostSnd_PlayStop(HostSndState *state);

//Get the area that needs writing data to.
//<0 indicates error. (Flush pending sound and try again later.)
//0 indicates no bytes to be written. (Try again later.)
//>0 indicates bytes to be written. (p[12] and len[12] filled in relevantly.)
int HostSnd_GetWriteArea(HostSndState *state,void **p1,unsigned *len1,void **p2,unsigned *len2);

//After writing data to the write area, call this function to commit it.
void HostSnd_CommitWriteArea(HostSndState *state);

//Set volume of sound.
//0<=volume<=100, 0 being quiet and 100 being loud.
void HostSnd_SetVolume(HostSndState *state,int volume);
/*
int HostSnd_SampleLoad(HostSndState *state,const char *filename);
void HostSnd_SamplePlay(HostSndState *state,int sample,int looping,float mult=1.f);
void HostSnd_SampleStop(HostSndState *state,int sample);
void HostSnd_SampleUnload(HostSndState *state,int sample);
*/
//////////////////////////////////////////////////////////////////////////
//
struct HostInpState;

struct HostInp_JoyState {
	float x,y,z;
	float rx,ry,rz;
	float sliders[2];
	BYTE buttons[32];
};

//Start input system attached to given window.
HostInpState *HostInp_Start(wxWindow *window);

//Stop input system.
void HostInp_Stop(HostInpState *state);

//Poll devices.
void HostInp_Poll(HostInpState *state);

//Get array of keyboard keydown flags.
void HostInp_GetKeyboardState(HostInpState *state,unsigned char *keyflags);

//Get array of flags indicating keys newly pressed last Poll.
void HostInp_GetKeyboardDownFlags(HostInpState *state,unsigned char *downflags);

static const unsigned HostInp_bad_key=unsigned(-1);

//Get name of key from its code, or 0 if no such key.
const char *HostInp_KeyNameFromCode(unsigned key_code);

//Get code for key given its name, or HostInp_bad_key if no such key.
unsigned HostInp_CodeFromKeyName(const char *key_name);

//Get number of joysticks
unsigned HostInp_NumJoysticks(HostInpState *state);

//Get state for joy_indexth joystick
void HostInp_GetJoystickState(HostInpState *state,unsigned joy_index,
	HostInp_JoyState *joy_state);

#endif

