/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1998. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (BeebInC@aol.com)                             */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <i86.h>
#include <conio.h>
#include <string.h>

#include "6845crtc.h"
#include "bbc.h"
#include "modex.h"
#include "modexc.h"
#include "sysvia.h"
#include "TwkUser.h" // get Register definition
#include "sb.h"
#include "mode7c.h"


extern BYTE SHIFTLock,CAPSLock,MotorLED,Drive02LED,Drive13LED;

volatile BYTE Byte; // do not allow to re-order

static Register ModeXScreenRegs[] =
	{
	{ 0x3c2, 0x0, 0xa3},
	{ 0x3d4, 0x0, 0x5f},
	{ 0x3d4, 0x1, 0x4f},
	{ 0x3d4, 0x2, 0x50},
	{ 0x3d4, 0x3, 0x82},
	{ 0x3d4, 0x4, 0x54},
	{ 0x3d4, 0x5, 0x80},
	{ 0x3d4, 0x6, 0xbf},
	{ 0x3d4, 0x7, 0x1f},
	{ 0x3d4, 0x8, 0x0},
	{ 0x3d4, 0x9, 0x40},
	{ 0x3d4, 0x10, 0x83},
	{ 0x3d4, 0x11, 0x85},
    { 0x3d4, 0x12, 0xf}, // was 7 - screen height
	{ 0x3d4, 0x13, 0x28},
	{ 0x3d4, 0x14, 0xf},
	{ 0x3d4, 0x15, 0x63},
	{ 0x3d4, 0x16, 0xba},
	{ 0x3d4, 0x17, 0xe3},
	{ 0x3c4, 0x1, 0x1},
	{ 0x3c4, 0x3, 0x0},
	{ 0x3c4, 0x4, 0x6},
	{ 0x3ce, 0x5, 0x0},
	{ 0x3ce, 0x6, 0x5},
    { 0x3c0, 0x10, 0x81}, // was 1
	{ 0x3c0, 0x11, 0x0},
	{ 0x3c0, 0x12, 0xf},
	{ 0x3c0, 0x13, 0x0},
	{ 0x3c0, 0x14, 0x0}
	};


static const char Colours[16][3]={{00,00,00}, // normal colours
                                  {63,00,00},
                                  {00,63,00},
                                  {63,63,00},
                                  {00,00,63},
                                  {63,00,63},
                                  {00,63,63},
                                  {63,63,63},

                                  {63,63,63}, // 'flashing' colours
                                  {00,63,63},
                                  {63,00,63},
                                  {00,00,63},
                                  {63,63,00},
                                  {00,63,00},
                                  {63,00,00},
                                  {00,00,00} };


// extra value is the overscan register (screen border colour)
static char PaletteRAMSource[]={ 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,0 };

static char * PaletteRAMBuffer=NULL;
static char * PaletteCodesBuffer=NULL;

static BYTE OldSHIFTLock,OldCAPSLock,OldMotorLED,OldDrive02LED,OldDrive13LED;

static struct rminfo {
    long EDI;
    long ESI;
    long EBP;
    long reserved_by_system;
    long EBX;
    long EDX;
    long ECX;
    long EAX;
    short flags;
    short ES,DS,FS,GS,IP,CS,SP,SS;
} RMI;



void InitModeX()
{
  int Count;
  union REGS regs;
  struct SREGS sregs;

    if (PaletteRAMBuffer==NULL) 
    { // first time run...
      PaletteRAMBuffer=AllocateDOSMem(32); // allocate 32 bytes
      memcpy(PaletteRAMBuffer,PaletteRAMSource,17);

      PaletteCodesBuffer=AllocateDOSMem(3*16); // allocate 48 bytes
      memcpy(PaletteCodesBuffer,Colours,3*16);

      ResetCRTC(); // reset it with decent values
    }

  regs.w.ax=0x12;
  int386( 0x10, &regs, &regs );

  outRegArray(ModeXScreenRegs,29);

  _disable();
  outp(0x3c6,0xff);
  inp(0x3da);    // read to reset attribute controller toggle in index mode
  outp(0x3c8,0); // start at colour 0

    for (Count=0; Count<16; Count++) // do colours 0-15
    {
      outp(0x3c9,Colours[Count % 8][0]);
      outp(0x3c9,Colours[Count % 8][1]);
      outp(0x3c9,Colours[Count % 8][2]);
    }
  _enable();


  // Set up real-mode call structure, call service ah=0x10 al=2
  // put DOS seg:off into ES:DX
  memset(&RMI,0,sizeof(RMI));
  RMI.EAX=0x00001002; 
  RMI.ES=(((long) PaletteRAMBuffer)>>4); 
  RMI.EDX=0;

  memset(&sregs,0,sizeof(sregs));

  // Use DMPI call 300h to issue the DOS interrupt
  regs.w.ax  = 0x0300;
  regs.h.bl  = 0x10;
  regs.h.bh  = 0;
  regs.w.cx  = 0;
  sregs.es   = FP_SEG(&RMI);
  regs.x.edi = FP_OFF(&RMI);
  int386x( 0x31, &regs, &regs, &sregs );


  // Use BIOS to load colours 16-23
  // Set up real-mode call structure call service ah=0x10 al=12
  // put DOS seg:off into ES:DX
  memset(&RMI,0,sizeof(RMI));
  RMI.EAX=0x00001012; 
  RMI.EBX=0x00000010; 
  RMI.ECX=0x00000010; 
  RMI.ES=(((long) PaletteCodesBuffer)>>4); 
  RMI.EDX=0;
  memset(&sregs,0,sizeof(sregs));

  // Use DMPI call 300h to issue the DOS interrupt
  regs.w.ax  = 0x0300;
  regs.h.bl  = 0x10;
  regs.h.bh  = 0;
  regs.w.cx  = 0;
  sregs.es   = FP_SEG(&RMI);
  regs.x.edi = FP_OFF(&RMI);
  int386x( 0x31, &regs, &regs, &sregs );

  ModeXFlashColours(FlashSelectColour); // set right palette!

// always keep these values
  outpw(0x03ce,0x0003); //  replace
  outpw(0x03ce,0xff08); // bit mask register
  outpw(0x03ce,0x0105); // write mode 1
  outp(0x3c4,2);  // access to...
  outp(0x3c5,15);  // all planes

// xfer LED gfx to VGA memory here
// DrawVGALEDs();

  ClearMode03Colours();
  ClearMode1Colours();
  ClearMode2Colours();
  ClearMode46Colours();
  ClearMode5Colours();
  ClearMode8Colours();
  ColoursChanged=TRUE;

  DoSplitScreen(); // for LED display!!
  DisplaySplitTitle();
  OldSHIFTLock=0xff;
  OldCAPSLock =0xff;
  OldMotorLED =0xff;
  OldDrive02LED=0xff;
  OldDrive13LED=0xff;
  DisplaySplitLEDs();


  PhysicalScreenBase=0xa0280; // screen displayed now.
  SwapScreenPage();           // display physical screen

    if (DoubleBuffering>0)
      LogicalScreenBase= 0xa5500;
    else
      LogicalScreenBase= 0xa0280;

  DisplayModeXScreen(); //sort out colours
}


// display physical screen
void SwapScreenPage()
{
    while ((inp(0x3da)&1)==1); // display enable is active low (0 = active)
    outp(0x3d4,0xc);
    outp(0x3d5,(BYTE) (PhysicalScreenBase>>8));
    outp(0x3d4,0xd);
    outp(0x3d5,(BYTE) (PhysicalScreenBase));
    while ((inp(0x3da)&8)==0); // wait while not in vertical rescan
}


void DoSplitScreen()
{
  int Old;
  outp(0x3d4,0x18); // line compare register - split occurs on line after this
  outp(0x3d5,7);

  outp(0x3d4,7);
  Old=inp(0x3d5);
  outp(0x3d5, Old | 0x10); // set bit 8 (0x10) of line compare

  outp(0x3d4,9);
  Old=inp(0x3d5);
  outp(0x3d5,Old & 0xb0); // clear bit 9 (0x40) of line compare
}



void AgePalettes()
{
  AgeMode03();
  AgeMode1();
  AgeMode2();
  AgeMode46();
  AgeMode5();
  AgeMode8();
}


void DisplayModeXScreen()
{
  LogicalScreen=(DWORD) LogicalScreenBase + (DWORD) (LinesToSkipFromScreenTop)*80;

    switch (GraphicVideoMode)
    {
      case 0 :   if (ScreenStart==0x4000)
                   DisplayMode3Screen();
                 else
                   DisplayMode0Screen();
               break;
      case 1 : DisplayMode1Screen();
               break;
      case 2 : DisplayMode2Screen();
               break;
      case 4 :   if (ScreenStart==0x6000)
                   DisplayMode6Screen();
                 else
                   DisplayMode4Screen();
               break;
      case 5 : DisplayMode5Screen();
               break;
      case 8 : DisplayMode8Screen();
               break;
    }
}


void DisplayModeXRow()
{
    switch (GraphicVideoMode)
    {
      case 0 : DisplayMode0Row();
               break;
      case 1 : DisplayMode1Row();
               break;
      case 2 : DisplayMode2Row();
               break;
      case 4 : DisplayMode4Row();
               break;
      case 5 : DisplayMode5Row();
               break;
      case 8 : DisplayMode8Row();
               break;
    }
}


void DisplayModeXLine()
{
    switch (GraphicVideoMode)
    {
      case 0 : DisplayMode0Line();
               break;
      case 1 : DisplayMode1Line();
               break;
      case 2 : DisplayMode2Line();
               break;
      case 4 : DisplayMode4Line();
               break;
      case 5 : DisplayMode5Line();
               break;
      case 8 : DisplayMode8Line();
               break;
    }
  ModeXScreenStart++;
  VSYNCLineOffset++;
}


void ModeXFlashColours(int PaletteOffset)
{
  inp(0x3da); // read to reset attribute controller toggle in index mode
  outp(0x3c0,0x34); // reg 0x14 (bit 5 always set)
  outp(0x3c0,(BYTE) PaletteOffset & 1);
}


void DumpLogicalColours(FILE * F)
{
  fprintf(F,"Logical %x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x\n",
          LogicalColours[0],
          LogicalColours[1],
          LogicalColours[2],
          LogicalColours[3],
          LogicalColours[4],
          LogicalColours[5],
          LogicalColours[6],
          LogicalColours[7],
          LogicalColours[8],
          LogicalColours[9],
          LogicalColours[10],
          LogicalColours[11],
          LogicalColours[12],
          LogicalColours[13],
          LogicalColours[14],
          LogicalColours[15]);
}


static void DisplaySplitChar(char * Dest,char * Source,BYTE Col)
{
  int Count;
    for (Count=0; Count<8; Count++)
    {
      outp(0x03cf,*Source); // bit mask data
      *Dest=Col;
      Dest+=80;
      Source++;
    }

}



static void DisplaySplitTitle()
{
  long Char;
  char * ScreenPtr=(char *) 0xa0000;
  char Text[80]="MOTOR XX   CAPS XX   SHIFT XX    By D.C.Devenport    DRIVE 0/2 XX   DRIVE 1/3 XX";

  outpw(0x03ce,0x0205); //  write mode 2

  *ScreenPtr=0; // first byte=colour 0
  Byte=*ScreenPtr;// load latches with colour 0
                      // (they stay the same thru out)

  outp(0x3ce,8); // bit mask index

    for (Char=0; Char<80; Char++)
    {
      DisplaySplitChar(((char *) (0xa0000 + Char)),
                       &AddressSpace[0xc000+((Text[Char]-32)*8)],7);
    }
    for (Char=30; Char<50; Char++)
    {
      DisplaySplitChar(((char *) (0xa0000 + Char)),
                       &AddressSpace[0xc000+((Text[Char]-32)*8)],3);
    }

  outp(0x03cf,0x255); // bit mask data
  outpw(0x03ce,0x0105); // write mode 1
}


static void DisplayALED(BYTE OnFlag,char * Dest)
{
  char OnLED[]=  { 0x0f,0x3f,0xff,0xff,0xff,0xff,0x3f,0x0f,
                   0xf0,0xfc,0xff,0xff,0xff,0xff,0xfc,0xf0 };

  char OffLED[]= { 0x0f,0x30,0xc0,0xc0,0xc0,0xc0,0x30,0x0f,
                   0xf0,0x0c,0x03,0x03,0x03,0x03,0x0c,0xf0 };

    if (OnFlag)
    {
      DisplaySplitChar(Dest,  OnLED,1);
      DisplaySplitChar(Dest+1,&OnLED[8],1);
    }
    else
    {
      DisplaySplitChar(Dest,  OffLED,1);
      DisplaySplitChar(Dest+1,&OffLED[8],1);
    }
}


void DisplaySplitLEDs()
{
  char * LEDPositions[]={ (char *) (0xa0000+6),
                          (char *) (0xa0000+16),
                          (char *) (0xa0000+27),
                          (char *) (0xa0000+63),
                          (char *) (0xa0000+78) };
  char * ScreenPtr;

    if (TeleTextModeOn)
    {
      DisplayMode7LEDs();
      return;
    }

    if ((OldSHIFTLock==SHIFTLock) &&
        (OldCAPSLock==CAPSLock) &&
        (OldMotorLED==MotorLED) &&
        (OldDrive02LED==Drive02LED) &&
        (Drive13LED==Drive13LED))
      return;


  _disable();
  outpw(0x03ce,0x0205); //  write mode 2

  outp(0x3ce,8); // bit mask index
  outp(0x03cf,0Xff); // bit mask data

  ScreenPtr=(char *) (0xa0005); // a space in the text

  *ScreenPtr=0; // first byte=colour 0
  Byte=*ScreenPtr;// load latches with colour 0
                      // (they stay the same thru out)

    if (OldMotorLED!=MotorLED)
    {
      DisplayALED(MotorLED,LEDPositions[0]);
      OldMotorLED =MotorLED;
    }

    if (OldCAPSLock!=CAPSLock)
    {
      DisplayALED(CAPSLock,LEDPositions[1]);
      OldCAPSLock=CAPSLock;
    }

    if (OldSHIFTLock!=SHIFTLock)
    {
      DisplayALED(SHIFTLock,LEDPositions[2]);
      OldSHIFTLock=SHIFTLock;
    }

    if (OldDrive02LED!=Drive02LED)
    {
      DisplayALED(Drive02LED,LEDPositions[3]);
      OldDrive02LED=Drive02LED;
    }

    if (OldDrive13LED!=Drive13LED)
    {
      DisplayALED(Drive13LED,LEDPositions[4]);
      OldDrive13LED=Drive13LED;
    }
  outp(0x03cf,0x255); // bit mask data
  outpw(0x03ce,0x0105); // write mode 1
  _enable();
}
