/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1998. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (BeebInC@aol.com)                             */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <dos.h>
#include <i86.h>
#include <string.h>
#include <stdlib.h>
#include "bbc.h"

char * AllocateDOSMem(int Size)
{
  union  REGS  regs;
  struct SREGS sregs;

  // DPMI call 100h allocates DOS memory
  memset(&sregs,0,sizeof(sregs));
  regs.w.ax=0x0100;
  regs.w.bx=(Size>>4); //allocates in 16 byte chunks
  int386x( 0x31, &regs, &regs, &sregs);

    if ( regs.w.cflag )
      FatalError("Can't Allocate DOS Memory %d Bytes",Size);

  return ((char *) ((regs.w.ax)<<4));
}


void LockMemory(char * Ptr,unsigned int Size)
{
  static int Count=0;
  union  REGS  regs;
  struct SREGS sregs;

  // DPMI call 600h locks memory
  memset(&sregs,0,sizeof(sregs));
  regs.w.ax=0x0600;
  regs.w.bx=(((unsigned int) Ptr)>>16) & 0xffff;
  regs.w.cx=((unsigned int)Ptr) & 0xffff;

  regs.w.si=(Size>>16) & 0xffff;
  regs.w.di=(Size) & 0xffff;
  int386x( 0x31, &regs, &regs, &sregs);

  Count++;
    if (regs.w.cflag)
      FatalError("Can't lock region %d",Count);
}


// Thanks to Parallax software for the following information
extern void cdecl _GETDS();
extern void cdecl cstart_();

void InitDPMI()
{
  LockMemory( (void *) _GETDS, 4096 );
  LockMemory( (void *) cstart_, 4096 );
  LockMemory( (void *) _chain_intr, 4096 );
}
