/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1998. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (BeebInC@aol.com)                             */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <stdlib.h>
#include <stdio.h>

void Reset6502();

void Do6502Instructions();

void Dump6502(FILE * FileHandle);


// bit values for the processor flags
#define CARRYFLAG       1
#define ZEROFLAG        2
#define INTERRUPTFLAG   4
#define DECIMALFLAG     8
#define BREAKFLAG       16
#define UNUSEDFLAG      32
#define OVERFLOWFLAG    64
#define SIGNFLAG        128

// setbits
#define SETVFLAG   (Processor.VFlag=OVERFLOWFLAG)
#define SETDFLAG   (Processor.DFlag=DECIMALFLAG)
#define SETIFLAG   (Processor.IFlag=INTERRUPTFLAG)

// ALWAYS Set Processor.CFlag to 1, if not ASL,LSR,ROL,ROR need changing
// Processor.CFlag uses SET below...

#define SET(Flg)   ((Flg)=1)
#define UNSET(Flg) ((Flg)=0)
#define SETFLAG(Test,Flag) Flag=(Test)
#define SETZ(Byte)  Processor.ZFlag=(Byte==0)


// stack operations - always in normal RAM
#define PUSH(Byte) AddressSpace[0x100+(Processor.StackPointer--)]=Byte
#define POP(Byte)  Processor.StackPointer++; \
                   Byte=AddressSpace[0x100+Processor.StackPointer]

// break flag is always set, except when pushed on the stack during an
// Interrupt/NMI
// Break flag (16) is always set, and also the unused flag (32)
#define MAKESTATUSREG ((Processor.NFlag) | \
                       (Processor.VFlag) | \
                       48 | \
                       (Processor.DFlag) | \
                       (Processor.IFlag) | \
                       ((Processor.ZFlag & 1)<<1) | \
                       Processor.CFlag)

// Break flag is cleared here, only on this 1 occasion
#define MAKEIRQSTATUSREG ((Processor.NFlag) | \
                          (Processor.VFlag) | \
                          32 | \
                          (Processor.DFlag) | \
                          (Processor.IFlag) | \
                          ((Processor.ZFlag & 1)<<1) | \
                          Processor.CFlag)

#define HLT_ROM  0x02
#define HLT_FILE 0x12
#define HLT_ARGS 0x22
#define HLT_BGET 0x32
#define HLT_BPUT 0x42
#define HLT_GBPB 0x52
#define HLT_FIND 0x62
#define HLT_FSC  0x72
#define HLT_TEXT 0x92
