/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.multimedia;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;

public class ImageViewer
extends Component
implements Serializable {
    public static final int IMAGE_TILED = 0;
    public static final int IMAGE_CENTERED = 1;
    public static final int IMAGE_SCALED_TO_FIT = 2;
    public static final int IMAGE_NORMAL = 3;
    protected transient Image image = null;
    protected String fileName = null;
    protected URL url = null;
    protected int imageStyle = 1;
    protected transient ResourceBundle errors;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public ImageViewer() {
    }

    public ImageViewer(String str) throws MalformedURLException {
        this();
        try {
            this.setFileName(str);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public ImageViewer(URL url) {
        this();
        try {
            this.setURL(url);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public ImageViewer(Image img) {
        this();
        try {
            this.setImage(img);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public void setFileName(String str) throws PropertyVetoException {
        String oldValue = this.fileName;
        try {
            this.vetos.fireVetoableChange("fileName", oldValue, str);
            this.fileName = str;
            if (this.fileName != null && this.fileName != "") {
                this.setURL(new URL(this.fileName));
            } else {
                this.setURL(null);
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.fileName = oldValue;
        }
        this.repaint();
        this.changes.firePropertyChange("fileName", oldValue, str);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setImageURL(URL aUrl) throws PropertyVetoException {
        URL oldValue = this.url;
        this.vetos.fireVetoableChange("imageURL", oldValue, aUrl);
        this.url = aUrl;
        this.fileName = null;
        Image loadedImage = null;
        if (this.url != null) {
            loadedImage = this.getToolkit().getImage(this.url);
        }
        this.setImage(loadedImage);
        this.repaint();
        this.changes.firePropertyChange("imageURL", oldValue, aUrl);
    }

    public URL getImageURL() {
        return this.url;
    }

    public void setURL(URL aUrl) throws PropertyVetoException {
        this.setImageURL(aUrl);
    }

    public URL getURL() {
        return this.getImageURL();
    }

    public void setCenterMode(boolean flag) throws PropertyVetoException {
        if (flag) {
            if (this.getStyle() != 1) {
                this.setStyle(1);
            }
        } else if (this.getStyle() != 3) {
            this.setStyle(3);
        }
    }

    public boolean getCenterMode() {
        return this.getStyle() == 1;
    }

    public void setStyle(int newStyle) throws PropertyVetoException {
        if (newStyle != this.imageStyle) {
            Integer oldValue = new Integer(this.imageStyle);
            Integer newValue = new Integer(newStyle);
            this.vetos.fireVetoableChange("style", oldValue, newValue);
            this.imageStyle = newStyle;
            this.repaint();
            this.changes.firePropertyChange("style", oldValue, newValue);
        }
    }

    public int getStyle() {
        return this.imageStyle;
    }

    public void setImage(Image img) throws PropertyVetoException {
        this.fileName = null;
        Image oldValue = this.image;
        this.vetos.fireVetoableChange("image", oldValue, img);
        this.image = img;
        if (img != null) {
            try {
                MediaTracker tracker = new MediaTracker(this);
                tracker.addImage(this.image, 0);
                tracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.repaint();
        }
        this.changes.firePropertyChange("image", oldValue, img);
    }

    public Image getImage() {
        return this.image;
    }

    public void paint(Graphics g) {
        block10: {
            Dimension dim;
            block9: {
                super.paint(g);
                dim = this.size();
                if (this.image == null) break block9;
                int imageWidth = this.image.getWidth(this);
                int imageHeight = this.image.getHeight(this);
                switch (this.imageStyle) {
                    default: {
                        g.drawImage(this.image, (dim.width - imageWidth) / 2, (dim.height - imageHeight) / 2, imageWidth, imageHeight, this);
                        break;
                    }
                    case 0: {
                        int numHImages = dim.width / imageWidth;
                        if (dim.width % imageWidth != 0) {
                            ++numHImages;
                        }
                        int numVImages = dim.height / imageHeight;
                        if (dim.height % imageHeight != 0) {
                            ++numVImages;
                        }
                        int v = 0;
                        int vCount = 0;
                        while (vCount < numVImages) {
                            int h = 0;
                            int hCount = 0;
                            while (hCount < numHImages) {
                                g.drawImage(this.image, h, v, imageWidth, imageHeight, this);
                                h += imageWidth;
                                ++hCount;
                            }
                            v += imageHeight;
                            ++vCount;
                        }
                        break block10;
                    }
                    case 2: {
                        g.drawImage(this.image, 0, 0, dim.width, dim.height, this);
                        break;
                    }
                    case 3: {
                        g.drawImage(this.image, 0, 0, this);
                        break;
                    }
                }
                break block10;
            }
            g.clearRect(0, 0, dim.width, dim.height);
        }
    }

    public Dimension preferredSize() {
        return this.image != null ? new Dimension(this.image.getWidth(this), this.image.getHeight(this)) : new Dimension(10, 10);
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.errors = ResourceBundle.getBundle("symantec.itools.resources.ErrorsBundle");
        if (this.url != null) {
            this.image = this.getToolkit().getImage(this.url);
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(this.image, 0);
            try {
                tracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                Object[] args = new Object[]{this.url};
                throw new IOException(MessageFormat.format(this.errors.getString("ErrorLoadingImageForURL"), args));
            }
        }
    }
}

