//---------------------------------------------------------------------------
//
// %FILE     ica.h
// %VSS-REV  $Revision: 7 $
// %CREATED  1996.04.11
// %REVISED  $Date: 4/18/97 4:06p $
// %AUTHOR   Michael C. Draeger 
// %PROJECT  NS486SXF evaluation board software
// %PART     NS486SXF, NS486SXL
// %SUMMARY  ICA header
//     
// %VSS      $Author: Miked $ $Date: 4/18/97 4:06p $ $Revision: 7 $
//
// DESCRIPTION
//
//   Header for ica.c.
//
// HISTORY
//
/*
 *
 * $History: ica.h $ 
 * 
 * *****************  Version 7  *****************
 * User: Miked        Date: 4/18/97    Time: 4:06p
 * Updated in $/nsdemo
 *  New header (comment) changes.
 * 
 * *****************  Version 6  *****************
 * User: Miked        Date: 8/06/96    Time: 11:59a
 * Updated in $/nsdemo
 * Version 1.4.  Maintainance release.  See README.TXT for info.
 * 
 * *****************  Version 5  *****************
 * User: Miked        Date: 7/23/96    Time: 2:25p
 * Updated in $/nsdemo
 * Maintainance release.  README.TXT describes changes.
 * 
 * *****************  Version 4  *****************
 * User: Miked        Date: 7/16/96    Time: 11:54a
 * Updated in $/nsdemo
 * Updated for rev C0 release.
 * 
 * *****************  Version 3  *****************
 * User: Miked        Date: 5/03/96    Time: 2:50p
 * Updated in $/nsdemo
 * Maintainence release.
 * 
 * *****************  Version 2  *****************
 * User: Miked        Date: 4/18/96    Time: 11:09a
 * Updated in $/nsdemo
 * Clean up for release.
 * 
 * *****************  Version 1  *****************
 * User: Miked        Date: 4/11/96    Time: 3:26p
 * Created in $/board test
 * header for ica.c
 *
 */
//
// COPYRIGHT
//
//      (c) 1996, 1997 National Semiconductor Corporation
//
//---------------------------------------------------------------------------

#ifndef ICA_H_INC
#define ICA_H_INC

//---------------------------------------------------------------------------
// Required headers

#include "nsglobal.h"

//---------------------------------------------------------------------------

// structure located at the ICA address

typedef struct
{
  DWORD valid;          // set to ICA_VALID if valid
  WORD  command;        // ICA command
  WORD  status;         // set to ICA_STATUS_OK if ICA is OK
  DWORD data_addr;      // address pointed to by ICA
  DWORD data_size;      // size of data at address pointed to by ICA
} ICA_TABLE;

// target info structure

typedef struct
{
  DWORD boot_status;    // not used
  DWORD original_eax;   // boot EAX value (0 in NS486SXF)
  DWORD original_edx;   // boot EDX value (microcode revision)
  DWORD cpu_speed;      // speed of CPU in Hz
  DWORD ram_size;       // ammount of DRAM detected
} ICA_TARGET_INFO;

//---------------------------------------------------------------------------

#define ICA_TBL_ADDR        0x4F0         // Address of ICA area

#define ICA_VALID           0xA1B2C3D4L   // ICA valid signature
#define ICA_CMD_NONE        0x0000        // ICA null command
#define ICA_CMD_TARGET_INFO 0x0005        // ICA Target Info command
#define ICA_STATUS_OK       0x0000        // ICA area OK indicator

//---------------------------------------------------------------------------

extern USHORT ICA_Target_Info_Read( ICA_TARGET_INFO * target_info );

//---------------------------------------------------------------------------

#endif // #ifndef ICA_H_INC

//---------------------------------------------------------------------------
// END       ica.h
//---------------------------------------------------------------------------
