;---------------------------------------------------------------------------
;
; FILE     io.inc
; TYPE     assembly header
; CREATED  1995.07.27
; REVISED  1995.08.01
; VERSION  1.0
; AUTHOR   Michael C. Draeger 
; SUMMARY  macros for I/O in elentari 
; RCS      $Id$
;
; DESCRIPTION
;
;   Four useful IO macros for use in assembly language code.
;
;       outpw - output a word to a port
;       outpb - output a byte to a port
;       inpw  - input a word from a port
;       inpb  - input a byte from a port
;
; INPUTS
;
; HISTORY/CONTRIBUTORS
;
;   1.0   1995.08.01  mcd  genesis
;   
;   (mcd = Michael C. Draeger)
;
; COPYRIGHT
;
;      (c) 1995 National Semiconductor Corporation
;
; NOTES
;
;---------------------------------------------------------------------------

; outpw - outputs a word to a I/O address
; dx and ax destroyed

outpw MACRO addr, val
  mov dx, addr          ;   address of port (16 bit value)
  mov ax, val           ;   value (16 bit)
  out dx, ax            ; output word
ENDM

; outpb - outputs a byte to a I/O address
; dx and al destroyed

outpb MACRO addr, val
  mov dx, addr          ;   address of port (16 bit value)
  mov al, val           ;   value (8 bit)
  out dx, al            ; output byte
ENDM

; inpw - inputs a word from a I/O address
; dx and ax destroyed

inpw MACRO addr
  mov dx, addr          ;   address of port (16 bit value)
  in  ax, dx            ; input word
ENDM

; inpb - inputs a byte from a I/O address
; dx and al destroyed

inpb MACRO addr
  mov dx, addr          ;   address of port (16 bit value)
  in  al, dx            ; input byte
ENDM

;---------------------------------------------------------------------------
; END       io.inc 
;---------------------------------------------------------------------------
