(*************************************************************************)
(*                                                                       *)
(*     PREPROCESSOR TO STRIP COMMENTS FROM LISP CODE SO THAT IT WILL     *)
(*     BE ACCEPTED BY THE INTERPRETER.  Comments are assumed to start    *)
(*     with a  '/*'  and end with a  '*/'.                               *)
(*     Algorithm used is the simulation of a finite state machine.       *)
(*     This program assumes that the input file is: <filename>.L, and    *)
(*     it names the output file: <filename>.LSP.                         *)
(*                                                                       *)
(*************************************************************************)


{$I-}  (* Turn off error checking. *)

const	ASTERISK = '*';
		SLASH    = '/';

type	state_type = ( IN_CODE, IN_COMMENT, START_COMMENT, STOP_COMMENT );

var	ch:		char;			(* The character currently being examined. *)

		out_file,				(* <filename>.L   *)
		in_file:	text;			(* <filename>.LSP *)

		in_file_name: string[11];

		state: state_type;

begin
	write( 'Enter filename ->' );                (* Prepare input file. *)
	readln( in_file_name );
	in_file_name := in_file_name + '.L';
	assign( in_file, in_file_name );
	reset( in_file );
	if IOresult <> 0 then
		writeln( 'Sorry, cannot open ', in_file_name )
	else begin
		assign( out_file, in_file_name + 'SP' );  (* Prepare output file.*)
		rewrite( out_file );
		state := IN_CODE;
		while not eof( in_file ) do begin         (* Copy from in to out. *)
			read( in_file, ch );
			case state of
				IN_CODE:       begin
										if ch = SLASH then state := START_COMMENT
										else write( out_file, ch );
									end;
				START_COMMENT: begin
										if ch = ASTERISK then state := IN_COMMENT
										else write( out_file, SLASH, ch );
									end;
				IN_COMMENT:    begin
										if ch = ASTERISK then state := STOP_COMMENT;
									end;
				STOP_COMMENT:	begin
										if ch = SLASH then state := IN_CODE
										else write( out_file, ASTERISK, ch );
									end;
			end;
		end;
		close( in_file );
		close( out_file );
	end;
end.



	readln( in_file_name );
	in_file_name := in_file_name + '.L';
