{$I SCREEN.INC }

const	DECIMAL = 10;
		OCTAL = 8;

var	resp: char;
		base: integer;
		r: byte;

procedure print_hex( d: integer );
	var i: integer;
	begin
		i := 0;
		while ( d >= 16 ) do
			begin
				d := d - 16;
				i := i + 1;
			end;
		if ( (i >= 0) and (i <= 9) ) then write( chr(i + 48) )
			else write( chr(i + 55) );
		if ( (d >= 0) and (d <= 9) ) then write( chr(d + 48) )
			else write( chr(d + 55) );
	end;

procedure print_cc( i: integer );
	begin
		if ( i <= 26 ) then write( '^', chr(i + 64) );
	end;

procedure print_oct( i: integer );
	begin
		write( i div 64 );
		i := i mod 64;
		write( i div 8 );
		i := i mod 8;
		write( i );
	end;

procedure print_asc( i: integer );
	begin
		case i of
			 0: write( 'NUL' );
			 1: write( 'SOH' );
			 2: write( 'STX' );
			 3: write( 'ETX' );
			 4: write( 'EOT' );
			 5: write( 'ENQ' );
			 6: write( 'ACK' );
			 7: write( 'BEL' );
			 8: write( 'BS ' );
			 9: write( 'HT ' );
			10: write( 'LF ' );
			11: write( 'VT ' );
			12: write( 'FF ' );
			13: write( 'CR ' );
			14: write( 'SO ' );
			15: write( 'SI ' );
			16: write( 'DLE' );
			17: write( 'DC1' );
			18: write( 'DC2' );
			19: write( 'DC3' );
			20: write( 'DC4' );
			21: write( 'NAK' );
			22: write( 'SYN' );
			23: write( 'ETB' );
			24: write( 'CAN' );
			25: write( 'EM ' );
			26: write( 'SUB' );
			27: write( 'ESC' );
			28: write( 'FS ' );
			29: write( 'GS ' );
			30: write( 'RS ' );
			31: write( 'US ' );
			32: write( 'SP ' );
			127: write( 'DEL' );
		else
			write( ' ', chr(i), ' ' );
		end;
	end;

procedure print_headings( base: integer );
	var	b_str: string[3];
	begin
		if ( base = 10 ) then b_str := 'dec' else b_str := 'oct';
		on( UNDERLINE );
		pos_cur( 1, 1 );
		write( b_str, ' hx asc CC' );
		pos_cur( 17, 1 );
		write( b_str, ' hx asc CC' );
		pos_cur( 30, 9 );
		write( b_str, ' hx asc' );
		pos_cur( 43, 9 );
		write( b_str, ' hx asc' );
		pos_cur( 56, 1 );
		write( b_str, ' hx asc' );
		pos_cur( 69, 1 );
		write( b_str, ' hx asc' );
		off( UNDERLINE );
	end;

procedure print_menu( base: integer );
	begin
		lineon( 64, 1, 105, 1 );
		lineon( 64, 1, 64, 27 );
		lineon( 64, 27, 105, 27 );
		lineon( 105, 1, 105, 27 );

		pos_cur( 35, 2 );
		write( 'ASCII CHART MENU' );
		pos_cur( 33, 3 );
		write( '--------------------' );

		pos_cur( 35, 4 );
		if ( base = DECIMAL ) then write( ' O =  octal list ' )
									 else write( ' D = decimal list' );
		pos_cur( 35, 5 );
		write( 'ESC = return to' );
		pos_cur( 35, 6 );
		write( '      main menu' );
	end;

procedure paint_screen( base: integer );
	var	i, x, y: integer;
	begin
		for i := 0 to 127 do
			begin
				if ( i = 0 ) then begin x := 1; y := 2; end;
				if ( i = 24 ) then begin x := 17; y := 2; end;
				if ( i = 48 ) then begin x := 30; y := 10; end;
				if ( i = 64 ) then begin x := 43; y := 10; end;
				if ( i = 80 ) then begin x := 56; y := 2; end;
				if ( i = 104 ) then begin x := 69; y := 2; end;
				pos_cur( x, y );
				if ( base = DECIMAL) then write( i :3 ) else print_oct( i );
				write( ' ' );
				print_hex( i );
				write( ' ' );
				print_asc( i );
				write( ' ' );
				print_cc( i );
				y := y + 1;
			end;
	end;

begin
	off( CURSOR );

	base := DECIMAL;
	
	repeat
		print_headings( base );
		print_menu( base );
		paint_screen( base );
		repeat
			resp := chr( bdos( 6, -1 ) );
		until( (resp='o') or (resp='O') or (resp='d')
					 or (resp='D') or(resp=chr(27)) );
		case resp of
			'o', 'O' : base := OCTAL;
			'd', 'D' : base := DECIMAL;
		end;
	until( resp = chr(27) );

	on( cursor );
end.	
