| SCB
	.text
	.globl	start,_exit,_inp,_outp,_cont,_scb
_scb:
	.long	0,0x400,trap,trap,trap,trap,trap,trap
	.long	trap,trap,trap,trap,trap,trap,trap,trap
	.long	0,0,0,0,0,0,0,0
	.long	trap,lvl1,lvl2,lvl3,lvl4,lvl5,lvl6,lvl7
	.long	trap,trap,trap,trap,trap,trap,trap,trap
	.long	trap,trap,trap,trap,trap,trap,trap,trap
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,0,0
	.long	0,0,0,0,0,0,_inp,_outp
|
	.text
|
	.globl	start,_exit
start:
	movw	#0x2700,sr
	reset
|
|
|
here:   lea     pc@(_scb-(here+2)),a2 	| physical location of start

	movl	#_scb,a0			| linked address
	cmpl	a0,a2			| are we here ?
	beq	warmstart		| yes, then start code
|
|	relocate 
|
	movl	#_end,a1		| end address
	movl	#_scb,a0			| where to
l1:
	movb	a2@+,a0@+		| copy from loaded to real address
	cmpl	a1,a0			| done yet ?
	bne	l1
|
	bra	warmstart
|
|
warmstart:
	movl	#0x80008000,sp
|	movl	#_end+0x2000,sp
|	movl	#0,sp		| end of dram
|	movl	#_mon,_state	| current state is monitor
	lea	_scb,a0
	movc	a0,vbr

	clrl	sp@-		| disable tc
|	pmoveflush	sp@,tc
	addl	#4,sp

	jsr	_main
_exit:
	jmp	start
|
|
lvl6:
lvl5:
lvl4:
lvl3:
lvl2:
lvl1:
	rte
|
| we get here because some exception happened in the user's code
| save the state of his/her process and go back to the monitor
|
lvl7:
trap:
	movw	#0x2700,sr	| status -> block all interrupts
	movl	a6,sp@-		| save a6
	movl	_state,a6	| get current state block
	moveml	d0-d7/a0-a5,a6@	| save the first bunch of registers 
	movl	sp@+,a6@(56)	| save a6
	movl	usp,a0
	movl	a0,a6@(60)	| save usp
	movw	sp@,a6@(76)	| save sr
	movl	sp@(2),a6@(72)	| save pc
	movw	sp@(6),a6@(124)	| vector/frame type 
	movl	sp,a6@(64)	| save ssp
	movc	sfc,d0
	movb	d0,a6@(78)
	movc	dfc,d0
	movb	d0,a6@(79)

	movc	cacr,d0
	movl	d0,a6@(84)

	movc	caar,d0
	movl	d0,a6@(88)

	movc	vbr,a0
	movl	a0,a6@(80)	| save vbr

	pmove	crp,a6@(92)
	pmove	srp,a6@(100)
	pmove	tc,a6@(108)
	pmove	tt0,a6@(112)
	pmove	tt1,a6@(116)
|	pmove	mmusr,a6@(120)

	jmp	warmstart

|
| continue code from the saved control block
|
_cont:
	movl	_state,a6	| get current state...

	movl	a6@(80),a0
	movc	a0,vbr	

	movl	a6@(84),d0
	movc	d0,cacr

	movl	a6@(88),d0
	movc	d0,caar

|	pmove	a6@(100),srp
|	pmove	a6@(108),tc
|	pmove	a6@(112),tt0
|	pmove	a6@(116),tt1
|	pmove	a6@(120),mmusr

	movl	a6@(60),a0
	movl	a0,usp
	movl	a6@(64),sp
	moveml	a6@,d0-d7/a0-a5

	movw	#0,sp@-		| short frame
	movl	a6@(72),sp@-	| pc
	movw	a6@(76),sp@-	| sr
	movl	a6@(56),a6

	rte
