/* SCCSID(@(#)memmdl.h	5.1	LCC)	Modified: 8/31/88 10:35:38 */
/*	@LCCID(memmdl.h, 5.1, 8/31/88, 10:35:38) */

/* 
    This file contains definitions for compiling the OEM library for
    different memory models using the Lattice or Microsoft C compilers.

    History:
    [9/1/87 PD] Peter Dobson - Corrected to handle microsoft
    	Compact, and Huge models.  Added DOSREGSX and Doscallx
	for programs that must process segment registers even if
	they are running small model.
    [11/20/87 PD] Updated from /pcid/dos/2_8_6/oemlib/memmdl.h -
    	no code changes.
*/

#ifdef LATTICE

#define FP_SEG(fp) fp_seg(&fp)
#define FP_OFF(fp) fp_off(&fp)

#define UCHAR char
#define UINT unsigned
#define USHORT unsigned
#define FLAGVAR int flagvar
#define FLAGTEST flagvar

#define DOSREGSX union REGS regs; \
		 int flagvar; \
		 struct SREGS sregs; \
		 segread(&sregs);
#define Doscallx(in,out,seg) flagvar = (intdosx(in,out,seg) & 1)

#ifdef SPTR
#define SMALLD
#define DOSREGS union REGS regs; int flagvar
#define Doscall(in,out,seg) flagvar = (intdos(in,out) & 1)
#else
#define LARGED
#define DOSREGS union REGS regs; \
		int flagvar; \
		struct SREGS sregs; \
		segread(&sregs);
#define Doscall(in,out,seg) flagvar = (intdosx(in,out,seg) & 1)
#endif /* SPTR */

#endif /* LATTICE */

#ifdef MICROSOFT

#define UCHAR unsigned char
#define UINT unsigned int
#define USHORT unsigned short
#define FLAGVAR
#define FLAGTEST regs.x.cflag

#define DOSREGSX union REGS regs; \
		 struct SREGS sregs; \
		 segread(&sregs);
#define Doscallx(in,out,seg) intdosx(in,out,seg)

#if defined(M_I86CM) || defined(M_I86LM) || defined(M_I86HM)
#define LARGED
#define DOSREGS union REGS regs; \
		struct SREGS sregs; \
		segread(&sregs);
#define Doscall(in,out,seg) intdosx(in,out,seg)
#else
#define SMALLD
#define DOSREGS union REGS regs
#define Doscall(in,out,seg) intdos(in,out)
#endif

#endif /* MICROSOFT */

#ifdef SMALLD

#define SETSEG(dst,src) 
#define SETOFF(dst,src) dst = FP_OFF(src)

#endif

#ifdef LARGED

#define SETSEG(dst,src) dst = FP_SEG(src)
#define SETOFF(dst,src) dst = FP_OFF(src)

#endif
