#if defined(SCCS_ID)
static char Sccs_Id[] = 
	"11/10/89  @(#)xanswer.c	1.3  10:18:26";
#endif

/*
   (c) Copyright 1989 by Locus Computing Corporation.  ALL RIGHTS RESERVED.

   This material contains valuable proprietary products and trade secrets
   of Locus Computing Corporation, embodying substantial creative efforts
   and confidential information, ideas and expressions.  No part of this
   material may be used, reproduced or transmitted in any form or by any
   means, electronic, mechanical, or otherwise, including photocopying or
   recording, or in connection with any information storage or retrieval
   system without permission in writing from Locus Computing Corporation.
*/

/*
   xanswer.c - wait for connections from X terminals
*/

#include <stdio.h>
#include <ctype.h>
#include <signal.h>

int NetWaitCon();
int NetRead();
void NetClose();
void NetError();

long strtol();

void Usage();
void Spawn();

#define DEFAULT_PORT	7000
#define DEFAULT_FMT	"xdm -server \"%s foreign xanswer\""



int
main(ac, av)
int ac;
char *av[];
{
    int port;
    char *fmt;
    char display[64];
    int ax;
    char *arg;
    int desc;
    int chldstat;

    /*
       The daemon made me do it.
    */
    if (fork()) exit(0);
    setpgrp();
    for (ax=0; ax<20; ax++) close(ax);
    
    /*
       Set defaults
    */
    fmt = DEFAULT_FMT;
    port = DEFAULT_PORT;
    
    /*
       Process options
    */
    for (ax=1; ax < ac && *av[ax] == '-'; ax++) {
	
	arg = av[ax];
	switch (tolower(arg[1])) {
	    case 'p':
		ax++;
		if (ax < ac)
		    port = strtol(av[ax], (char **)NULL, 0);
		else
		    Usage();
		break;
		
	    default:
		Usage();
		break;
	}
    }
    
    /*
       If an argument left, it is the command format
    */
    if (ax < ac) {
	fmt = av[ax];
	ax++;
    }
    
    if (ax < ac)
	Usage();
    
    /*
       Fork a child to wait for a connection.  The child will exit
       after a connection comes in and we will repeat the process.
       It's done this way because some TCP/IP implementations don't
       appear to clean up properly when we just close the network
       descriptors.  So, we want any process that had a network
       descriptor open to exit.
    */
    for (;;) {
	if (fork()) {
	    wait(&chldstat);
	}
	else {
	    break;
	}
    }
    
    {
	desc = NetWaitCon(port);
	if (desc == -1) {
	    NetError(av[0]);
	}
	else {
	       
	    /*
	       Fork a child to read the display name and exec the
	       display manager.  The parent exits immediately so
	       another listener gets started.
	    */
	    if (fork()) {
		NetClose(desc);
	    }
	    else {
		if (ReadString(desc, display, sizeof(display))) {
	            NetClose(desc);
		    Spawn(fmt, display);
		}
		else {
		    NetError(av[0]);
		    NetClose(desc);
		    fprintf(stderr, "%s: Error reading display name", av[0]);
		}
		exit(1);
	    }
	}
	
	exit(0);
    }
}

void
Usage()
{
    fprintf(stderr, "Usage: xanswer [-p port#] [command format]\n");
    exit(1);
}

int
ReadString(desc, buf, size)
int desc;
char *buf;
int size;
{
    int len;
    int totLen;
    char *bp;
    
    totLen = 0;
    bp = buf;
    while (size && (len = NetRead(desc, bp, size))) {
	bp += len;
	totLen += len;
	size -= len;
	if (bp[-1] == 0)
	    return totLen;
    }
    
    return 0;
}

void
Spawn(fmt, display)
char *fmt;
char *display;
{
    char command[128];
    char dispvar[128];

    sprintf(command, fmt, display);
    sprintf(dispvar, "DISPLAY=%s", display);
    putenv(dispvar);
    execl("/bin/sh", "sh", "-c", command, (char *)NULL);
    perror(display);
    exit(1);
}
