C
C            GENERAL INSTRUMENT CORPORATION
C            MICROELECTRONICS DIVISION
C            600 WEST JOHN STREET
C            HICKSVILLE, NEW YORK  11802
C
C            CP 1600 PROM TAPE GENERATOR VER. 01A
C
C
C            LOAD MODULE RECORD FORMAT
C
C            LENGTH - 64 WORDS
C
C            WORD 1 - RECORD HEADER
C                   0001 OR 0002 ON ALL BUT LAST RECORD
C                   0001 FOR RELOCATABLE ASSEMBLY
C                   0002 FOR ABSOLUTE ASSEMBLY
C            NEGATIVE ON LAST RECORD
C            WORD 2 - ASSEMBLY BASE ADDRESS (FIRST RECORD ONLY)
C            WORD 3 - NUMBER OF DATA WORDS IN RECORD
C            WORD 4 - 64 - OBJECT DATA
C
C            OBJECT DATA SEQUENCES ARE 1 TO 4 WORDS IN LENGTH
C
C
C
C
C
      COMMON /INFO/ KADDR,  KDATA, KSTATS
      COMMON /ROM/ KRADR,  KRIDX,  KROM(512)
      DIMENSION KRCBFR(64)
      DIMENSION KOCT(6)
      EQUIVALENCE (KRCHDR,KRCBFR(1))
      EQUIVALENCE (KASMAD,KRCBFR(2))
      EQUIVALENCE (KRCKNT,KRCBFR(3))
      DIMENSION NAMBIN(16)
      DIMENSION INPSTR(20)
      DATA KSPC/' '/
      DATA KCOMMA/','/
      DATA KEYBD/1/,KDSPLY/2/,KBINF/3/
      DATA KZFF00/4ZFF00/
      DATA KZFF/2ZFF/
      DATA KZFC/2ZFC/
      DATA KZ303/3Z303/
      DATA KZFC00/4ZFC00/
      DATA KZ3FF/3Z3FF/
      DATA KZ1FF/3Z1FF/
      DATA KZFFFF/4ZFFFF/
      DATA KZFF03/4ZFF03/
C
C            IDENTIFY VERSION IN USE
C
      WRITE(KDSPLY,1005)
 1005 FORMAT(' GI S16PRTG VER. 01A')
C
C            CLEAR INPUT BUFFER
C
   10 DO 20 I = 1, 20, 1
      INPSTR(I) = KSPC
   20 CONTINUE
C
C            REQUEST LOAD MODULE NAME,ACCOUNT
C
      WRITE(KDSPLY,1000)
 1000 FORMAT(' LOAD MODULE NAME,ACCNT ?')
      READ(KEYBD,1010) INPSTR
 1010 FORMAT(20A1)
      IF(INPSTR(1) .EQ. KSPC) STOP
C
C            SEPARATE FILE NAME AND ACCOUNT STRINGS
C
      DO 40 I = 1, 16, 1
      NAMBIN(I) = KSPC
   40 CONTINUE
      I = 1
      DO 60 K = 1, 8, 1
C
C            MOVE FILE NAME UNTIL SPACE OR COMMA
C
      IF(INPSTR(I) .EQ. KSPC) GO TO 140
      IF(INPSTR(I) .EQ. KCOMMA) GO TO 80
      NAMBIN(I) = INPSTR(I)
      I = I + 1
   60 CONTINUE
C
C            AFTER 8 CHR NAME MOVED, CHECK FOR ACCOUNT ENTERED
C
      IF(INPSTR(I) .EQ. KSPC) GO TO 140
C
C            CHECK FOR COMMA SEPARATOR
C
      IF(INPSTR(I) .NE. KCOMMA) GO TO 120
C
C            HAVE COMMA, BYPASS IT, MOVE ACCOUNT
C
   80 I = I + 1
      J = 9
      DO 100 K = 1, 8, 1
      IF(INPSTR(I) .EQ. KSPC) GO TO 140
      NAMBIN(J) = INPSTR(I)
      J = J + 1
      I = I + 1
  100 CONTINUE
C
C            CHECK FOR MORE THAN 8 CHR ACCOUNT STRING
C
      IF(INPSTR(I) .EQ. KSPC) GO TO 140
C
C            STRING ERROR
C
  120 WRITE(KDSPLY,1030)
 1030 FORMAT(' STRING ERROR !!')
      GO TO 10
C
C            OPEN BINARY FILE FOR INPUT
C
  140 CALL OPNINP(NAMBIN(1),NAMBIN(9),K)
C
C            CHECK FOR FILE EXISTANT
C
      IF(K .EQ. 0) GO TO 150
      WRITE(KDSPLY,1035)
 1035 FORMAT(' FILE DOES NOT EXIST !!')
      GO TO 10
C
C             REQUEST RELOCATION ADDRESS
C
  150 WRITE(KDSPLY,1070)
 1070 FORMAT(' RELOCATION ADDRESS ?')
      LDADR = -1
      CALL XTROCT(J,K)
      IF(J .EQ. 0) GO TO 180
      LDADR = K
C
C              REQUEST PROM BASE ADDRESS
C
  180 WRITE(KDSPLY,1130)
 1130 FORMAT(' PROM BASE ADDRESS ?')
      CALL XTROCT(J,K)
      IF(J .EQ. 0) GO TO 180
C
C              CHECK FOR VALID PROM BASE ADDRESS
C
      IF(IAND(K,KZ1FF) .NE. 0 ) GO TO 180
      KRADR = K
C
C             COMMENCE PROCESSING
C
      WRITE(KDSPLY,1140)
 1140 FORMAT(' PROCESSING...')
C
C              ZERO PROM BUFFER
C
      DO 190 KRIDX  = 1, 512
      KROM(KRIDX)    = 0
  190 CONTINUE
C
C            INITIALIZE PROM BUFFER POINTER
C
      KRIDX  = 0
C
C            SET FIRST RECORD FLAG
C
      KBINFL = 0
C
C            READ A RECORD
C
  200 READ(KBINF) KRCBFR
C
C            CHECK FOR NULL RECORD
C
      IF(KRCKNT .EQ. 0) GO TO 620
C
C            SET BUFFER POINTER TO FIRST DATA ITEM
C
      INPTR = 4
C
C            SET LOAD BASE ADDRESS IF FIRST RECORD
C
      IF(KBINFL .NE. 0) GO TO 220
      KBINFL = 1
C
C            CHECK FOR NO USER SPECIFIED LOAD ADDRESS
C
      IF(LDADR .EQ. -1) GO TO 210
C
C            HAVE USER SPECIFIED LOAD ADDRESS
C            CHECK FOR ABSOLUTE ASSEMBLY FILE AND LOAD ADDRESS
C            DIFFERENT THAN ASSEMBLY ADDRESS
C
      IF(IABS(KRCHDR) .EQ. 2 .AND. KASMAD .NE. LDADR) GO TO 600
C
C            USER HAS SPECIFIED LOAD ADDRESS, COMPUTE ADDRESS ADJUSTMENT
C            TO BE USED FOR RELOCATION OF PROGRAM.  SECOND WORD IN
C            FIRST RECORD IS PROGRAM ASSEMBLY BASE ADDRESS.
C
      KADADJ = LDADR - KASMAD
      GO TO 220
C
C            NO USER LOAD ADDRESS, USE ASSEMBLY BASE ADDRESS TO LOAD
C
  210 LDADR = KASMAD
      KADADJ = 0
C
C            CHECK FOR VALID ROM BASE ADDRESS
C
      IF(KRADR .LT. LDADR) GO TO 180
C
C            DATA SEQUENCE CODE
C
  220 K = KRCBFR(INPTR)
C
C            INCREMENT BUFFER POINTER
C
      INPTR = INPTR + 1
C
C            RELOCATION CODES
C
C            0 - ADDRESS ADJUSTMENT
C            1 - NO RELOCATION ON NEXT WORD
C            2 - NO RELOCATION ON NEXT 2 WORDS
C            3 - NO RELOCATION ON NEXT 3 WORDS
C            4 - RELOCATE NEXT WORD
C            5 - NO RELOCATION ON NEXT WORD, RELOCATE NEXT+1 WORD
C            6 - NO RELOCATION ON NEXT WORD, RELOCATE NEXT+1, NEXT+2
C            7 - RELOCATE NEXT 2 BYTES
C            8 - NO RELOCATION ON NEXT WORD, RELOCATE NEXT+1, NEXT+2
C            15 - USE NEXT WORD AS ENTRY ADDRESS
C            16 - MODULE IDENTIFICATION (IGNORED BY LOADER)
C
C
C            CHECK FOR CODE 0
C
      IF(K      .NE. 0) GO TO 240
C
C            CODE 0 ADDRESS CHANGE
C            USE NEXT WORD TO ADJUST LOAD ADDRESS
C
      LDADR = LDADR + KRCBFR(INPTR)
      IF(KRIDX  .EQ. 0) GO TO 420
      WRITE(KDSPLY,1050)
 1050 FORMAT(' NON SEQUENTIAL ADDRESSING IN PROM,',
     1       ' ZEROS USED IN UNDEFINED LOCATIONS')
      GO TO 420
C
C            FIRST DATA WORD IN SEQUENCE
C
  240 KADDR  = LDADR
      KDATA  = KRCBFR(INPTR)
      INPTR = INPTR + 1
C
C            CHECK FOR MODULE IDENT SEQUENCE
C
      IF(K      .EQ. 16) GO TO 420
C
C            CHECK FOR ENTRY CODE
C
      IF(K      .EQ. 15) GO TO 460
  250 LDADR = LDADR + 1
C
C            CHECK FOR LINKER CODES
C
      IF(K .GT. 8) GO TO 255
C
C            DETERMINE RELOCATION TYPE
C
C              1    2    3    4    5    6    7    8
C
      GO TO ( 340, 280, 260, 320, 300, 360, 370, 380 ), K
C
C            LOAD MODULE CONTAINS LINKAGE CODES, CANNOT LOAD
C
  255 WRITE(KDSPLY,1060)
 1060 FORMAT(' LOAD MODULE CONTAINS LINKAGE INFORMATION,',
     +       ' PROM ABORTED !!')
      GO TO 620
C
C            TYPE 3 - NO RELOCATION ON NEXT 3 WORDS
C
C            STORE FIRST WORD
C
  260 CALL LODROM
C
C            CHECK FOR VALID STORE ADDRESS, IE, HAS BEEN DEFINED
C
      IF(KSTATS .LT. 0) GO TO 500
C
C            SECOND WORD
C
      KADDR  = LDADR
      KDATA  = KRCBFR(INPTR)
C
C            INCREMENT STORAGE ADDRESS, BUFFER POINTER
C
      LDADR = LDADR + 1
      INPTR = INPTR + 1
C
C            TYPE 2 - NO RELOCATION ON NEXT 2 WORDS
C
C            STORE TYPE 3 SECOND WORD, TYPE 2 FIRST WORD
C
  280 CALL LODROM
      IF(KSTATS .LT. 0) GO TO 500
C
C            LAST DATA WORD
C
      KDATA  = KRCBFR(INPTR)
      GO TO 400
C
C            TYPE 5 - NO RELOCATION ON NEXT WORD, RELOCATE NEXT+1 WORD
C
C            STORE FIRST WORD
C
  300 CALL LODROM
      IF(KSTATS .LT. 0) GO TO 500
C
C            SECOND WORD
C
      KADDR  = LDADR
      KDATA  = KRCBFR(INPTR)
      LDADR = LDADR + 1
      INPTR = INPTR + 1
C
C            TYPE 4 - RELOCATE NEXT WORD
C
C            RELOCATE TYPE 5 SECOND WORD
C
  320 KDATA  = KDATA  + KADADJ
C
C            STORE WORD
C
  340 CALL LODROM
      IF(KSTATS .LT. 0) GO TO 500
      GO TO 460
C
C            TYPE 6 - 3 WORD DOUBLE BYTE INSTRUCTION WITH RELOCATION ON
C            SECOND AND THIRD WORDS.  SECOND WORD LOWER 8 BITS HOLDS
C            LOW BYTE OF ADDRESS WORD, THIRD WORD LOWER 8 BITS HOLDS
C            HIGH BYTE OF ADDRESS WORD.
C
C            TYPE 7 - 2 BYTE RELOCATION
C            STORE INSTRUCTION WORD
C
  360 CALL LODROM
      IF(KSTATS .LT. 0) GO TO 500
      KADDR  = LDADR
      KDATA  = KRCBFR(INPTR)
      LDADR = LDADR + 1
      INPTR = INPTR + 1
C
C            COMBINE HIGH AND LOW BYTE AND RELOCATE ADDRESS WORD
C
  370 K=IOR(IAND(KDATA,KZ3FF),IAND(KRCBFR(INPTR),KZ3FF)*256)+KADADJ
C
C            EXTRACT LOW BYTE AND STORE IT
C
      KDATA=IOR(IAND(KDATA,KZFC00),IAND(K,KZFF))
      CALL LODROM
      IF(KSTATS .LT. 0) GO TO 500
C
C            EXTRACT HIGH BYTE AND STORE
C
      KDATA=IOR(IAND(KRCBFR(INPTR),KZFC00),IAND(K,KZFF00)/256)
      GO TO 400
C
C            TYPE 8 - THREE WORD JUMP INSTRUCTION ON RELOCATION ON
C            SECOND AND THIRD WORDS.  SECOND WORD BITS 2'7 - 2'2
C            HOLD UPPER 6 BITS OF ADDRESS WORD.  THIRD WORD LOWER
C            10 BITS HOLD LOWER 10 BITS OF ADDRESS WORD.
C
C            STORE INSTRUCTION
C
  380 CALL LODROM
      IF(KSTATS .LT. 0) GO TO 500
      KADDR  = LDADR
      KDATA  = KRCBFR(INPTR)
      LDADR = LDADR + 1
      INPTR = INPTR + 1
C
C            COMBINE HIGH AND LOW ADDRESS PORTIONS AND RELOCATE
C
      K=IOR(IAND(KDATA,KZFC)*256,IAND(KRCBFR(INPTR),KZ3FF))+KADADJ
C
C            EXTRACT UPPER 6 BITS, INSERT BACK IN ORIGINAL WORD, STORE
C
      KDATA  = IOR(IAND(KDATA,KZFF03),(IAND(K,KZFC00)/256))
      CALL LODROM
      IF(KSTATS .LT. 0) GO TO 500
C
C            EXTRACT LOWER 10 BITS, STORE
C
      KDATA=IOR(IAND(KRCBFR(INPTR),KZFC00),IAND(K,KZ3FF))
  400 KADDR  = LDADR
      CALL LODROM
      IF(KSTATS .LT. 0) GO TO 500
      LDADR = LDADR + 1
  420 INPTR = INPTR + 1
C
C            CHECK FOR RECORD EXHAUSTED
C
  460 IF(INPTR-3 .LE. KRCKNT) GO TO 220
C
C            CHECK FOR LAST RECORD
C
      IF(KRCHDR .GT. 0) GO TO 200
      IF (KRIDX .LT. 512) WRITE(KDSPLY,1050)
C
C            CLOSE LOAD MODULE FILE
C
  500 CALL CLSINP
C
C     OPEN PAPER TAPE
C
      CALL OPNTAP
C
C        PUNCH LEADER
C
      DO 510 I = 1,100
      CALL PUNFRM(0)
510   CONTINUE
      CALL PUNFRM(KZFF)
C
C        PUNCH LOWER 8 BITS
C
      DO 520 I = 1,512
      J = IAND(KROM(I),KZFF)
      CALL PUNFRM(J)
520   CONTINUE
C
C        PUNCH LEADER
C
      DO 530 I = 1,100
      CALL PUNFRM(0)
530   CONTINUE
      CALL PUNFRM(KZFF)
C
C        PUNCH HIGH 8 BITS
C
      DO 540 I = 1,512
      J = IAND(ISL(KROM(I),-8),KZFF)
      CALL PUNFRM(J)
540   CONTINUE
C
C        PUNCH TRAILER
C
      DO 550 I = 1,100
      CALL PUNFRM(0)
550   CONTINUE
C
C        CLOSE PAPER TAPE
C
      CALL CLSTAP
      GO TO 640
C
C            ATTEMPT TO RELOCATE ABSOLUTE ASSEMBLY FILE
C
  600 WRITE(KDSPLY,1040)
 1040 FORMAT(' ABS LOAD MODULE, CANNOT RELOCATE, PROM ABORTED !!')
C
C            CLOSE LOAD MODULE FILE
C
  620 CALL CLSINP
  640 WRITE(KDSPLY,1220)
 1220 FORMAT(/)
      GO TO 10
      END
      SUBROUTINE LODROM
      COMMON /INFO/ KADDR,  KDATA, KSTATS
      COMMON /ROM/ KRADR,  KRIDX,  KROM(512)
C
      KSTATS = 1
C
C            DO NOT LOAD ROM BUFFER UNTIL LOAD
C            ADDRESS REACHES ROM BASE ADDRESS
C
      IF(KADDR .LT. KRADR) RETURN
      KRIDX = KADDR - KRADR + 1
      IF(KRIDX  .GT. 512) GO TO 20
      KROM(KRIDX)    = KDATA
      RETURN
   20 KSTATS = -1
      RETURN
      END
      SUBROUTINE XTROCT(KSTAT,KVALU)
      DIMENSION KOCT(6), KDIG(8)
      DATA KDIG/'0','1','2','3','4','5','6','7'/
      DATA KSPC/' '/, KEYBD/105/, KDSPLY/108/
C
  100 DO 200 I = 1, 6
      KOCT(I) = KSPC
  200 CONTINUE
      KSTAT = 0
      KVALU = 0
      READ(KEYBD,1000) KOCT
 1000 FORMAT(6A1)
      DO 500 I = 1, 6
      IF(KOCT(I) .EQ. KSPC) GO TO 500
      DO 300 J = 1, 8
      IF(KOCT(I) .EQ. KDIG(J)) GO TO 400
  300 CONTINUE
      WRITE(KDSPLY,2000)
 2000 FORMAT(' ?')
      GO TO 100
  400 KVALU = IOR(ISL(KVALU,3),J-1)
      KSTAT = 1
  500 CONTINUE
      KVALU = IAND(KVALU,4ZFFFF)
      RETURN
      END
 