C	  GETGIN GRAPHICS INPUT ROUTINE FOR TEKTRONIX 4662 PLOTTER
C	  WRITTEN BY MICHAEL LAMPI
C	  SPRING 1979
C
	COMMON/DFILE/IBUF(10000)
	LOGICAL*1 FNAME(16)
	DATA LINES,ISUBP/0,1/,INTENS/5/,MAXBUF/10000/
C
	CALL INIT(10000)
C	  FIND OUT WHERE THE START OF THE DISPLAY FILE IS
	CALL DPTR(I)
	MAXBUF=MAXBUF-I
C	  INITIALIZE PLOTTER (TURN ON)
	CALL OUTT("33)
	CALL OUTT('A')
	CALL OUTT('E')
5	CALL OUTT("33)
	CALL OUTT('A')
	CALL OUTT('N')
C	  INITIALIZE LIGHTS TO DEFAULTS & BUTTONS TO 'OFF'
	CALL DROUT("102005)
	CALL DRIN(0)
	WRITE(5,8)
 9	FORMAT(Q,A16)
 8	FORMAT(' GETGIN - Plotter Input Routine',/
     C		,$,' Instructions? ')
	READ(5,9) LEN,ANSWER
	IF(LEN.EQ.0.OR.ANSWER.EQ.'N') GOTO 10
C	  PRINT INSTRUCTIONS
	WRITE(5,6)
 6	FORMAT(/,' This program is used with the Tektronix 4662 flatbed'
     C		,' plotter and',/,' LK-11 function box to digitize data'
     C		,' in either a stream mode or',/
     C		,' a point mode. The function box button assignments',
     C		,' as follows:',/
     C		,'    1 - Change from stream to point mode & vice-versa'
     C	      ,/,'    3 - Stop digitizing; allows you to quit'
     C	      ,/,'    9 - Change intensity to 0 (off)'
     C	      ,/,'   10 - Change intensity to 2'
     C	      ,/,'   11 - Change intensity to 5'
     C	      ,/,'   12 - Change intensity to 8'
     C	      ,/,'   16 - When in point mode, digitize this point'
     C	      ,/,' The lit button for intensity indicates which'
     C		,' intensity is in effect.'
     C	      ,/,'    You are started in Point digitizing mode with the'
     C		,' intensity set to 5',//)
C
C	  GIVE 'EM CROSSHAIRS TO LOOK AT
 10	CALL SUBP(1)
	CALL APNT(512.,512.,,-4,1)
	CALL VECT(15.,0.)
	CALL VECT(-15.,-15.,,-4)
	CALL VECT(0.,30.)
	CALL VECT(-15.,-15.,,-4)
	CALL VECT(15.,0.)
	CALL ESUB
C	  NOW POINT TO IT
	CALL POINTR(1,1)
C	  NOW JUMP TO POINT MODE
	GOTO 150
C
C	  STREAM DIGITIZING MODE
C
 20	WRITE(5,30)
 30	FORMAT(' Stream digitizing mode',/,' Hit button 1 to switch to',
     C		' POINT mode if desired',/,
     C		' Hit button 3 to quit',/)
	LASTX=IX
	LASTY=IY
	ISUBP=ISUBP+1
	CALL SUBP(ISUBP)
	CALL APNT(FLOAT(LASTX),FLOAT(LASTY),,-IABS(INTENS),-1,1)
C	  NOW GO INTO PLOTTING LOOP
 90	OSLOPE=9999999.
	ODX=999999.
	MOVE=0
	IF(INTENS.LT.0) MOVE=1
C	  INITIALIZE BUTTONS
C	  AND TURN ON LIGHTS
	CALL DROUT(IDROUT(DUMMY).AND."007405)
 95	CALL DRIN(0)
 100	CALL GETGIN(IX,IY,2,IERR)
C	  CHECK FOR USER PRESSING BUTTON
	IBUT=IDRIN(DUMMY)
	CALL DRIN(0)
C	  DOES HE WANT TO QUIT?
	IF((IBUT.AND.4).NE.0) GOTO 200
	IF(IERR.NE.0) GOTO 100
C	  MOVE THE CURSOR
	CALL CHANGE(1,FLOAT(IX),FLOAT(IY))
C	  SEE IF HE WANTS TO CHANGE TO POINT MODE
	IF((IBUT.AND.1).EQ.0) GOTO 101
	CALL ESUB
	GOTO 150
C	  CHECK IF HE WANTS TO CHANGE INTENSITY
 101	IF((IBUT.AND."007400).NE.0) CALL INTCHK(IBUT,INTENS)
C	  BUTTON 9 WAS HIT (MOVE WANTED)- CHECK IF WE ALREADY MOVING
C	  IF SO, THEN JUST KEEP ON MOVING
	IF(INTENS.LT.0.AND.MOVE.EQ.1) GOTO 100
C	  SEE IF WE SHOULD GO TO CONTINUOUS MODE
	IF(INTENS.GT.0.AND.MOVE.EQ.1) GOTO 103
	IF(INTENS.GT.0) GOTO 104
C	  WE NOW GO INTO 'MOVE' MODE
	MOVE=1
C	  DRAW VECTOR TO LAST POSITION
	CALL VECT(FLOAT(IX-LASTX),FLOAT(IY-LASTY),,IABS(INTENS))
	LASTX=IX
	LASTY=IY
	GOTO 100
C	  RETURN TO CONTINUOUS MODE
 103	CALL VECT(FLOAT(IX-LASTX),FLOAT(IY-LASTY),,-INTENS)
	LASTX=IX
	LASTY=IY
	GOTO 90
C
 104	DX=IX-LASTX
	DY=IY-LASTY
	IF(DX.EQ.0.) GOTO 105
	SLOPE=DY/DX
	DIS=AMAX0(ABS(DX),ABS(DY))**2
	SLOPE=SLOPE*DIS
	IF(SLOPE.GE.OSLOPE-.2.AND.SLOPE.LE.OSLOPE+.2) GOTO 100
	GOTO 110
 105	IF(ODX.EQ.0.) GOTO 100
	OSLOPE=999999.
 110	ODX=DX
	OSLOPE=SLOPE
	LASTX=IX
	LASTY=IY
	LINES=LINES+1
	CALL VECT(DX,DY,,INTENS)
C	  CHECK HOW MUCH ROOM IS LEFT
	CALL DPTR(I)
C	  CHECK FOR DANGER LIMIT
	IF(MAXBUF-I.LT.MINBUF) GOTO 200
	GOTO 100
C
C	  USER WISHES TO DO DIGITIZING POINT-BY-POINT
C
 150	WRITE(5,151)
 151	FORMAT(' Point digitizing mode',/,
     C		' Hit button 1 to switch to STREAM mode',/,
     C		' Hit button 3 to quit',/)
C	  INITIALIZE BUTTONS
	CALL DROUT("100000.OR.IDROUT(DUMMY))
 155	CALL DRIN(0)
C	  CALL GETGIN W/O WAITING SO WE CAN MOVE THE CURSOR A LITTLE
 160	CALL GETGIN(IX,IY,2,IERR)
	IF(IERR.NE.0) GOTO 160
	CALL CHANGE(1,FLOAT(IX),FLOAT(IY))
	IBUT=IDRIN(DUMMY)
C	  RESET BUTTONS
	CALL DRIN(0)
C	  CHECK IF HE WANTS TO QUIT
	IF((IBUT.AND.4).NE.0) GOTO 300
C	  HE MUST HIT BUTTON 13 TO START POINT MODE
	IF((IBUT.AND.1).NE.0) GOTO 20
C	  HE WANTS TO RETURN TO STREAM DIGITIZING
C	  CHECK IF INTENSITY CHANGE IS IN ORDER
	IF((IBUT.AND."7400).NE.0) CALL INTCHK(IBUT,INTENS)
C	  CHECK IF HE WANTS TO START DIGITIZING
 164	IF((IBUT.AND."100000).EQ.0) GOTO 160
	ISUBP=ISUBP+1
	CALL SUBP(ISUBP)
	CALL APNT(FLOAT(IX),FLOAT(IY),,-IABS(INTENS),-1)
	LASTX=IX
	LASTY=IY
C	  NOW GO INTO A POINT-DIGITIZING MODE
C	  THIS TIME WAIT FOR USER TO HIT BUTTON 16 ON LK-11
 170	CALL GETGIN(IX,IY,2,IERR)
C	  MOVE CURSOR
	CALL CHANGE(1,FLOAT(IX),FLOAT(IY))
	IF(IERR.NE.0) GOTO 170
	IBUT=IDRIN(DUMMY)
C	  WAIT FOR A BUTTON TO BE PRESSED
	IF(IBUT.EQ.0) GOTO 170
	CALL DRIN(0)
	IF((IBUT.AND.4).NE.0) GOTO 200
C	  CHECK IF HE WANTS TO CHANGE TO STREAM MODE
	IF((IBUT.AND.1).EQ.0) GOTO 180
	CALL ESUB
	GOTO 20
C	  SEE IF HE MERELY WANTS TO CHANGE INTENSITY
 180	IF((IBUT.AND."007400).NE.0) CALL INTCHK(IBUT,INTENS)
C	  SEE IF HE WANTS TO DIGITIZE
	IF(IBUT.GE.0) GOTO 170
	CALL VECT(FLOAT(IX-LASTX),FLOAT(IY-LASTY),,INTENS)
	LASTX=IX
	LASTY=IY
C	  CHECK TO SEE HOW MUCH ROOM LEFT
	LINES=LINES+1
	CALL DPTR(I)
C	  IF NOT MUCH ROOM LEFT - STOP HIM HERE
	IF(MAXBUF-I.GE.MINBUF) GOTO 170
C	  COMES HERE IF USER HIT BUTTON ON FUNBOX TO QUIT
 200	CALL ESUB
 300	CALL DPTR(I)
	LEFT=MAXBUF-I
	WRITE(5,310) LINES,LEFT
 310	FORMAT( 1X,I6,' lines so far. ',I5,' words left for display.',
     C		/,$,' Do you wish to continue digitizing? If so, ',
     C		'hit RETURN: ')
	READ(5,320) IANS
 320	FORMAT(A1)
	IF(IANS.EQ.'') GOTO 150
 400	WRITE(5,410)
 410	FORMAT($,' Enter filename under which to save: ')
	READ(5,420) LEN,FNAME
 420	FORMAT(Q,16A1)
	IF(LEN.EQ.0) STOP
C	  FIRST ERASE THE CURSOR
	CALL ERAS(1)
	CALL SAVE(FNAME)
	STOP
	END




	SUBROUTINE INTCHK(IBUT,INTENS)
C	  THIS SUBROUTINE CHECKS FOR INTENSITY CHANGES &
C	  CHANGES THE VALUES OF INTENS ACCORDINGLY
C	  ALSO CHANGES THE OUTPUT LIGHTS ON THE LK-11
C
	IF((IBUT.AND."400).EQ.0) GOTO 161
	INTENS=-IABS(INTENS)
	CALL DROUT("405.OR.(IDROUT(DUMMY).AND."100000))
	GOTO 164
 161	IF((IBUT.AND."1000).EQ.0) GOTO 162
	INTENS=2
	CALL DROUT("1005.OR.(IDROUT(DUMMY).AND."100000))
	GOTO 164
 162	IF((IBUT.AND."2000).EQ.0) GOTO 163
	INTENS=5
	CALL DROUT("2005.OR.(IDROUT(DUMMY).AND."100000))
	GOTO 164
 163	INTENS=8
	CALL DROUT("4005.OR.(IDROUT(DUMMY).AND."100000))
 164	RETURN
	END
 