;******************************* MODULE HEADER *******************************;
;*                                                                           *;
;* FILE: WpMsgMZ.asm                                                         *;
;*                                                                           *;
;* MACHINE: B20        LANGUAGE: ASSEMBLER  OS: BTOS                         *;
;*                                                                           *;
;* DESCRIPTION:                                                              *;
;*                                                                           *;
;* Editor message text.                                                      *;
;*                                                                           *;
;* HISTORY:                                                                  *;
;*                                                                           *;
;* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first) *;
;*                                                                           *;
;* 12/22/89 120F/03 T. Ball      / Added TooManyNewFiles, TooManyOldFiles    *;
;* 12/15/89 120F/02 T. Ball      / Modified cmrNotYesOrNo                    *;
;* 08/28/89 120C/00 P. Campbell  / Master -> Server, Server -> Service       *;
;* 06/05/89 120B/01 T. Ball      / Added cmrNotYesOrNo                       *;
;*                                                                           *;
;* TITLE:  BTOS SYSTEM SOFTWARE                                              *;
;*                                                                           *;
;*            PROPRIETARY PROGRAM MATERIAL                                   *;
;*                                                                           *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                *;
;*                                                                           *;
;* COPYRIGHT (C) 1980, 1989 CONVERGENT TECHNOLOGIES INC. ALL RIGHTS RESERVED *;
;* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED          *;
;* ************************************************************************* *;
;*                                                                           *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 *;
;*                                                                           *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           *;
;*                                                                           *;
;*                                                                           *;
;*************************** END OF MODULE HEADER ****************************;

; WpMsg.MZasm

$include(WpMsg.mdf)

DGroup group Const
assume ds: DGroup


;-----------------------------------------------
; ************** CMR DEFINITIONS **************
; NOTE: These are now alphabetized by cmr name.
;       Please keep them that way.  Thank you.
;-----------------------------------------------


%DefineCmr(MasterDown, 1, true, true, true,
~Unable to complete command:  server down~, ~~)%'

%DefineCmr(MismatchedQuote, 1, true, true, false,
~Mismatched quotes~, ~~)%'

%DefineCmr(NestingTooDeep, 1, true, true, false,
~Too many nested levels in block~, ~~)%'

%DefineCmr(NextNotLegal, 1, true, true, false,
~NEXT not valid~, ~~)%'

%DefineCmr(NoDirName, 1, true, true, false,
~Please fill in "Directory"~, ~~)%'

%DefineCmr(NoDocList, 1, true, true, false,
~Please fill in "File name(s)"~, ~~)%'

%DefineCmr(NoDocName, 1, true, true, false,
~Please fill in "File name"~, ~~)%'

%DefineCmr(NoFreeFh, 1, true, true, true,
~Too many files open; please Save~, ~~)%'

%DefineCmr(NoFromDocName, 1, true, true, false,
~Please fill in "Old file name"~, ~~)%'

%DefineCmr(NoMatch, 1, true, true, false,
~No match found for wildcard expression~, ~~)%'

%DefineCmr(NoNewDocName, 1, true, true, false,
~Please fill in "New file name"~, ~~)%'

%DefineCmr(NoOldDocName, 1, true, true, false,
~Please fill in "Old file name"~, ~~)%'

%DefineCmr(NoSelection, 1, true, true, false,
~Please make a selection~, ~~)%'

%DefineCmr(NoSubstMade, 1, true, false, false,
~No replacements made~, ~~)%'

%DefineCmr(NoSuchCmd, 1, true, true, true,
~No such command; press HELP for instructions~, ~~)%'

%DefineCmr(NoSuchDir, 1, true, true, false,
~There is no directory named | ~, ~<> <1>~)%'

%DefineCmr(NoSuchFile, 1, true, true, false,
~There is no file named | ~, ~<> <1>~)%'

%DefineCmr(NoSuchLine, 1, true, true, false,
~No such line~, ~~)%'

%DefineCmr(NoSuchNode, 1, true, true, false,
~There is no node named | ~, ~<> <1>~)%'

%DefineCmr(NoSuchVol, 1, true, true, false,
~There is no volume named | ~, ~<> <1>~)%'

%DefineCmr(NotFound, 1, true, true, false,
~Not found~, ~~)%'

%DefineCmr(Nothing, 1, true, false, false,
~ | ~, ~<1> <>~)%'

%DefineCmr(NothingToEnd, 1, true, true, false,
~Please fill in "Block end"~, ~~)%'

%DefineCmr(NothingToFind, 1, true, true, false,
~Please fill in "Search for"~, ~~)%'

%DefineCmr(NothingToGoto, 1, true, true, false,
~Please fill in "Line Number"~, ~~)%'

%DefineCmr(NothingToSearch1, 1, true, true, false,
~Please fill in "Search string (1)"~, ~~)%'

%DefineCmr(NothingToSearch2, 1, true, true, false,
~Please fill in "Search string (2)"~, ~~)%'

%DefineCmr(NothingToStart, 1, true, true, false,
~Please fill in "Block start"~, ~~)%'

%DefineCmr(NoToDocName, 1, true, true, false,
~Please fill in "New file name"~, ~~)%'

%DefineCmr(NotRedoable, 1, true, true, false,
~REDO not valid~, ~~)%'

%DefineCmr(NotYesOrNo, 1, true, true, false,
~Response is neither Yes or No:  ~, ~<1>~)%'

%DefineCmr(NoUniqueMatch, 1, true, true, false,
~ does not match a unique file~, ~<1>~)%'

%DefineCmr(NoVolName, 1, true, true, false,
~Please fill in "Volume"~, ~~)%'

%DefineCmr(NoZoom, 1, true, true, false,
~Cannot ZOOM on this type of workstation~, ~~)%'

%DefineCmr(OneSubstMade, 1, true, false, false,
~1 replacement made~, ~~)%'

%DefineCmr(Renaming, 1, true, false, false,
~Renaming ...~, ~~)%'

%DefineCmr(ReplayDone, 1, true, false, false,
~Recovery complete~, ~~)%'

%DefineCmr(ReplaySuspended, 1, true, true, false,
~Recovery suspended; press GO to continue, CANCEL to stop recovery~, ~~)%'

%DefineCmr(SaveDone, 1, true, false, false,
~Save complete~, ~~)%'

%DefineCmr(Saving, 1, true, false, false,
~Saving ...~, ~~)%'

%DefineCmr(ScanningDir, 2, true, false, false,
~Searching directory | ...
                 (Press CANCEL to interrupt)~, ~<> <1>~)%'

%DefineCmr(ScanningVol, 2, true, false, false,
~Searching volume | ...
                 (Press CANCEL to interrupt)~, ~<> <1>~)%'

%DefineCmr(Searching, 1, true, false, false,
~Searching ...  (Press CANCEL to interrupt)~, ~~)%'

%DefineCmr(SearchingForReplace, 1, true, false, false,
~Searching ...~, ~~)%'

%DefineCmr(Substituting, 1, true, false, false,
~Replacing ...~, ~~)%'

%DefineCmr(SubstMade, 1, true, false, false,
~ replacements made~, ~<1>~)%'

%DefineCmr(TooManyKeys, 1, true, true, false,
~Too many keys specified~, ~~)%'

%DefineCmr(TooManyNewFiles, 1, true, true, false,
~Too many new file names specified~, ~~)%'

%DefineCmr(TooManyOldFiles, 1, true, true, false,
~Too many old file names specified~, ~~)%'

%DefineCmr(TooManyWindows, 1, true, true, false,
~Too many windows~, ~~)%'

%DefineCmr(TsBad, 1, true, true, false,
~Cannot recover; typescript not valid or different version~, ~~)%'

%DefineCmr(TsInUse, 1, true, true, false,
~There is already a user named ~, ~~)%'

%DefineCmr(TsInUseEnd, 1, true, true, false,
~ ~, ~~)%'

%DefineCmr(TsNeedAws, 1, true, true, false,
~Can only recover on an AWS~, ~~)%'

%DefineCmr(TsNeedIws, 1, true, true, false,
~Can only recover on an IWS~, ~~)%'

%DefineCmr(VolNotMounted, 1, true, true, false,
~Volume | is not mounted~, ~<> <1>~)%'

%DefineCmr(WriteProtected, 1, true, true, false,
~File | cannot be changed~, ~<> <1>~)%'


end
