/*
 * Convergent Technologies
 *
 * FILE: clock.c
 *
 * 2.1 C/CTOS
 * Apr  2, 1986  MEC  Created
 *
 * Create a child process, which will refresh the date and time
 * in frame 1 (the top two lines of the screen).
 */



#include <stdio.h>



#define CBSTACK    2048			/* Size of new stacks          */
#define FALSE      0
#define TRUE       0xFF
#define loword(x)  ((short *)(&x))[0]	/* Extract low word of ptr     */
#define hiword(x)  ((short *)(&x))[1]	/* Extract high word of ptr    */
#define uchar      unsigned char
#define uint       unsigned int



typedef struct
{
	uint	year;
	uchar	month;
	uchar	date;
	uchar	day;
	uchar	hour;
	uchar	minute;
	uchar	second;
} EDT;

typedef struct
{
	int	(*pEntry)();	/* Memory address to begin execution   */
	uint	saData;		/* Segment base address of DS          */
	uint	saExtra;	/* Segment base address of ES          */
	uint	saStack;	/* Segment base address of SS          */
	uint	oStackInit;	/* Initial offset into SS              */
	uchar	priority;	/* Process priority                    */
	uchar	fsys;		/* True if creating a system process   */
	uint	respExch;	/* Default response exchange           */
	uchar	fdebug;		/* True if entering debugger           */
} PCB;



extern	uchar	fDevelopement;	/* Forces CheckErc to call debugger    */



int	Timer();		/* Function executed by child process  */



/*
 * M A I N
 *
 * Fork off the timer process, then do some work.
 */
main()
{
	auto	long	i;
	static	char	rgbstack[CBSTACK];

	/*
	 * Turn on fDevelopement.  This causes CheckErc to
	 * enter the debugger instead of calling ErrorExit.
	 */
	fDevelopement = TRUE;

	/*
	 * Clear screen, turn off cursor
	 */
	setbuf(stdout, NULL);
	printf("\377C%c%c\377EF\377VF", 0, 0);

	/*
	 * Create the child process
	 */
	CreateChild(&Timer, &rgbstack[CBSTACK]);

	/*
	 * Now do some work while the child process runs
	 */
	for (i = 0; i < 200; i++)
	{
		printf("%ld\t%ld\t%ld\n", i, i*i, i*i*i);
	}
}



/*
 * C R E A T E C H I L D
 *
 * Create a child process with a given entry point and stack.
 *
 * The Process Control Block is set up as follows:
 *
 * pEntry is the address of the procedure that the
 * child process will enter.
 *
 * saData must equal the selector of DGroup.
 * saExtra can be anything.
 * saStack must equal the selector of DGroup in order
 * for CTOS Object Module Procedures (such as byte
 * streams) to work.  In particular, this means the
 * stack cannot come from AllocMemorySL() or malloc()
 * (if you want to use CTOS Object Module Procedures).
 *
 * oStackInit is the top of the stack (not the bottom!)
 * priority is set to a reasonable default.
 * fsys must be FALSE in user programs.
 * respExch must be a uniquely allocated exchange.
 * fdebug is generally FALSE.
 */

CreateChild(pProc, pStackEnd)
int	(*pProc)();
char *	pStackEnd;
{
	auto	PCB	pcb;	/* A process control block             */
	auto	char *	pJunk;

	/*
	 * Verify that the child's stack is in DGroup.
	 */
	pJunk = &pJunk;
	if (hiword(pStackEnd) != hiword(pJunk))
	{
		fprintf(stderr, "CreateChild: Stack not in DGroup\n");
		CheckErc(8);
	}

	/*
	 * Set up the Process Control Block for the child.
	 */
	pcb.pEntry     = pProc;
	pcb.saData     = hiword(pStackEnd);
	pcb.saExtra    = hiword(pStackEnd);
	pcb.saStack    = hiword(pStackEnd);
	pcb.oStackInit = loword(pStackEnd);
	pcb.priority   = 0x78;
	pcb.fsys       = FALSE;
	CheckErc(AllocExch(&pcb.respExch));
	pcb.fdebug     = FALSE;

	/*
	 * Create the process
	 */
	CheckErc(CreateProcess(&pcb));
}



/*
 * T I M E R
 *
 * Print the date and time in Frame 0 of the video.
 * Warning: must avoid making stdio calls or Ctos calls
 * that could also be made by the main process, unless
 * these calls are reentrant.  (CheckErc and sprintf
 * are reentrant).
 */

char *rgWeek[]  = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };
char *rgMonth[] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun",
		    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };

Timer()
{
	EDT	expDateTime;
	long	qDateTime;
	char	rgbFormatDateTime[32];

	CheckErc(ResetFrame(1));

	for (;;)
	{
		CheckErc(GetDateTime(&qDateTime));
		CheckErc(ExpandDateTime(qDateTime, &expDateTime));
		sprintf(rgbFormatDateTime, "%s %s %2d %02d:%02d:%02d PST %4d",
			rgWeek[expDateTime.day], rgMonth[expDateTime.month],
			expDateTime.date,        expDateTime.hour,
			expDateTime.minute,      expDateTime.second,
			expDateTime.year);
		CheckErc(PutFrameChars(1, 0, 0, rgbFormatDateTime, 28));
		CheckErc(Delay(10));
	}
}
