/*
	Copyright 1987-1990 XVT Software Inc. All rights reserved.
	May be used freely by licensed and registered users of XVT.
	May be distributed in source form only when embedded in an
	XVT user's application.

	Example XVT application that shows how to print.
*/
#include "xvt.h"							/* standard XVT header */
#include "xvtmenu.h"						/* standard XVT menu tags */

#if XVTCC == MWCCC
pragma Calling_convention(CTOS_CALLING_CONVENTIONS);
#endif

#ifdef PROTO
/**STATICFCN**/ void do_update(WINDOW);
/**STATICFCN**/ void do_menu(MENU_TAG);
/**STATICFCN**/ BOOLEAN XVTENTRY print_document(long pages);
/**STATICFCN**/ void print_band(WINDOW win, int page);
/**STATICFCN**/ void draw_shapes(int page, int width, int height);
/**STATICFCN**/ void draw_shape_set(int xorg, int yorg, int width, int height,
  char *pen_label, char *brush_label);
#else
/**STATICFCN**/ void do_update();
/**STATICFCN**/ void do_menu();
/**STATICFCN**/ BOOLEAN XVTENTRY print_document();
/**STATICFCN**/ void print_band();
/**STATICFCN**/ void draw_shapes();
/**STATICFCN**/ void draw_shape_set();
#endif

APPL_SETUP appl_setup;

static PRINT_RCD *print_rcd;		/* print record */
static int unit;					/* approx. 1 point */
#define GAP (4 * unit)				/* GAP between shapes */

/*
	Function called by XVT to initialize application.
*/
BOOLEAN XVTENTRY appl_init BTCENTRY () 
{
	int size;

	print_rcd = get_print_rcd(&size);
	menu_enable(M_FILE_PG_SETUP, TRUE);
	menu_enable(M_FILE_PRINT, TRUE);
	return(TRUE);
}

/*
	Function to handle update events.
*/
#ifdef FPROTO
/**static**/ void do_update(WINDOW win)
#else
/**static**/ void do_update(win)
WINDOW win;
#endif
{
	RCT rct;
	DRAW_CTOOLS t;

	get_client_rect(win, &rct);
	get_normal_ctools(&t);
	t.pen = hollow_cpen;
	set_draw_ctools(&t);
	draw_rect(&rct);
	draw_text(20, 50, "Hello World!", -1);
}

/*
	Function to draw a set of shapes.
*/
#ifdef FPROTO
/**static**/ void draw_shape_set(int xorg, int yorg, int width, int height,
  char *pen_label, char *brush_label)
#else
/**static**/ void draw_shape_set(xorg, yorg, width, height, pen_label, brush_label)
int xorg;								/* x origin */
int yorg;								/* y origin */
int width;								/* width of area for set */
int height;								/* height */
char *pen_label;						/* pen label */
char *brush_label;						/* brush label */
#endif
{
	int leading, ascent, descent, xincr, yincr, text_height, i, j, x, y;
	char buf[100];
	RCT rct;
	PNT pnt, p[5];
	DISPLAY_METRICS dm;

/* try to move the origin away from the top left corner a little bit */
	xorg = xorg + 8;
	yorg = yorg + 8;
/* Try to move the right margin in a little bit. 	*/
	width = width - 8;
	
	get_font_metrics(&leading, &ascent, &descent);
	text_height = leading + ascent + descent;
	sprintf(buf,"%s Pen", pen_label);
	draw_text(xorg , yorg + leading + ascent, buf, -1);
	sprintf(buf,"%s Brush", brush_label);
	draw_text(xorg , yorg + leading + ascent + 16, buf, -1);
/* 	Try to adjust the y coordinate down so that shapes don't overlap text. 
	Thus the - 40 here */
	yorg += (text_height * 3) - 40;
	xincr = width / 2;
	yincr = (height - text_height) / 5;
	for (i = 0; i < 2; i++)
		for (j = 0; j < 5 ; j++) {
			x = xorg + GAP + i * xincr;
			y = yorg + GAP + j * yincr;
			set_rect(&rct, x, y, x + xincr - (3 * GAP) / 2,
			  y + yincr - (3 * GAP) / 2);
			switch (i * 5 + j) {
		
/* This switch orginally printed 5 print items per column.  The column headings were munged and the print shapes overlapped. I have removed the first and last shapes to make the column headings readable and because icons and Pies are not supported for XVT/ch - jwiii 1/13 */

			case 0:
			/* Print the icon number in xvt/ch other wise get the icon from
			the resource file and print it. This is commented out because it doesn't seem to fit on the page and works correctly anyway 1/13  Jwiii 
				draw_icon(rct.left + (rct.right - rct.left) / 3, rct.top, 100);    */
				break;
			case 1:
				p[0].h = rct.left;
				p[0].v = (rct.top + rct.bottom) / 2;
				p[1].h = (rct.left + rct.right) / 2;
				p[1].v = rct.top;
				p[2].h = rct.right;
				p[2].v = rct.bottom;
				draw_polygon(p, 3);
				break;
			case 2:
				pnt.h = rct.left;
				pnt.v = rct.top;
				move_to(pnt);
				pnt.h = rct.right;
				pnt.v = rct.bottom;
				draw_aline(pnt, TRUE, TRUE);
				break;
			case 3:
				p[0].h = rct.left;
				p[0].v = (rct.top + rct.bottom) / 2;
				p[1].h = (rct.left + rct.right) / 2;
				p[1].v = rct.top;
				p[2].h = rct.right;
				p[2].v = rct.bottom;
				draw_polyline(p, 3);
				break;
			case 4:
				pnt.h = rct.left;
				pnt.v = rct.top;
				move_to(pnt);
				pnt.h = rct.right;
				pnt.v = rct.bottom;
				draw_line(pnt);
				break;
			case 5:
/*  All these shapes are created equal a for XVT/CH Dropping Pie for page space
				draw_pie(&rct, rct.left, (rct.top + rct.bottom) / 2,
				  rct.right, rct.top); */
				break;
			case 6:
				draw_roundrect(&rct, 2 * GAP, 2 * GAP);
				break;
			case 7:
				draw_oval(&rct);
				break;
			case 8:
				draw_arc(&rct, rct.left, (rct.top + rct.bottom) / 2,
				  rct.right, rct.top);
				break;
			case 9:
				draw_rect(&rct);
				break;
			}
		}
}

/*
	Function to draw shapes.
*/
#ifdef FPROTO
/**static**/ void draw_shapes(int page, int width, int height)
#else
/**static**/ void draw_shapes(page, width, height)
int page;								/* page number */
int width;								/* width of print area */
int height;								/* height */
#endif
{
	DRAW_CTOOLS t;
	int xincr, yincr, npen, nb, nbrush;
	PNT p;
	RCT rct;
	static struct {
		CPEN pen;
		char *label;
	} pens[4] = {
		{{0,		PAT_HOLLOW,		P_SOLID,	COLOR_BLACK},	"Hollow"},
		{{0,		PAT_RUBBER,		P_SOLID,	COLOR_BLACK},	"Rubber"},
		{{0,		PAT_SOLID,		P_SOLID,	COLOR_BLACK},	"Thin"},
		{{0,		PAT_SOLID,		P_SOLID,	COLOR_BLACK},	"Thick"}
		/* above widths (0) to be filled in with code -- see below */
	};
	
	static struct {
		CBRUSH brush;
		char *label;
	} brushes[12] = {
		{{PAT_HOLLOW,		COLOR_BLACK},	"Hollow"},
		{{PAT_SOLID,		COLOR_BLACK},	"Solid"},
		{{PAT_DIAGCROSS,	COLOR_BLACK},	"Diag Cross"},
		{{PAT_SOLID,		COLOR_WHITE},	"White"},
		{{PAT_FDIAG,		COLOR_BLACK},	"Fwd Diag"},
		{{PAT_CROSS,		COLOR_BLACK},	"Cross"},     /* not supported */
		{{PAT_SOLID,		COLOR_LTGRAY},	"Lt Gray"},
		{{PAT_HORZ,			COLOR_BLACK},	"Horz"}, /* not supported */
		{{PAT_VERT,			COLOR_BLACK},	"Vert"}, /* not supported */
		{{PAT_BDIAG,		COLOR_BLACK},	"Bck Diag"},  /* not supported */
		{{PAT_SOLID,		COLOR_GRAY},	"Gray"},
		{{PAT_SOLID,		COLOR_DKGRAY},	"Dk Gray"}
	};
/* Width of 1 only is supported with Ctos */
	pens[0].pen.width = unit;
	pens[1].pen.width = unit;
	pens[2].pen.width = unit;
	pens[3].pen.width = 4 * unit;
	get_normal_ctools(&t);
	set_draw_ctools(&t);
	set_rect(&rct, 0, 0, width, height);
/*	draw_rect(&rct);  */
	xincr = width / 4;
	yincr = height / 4;
	
	/* Here I'm trying to move the initial text and shape away from each 
	other by adjusting the v coordiantes down by 8. */
	
/*	for (p.h = 8; p.h < width; p.h += xincr) {
		p.v = 8;
		move_to(p);
		p.v = height + 8;
		draw_line(p);
	}
	for (p.v = 0; p.v < height + 8; p.v += yincr) {
		p.h = 0;
		move_to(p);
		p.h = width;
		draw_line(p);
	}
*/
	t.font = small_font;
	t.opaque_text = TRUE;
	for (npen = 0; npen < 4; npen++)
		for (nb = 0; nb < 4; nb++) {
			t.pen = pens[npen].pen;
			t.brush = brushes[nb].brush;
			set_draw_ctools(&t);
			draw_shape_set(npen * xincr , nb * yincr, xincr, yincr,
			  pens[npen].label, brushes[nb].label);
		}
}

/*
	Function to print a band.
*/
#ifdef FPROTO
/**static**/ void print_band(WINDOW win, int page)
#else
/**static**/ void print_band(win, page)
WINDOW win;								/* print window */
int page;								/* current page */
#endif
{
	DRAW_CTOOLS t;
	DISPLAY_METRICS dm;
	RCT rct;
	char buf[100];
	int leading, ascent, descent, y, line;

	get_printer_metrics(print_rcd, &dm);

	unit = max((dm.h_res + dm.v_res) / 144, 1); /* 1 point worth of pixels */
	set_cur_window(win);
	if (page <= 1)
		draw_shapes(page, dm.width, dm.height);
	else {
		get_normal_ctools(&t);
		t.font = small_font;
		t.brush.pat = PAT_HOLLOW;
		set_draw_ctools(&t);
		get_font_metrics(&leading, &ascent, &descent);
		set_rect(&rct, 0, 0, dm.width, dm.height);
		draw_rect(&rct);
		for (y = leading + ascent, line = 1; y <= dm.height - descent;
		  y += leading + ascent + descent, line++) {
			set_rect(&rct, 0, y - ascent, dm.width, y + descent);
			if (needs_update(win, &rct)) {
				sprintf(buf, "This is page %d, line %d.", page, line);
				draw_text(100, y, buf, -1);
			}
		}
	}
}

/*
	Function to print a band.
*/
void print_simple_page(WINDOW win, int page, RCT *pBand)
{
static fFoo = FALSE;
	int iLine = 1, cLines;
	DISPLAY_METRICS dm;
	int wxOneInch, wyOneInch;
	int wLeading, wAscent, wDescent;
	int wLineHeight;
	RCT rct;
	char buf[100];

	get_printer_metrics(print_rcd, &dm);
	wxOneInch = dm.h_res;
	wyOneInch = dm.v_res;
	

	get_font_metrics(&wLeading, &wAscent, &wDescent);
	wLineHeight = wLeading + wAscent + wDescent;

	if(!fFoo) {
		fFoo = TRUE;

		/* this is a test to see where the dm.v_res is * /

	/* This should be " below line */
		set_rect(&rct, wxOneInch, wyOneInch - (wyOneInch / 2), 
	               dm.width-(wxOneInch / 2), dm.height);
		draw_rect(&rct);
			sprintf(buf, " inch below");
			draw_text(dm.width - wxOneInch - get_text_width(buf, 12), wyOneInch - (wyOneInch / 2) +(iLine*wLineHeight) , buf, -1);

	/* This should be 3/4" below line */

			set_rect(&rct, wxOneInch, wyOneInch - (wyOneInch / 4), 
	               dm.width-(wxOneInch / 2), dm.height);
		draw_rect(&rct);
			sprintf(buf, "3/4 below");
			draw_text(dm.width - wxOneInch - get_text_width(buf, 9), wyOneInch - (wyOneInch / 4) +(iLine*wLineHeight) , buf, -1);
		
	/* This should be 1" below line */

		set_rect(&rct, wxOneInch, wyOneInch , 
	            dm.width-(wxOneInch), dm.height);
    		sprintf(buf, "1 inch below");
			draw_text(dm.width - wxOneInch - get_text_width(buf, 12), wyOneInch +(iLine*wLineHeight) , buf, -1);

		draw_rect(&rct);

		for (iLine = 1; iLine < 56; iLine++) {
			sprintf(buf, "Line %d  ABCDEFGHIJKLMNOPQRSTUVWXYZ", iLine);
			draw_text(wxOneInch, wyOneInch+(iLine*wLineHeight), buf, -1);
			}
	
	} /* if !fFoo */
	else {
		fFoo = FALSE;
		/* get the smaller of the two rectangles. */
		cLines = (pBand->bottom - pBand->top) > dm.height ? dm.height : 
					(pBand->bottom - pBand->top);
		
		cLines /= wLineHeight;
		
		for (iLine = 1; iLine < cLines; iLine++) {
			sprintf(buf, "Line %d  ABCDEFGHIJKLMNOPQRSTUVWXYZ", iLine);
			draw_text(wxOneInch, (iLine - 1)*wLineHeight, buf, -1);
			}
		
		}

}

/*
	Function to print a document.
*/
#ifdef FPROTO
/**static**/ BOOLEAN XVTENTRY print_document(long pages)
#else
/**static**/ BOOLEAN XVTENTRY print_document(pages)
long pages;								/* number of pages to print */
#endif
{
	WINDOW win;
	int page;
	char buf[100];
	DRAW_CTOOLS t;
	DISPLAY_METRICS dm;
	int wxPageNum, wyPageNum;
	int wLeading, wAscent, wDescent;
	RCT *pBandRect;

	if (print_rcd == NULL ||
	  (win = new_print_window(print_rcd, "Document")) == NULL_WIN)
		return(TRUE); /* user cancelled -- no actual error */
	for (page = 1; page <= (int)pages; page++) {
		set_cur_window(win);
		if (start_page(print_rcd)) {

			sprintf(buf, "Page %d   ", page);
			get_normal_ctools(&t);
			t.opaque_text = TRUE;
			t.brush.pat = PAT_HOLLOW;
			set_draw_ctools(&t);

			get_printer_metrics(print_rcd, &dm);
			wxPageNum = dm.width / 2;
			/* off the bottom of the page */
			wyPageNum = dm.height + 24;
			draw_text(wxPageNum, wyPageNum, buf, -1); 

			while ((pBandRect = next_band()) != NULL)
				switch(page % 4) {
					case 0:
						print_band(win, page); 
						break;
					case 1:
						print_band(win, page); 
						break;
					case 2:
						print_simple_page(win, page, pBandRect);
						break;
					case 3:
						print_simple_page(win, page, pBandRect);
						break;
					}

			if (!finish_page(print_rcd))
				break;
			}
		else
			break;
		}
	close_print_window(win, print_rcd);
	return(xvterrno == ERR_NONE);
}

/*
	Function to handle menu commands.
*/
#ifdef FPROTO
/**static**/ void do_menu(MENU_TAG cmd)
#else
/**static**/ void do_menu(cmd)
MENU_TAG cmd;							/* tag identifying menu item */
#endif
{
	switch (cmd) {
	case M_FILE_NEW:
		break;
	case M_FILE_PG_SETUP:
		page_setup_dlg(print_rcd);
		break;
	case M_FILE_PRINT:
		if (!start_print_thread(print_document, 4L))
			error("Printing failed.");
		break;
	case M_FILE_QUIT:
		terminate();
		break;
	}
}

/*
	Main application entry point.
*/
void XVTENTRY main_event BTCENTRY (win, ep) 
WINDOW win;								/* window receiving event, if any */
EVENT *ep;								/* pointer to event structure */
{
	switch (ep->type) {
	case E_MOUSE_DOWN:
		break;
	case E_MOUSE_UP:
		break;
	case E_MOUSE_MOVE:
		break;
	case E_MOUSE_DBL:
		break;
	case E_CHAR:
		break;
	case E_UPDATE:
		do_update(win);
		break;
	case E_ACTIVATE:
		break;
	case E_KILL_WINDOW:
		break;
	case E_VSCROLL:
		break;
	case E_HSCROLL:
		break;
	case E_COMMAND:
		do_menu(ep->v.cmd.tag);
		break;
	case E_CLOSE:
		close_window(win);
		break;
	case E_SIZE:
		break;
	case E_FONT:
		break;
	case E_QUIT:
		if (ep->v.query)
			quit_OK();
		else
			terminate();
		break;
	case E_CONTROL:
		break;
	}
}

/*
	Function called by XVT just before init.
*/
void XVTENTRY appl_setup_init BTCENTRY () 
{
appl_setup.menu_bar_ID = 0;
appl_setup.about_box_ID = 0;
appl_setup.appl_name = "Print";
appl_setup.win_type = W_DOC;
appl_setup.ctl_size = TRUE;
appl_setup.ctl_vscroll = FALSE;
appl_setup.ctl_hscroll = FALSE;
appl_setup.ctl_close = TRUE;
appl_setup.font_menu = TRUE;
appl_setup.style_menu = TRUE;
}

/*
	Function called by XVT just before terminating application.
*/
void XVTENTRY appl_cleanup BTCENTRY () 
{
	if (print_rcd != NULL)
		free_print_rcd(print_rcd);
}
