/*******************************************************************************
*  Copyright 1985 - 1990 by Advanced Programming Institute, Ltd.               *
*  All rights reserved.  May not be reproduced or distributed, in printed or   *
*  electronic form, without permission of Advanced Programming Institute, Ltd. *
*  May not be distributed as object code, separately or linked with other      *
*  object modules, without permission.                                         *
*******************************************************************************/



#ifdef DMALLOC

typedef unsigned size_t;
typedef short   BOOLEAN;

void           *vxvt_malloc (char *, int, size_t);
void            vxvt_free (char *, int, void *);
void           *vxvt_realloc (char *, int, void *, size_t);
long            vgalloc (char *, int, long);
long            vgrealloc (char *, int, long, long);
BOOLEAN         vgfree (char *, int, long);

#define xvt_malloc(size) vxvt_malloc(__FILE__, __LINE__, size)
#define xvt_free(ptr) vxvt_free(__FILE__, __LINE__, ptr)
#define xvt_realloc(ptr, size) vxvt_realloc(__FILE__, __LINE__, ptr, size)
#define galloc(size) vgalloc(__FILE__, __LINE__, size)
#define gfree(h) vgfree(__FILE__, __LINE__, h)
#define grealloc(h, newsize) vgrealloc(__FILE__, __LINE__, h, newsize)

#else				       /* not DMALLOC */

#ifdef PROTO
void             XVTENTRY xvt_free (char *);
char           * XVTENTRY xvt_malloc (size_t);
char           * XVTENTRY xvt_realloc (char *, size_t);

#else
void             XVTENTRY xvt_free ();
char           * XVTENTRY xvt_malloc ();
char           * XVTENTRY xvt_realloc ();

#endif
#endif				       /* DMALLOC */
