/*****************************  MODULE HEADER  *******************************/
/*                                                                           */
/*                                                                           */
/*  MACHINE:                LANGUAGE:  Metaware C            OS: CTOS        */
/*                                                                           */
/*  Quicksort.c                                                              */
/*                                                                           */
/*  Standard Software quicksort procedure.                                   */
/*                                                                           */
/*  HISTORY:                                                                 */
/*  --------                                                                 */
/*                                                                           */
/*  MM/DD/YY  VVVV/MM  PROGRAMMER    /  DESCRIPTION                          */
/*                                                                           */
/*  11/09/90  121E.00  P. Johansson  /  Created.                             */
/*                                                                           */
/*                    PROPRIETARY  PROGRAM  MATERIAL                         */
/*                                                                           */
/*  THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO         */
/*  BE REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM       */
/*  LICENSE OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF          */
/*  UNISYS CORPORATION, DETROIT, MICHIGAN 48232, USA.                        */
/*                                                                           */
/*  COPYRIGHT (C) 1990 UNISYS CORPORATION. ALL RIGHTS RESERVED               */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*  UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE         */
/*  AND RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION. HOWEVER,  */
/*  NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY       */
/*  CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS     */
/*  OF PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO     */
/*  WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                */
/*                                                                           */
/*  THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE     */
/*  WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE       */
/*  JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                          */
/*                                                                           */
/**************************  END OF MODULE HEADER  ***************************/

#ifdef debug
#define private
#else
#define private static
#endif

/* Standard C library macros and functions invoked by this module */

pragma Off(List);
#include <intel80X86.h>
pragma Pop(List);

pragma Calling_convention(_CALLEE_POPS_STACK);

/* External CTOS and CTOS Toolkit functions invoked by this module */

#define NlsCollate
#define ULCmpB

pragma Off(List);
#include <ctoslib.h>
pragma Pop(List);

/* Function prototypes defined before the functions themselves are declared */

Boolean greater_than(char key1[], char key2[]);

pragma Page(1);
/*-----------------------------------------------------------------------------
 A partition-exchange sort implemented recursively (aka "Quicksort" per C.A.R.
 Hoare) which accepts as inputs an array of pointers to self-descriptive
 character strings and the count of elements in the array.  When a sublist to
 be sorted is less than the parameter M, a simple insertion sort is used. */

#define M 6

void quicksort(char **key, unsigned n) {

   signed i, j;
   char *pivot_key;

   if (n <= M)
      for (j = 1; j < n; j++) {
         pivot_key = key[j];
         for (i = j - 1; i >= 0 && greater_than(key[i], pivot_key); i--) {
            key[i + 1] = key[i];
         }
         key[i + 1] = pivot_key;
      }
   else {
      i = 0;
      j = n - 1;
      pivot_key = key[0];
      while (TRUE) {
right:   while (j >= i && greater_than(key[j], pivot_key))
            j--;
         if (j <= i) {
            key[i] = pivot_key;
            goto pass_complete;
         } else
            key[i++] = key[j];

left:    while (i <= j && greater_than(pivot_key, key[i]))
            i++;
         if (j <= i) {
            key[j] = pivot_key;
            i = j;
            goto pass_complete;
         } else
            key[j--] = key[i];
      }
pass_complete:
      if (i > 1)
         quicksort(key, i);
      if (n - (i + 1) > 1)
         quicksort(key + (i + 1), n - (i + 1));
   }

}

pragma Page(1);
/*-----------------------------------------------------------------------------
 Compare two self-describing strings to determine if the first is lexically
 greater than the second.  If possible, use NLS operations to account for
 differences in collating sequences.  NlsCollate returns zero, one and two for
 the less than, equal and greater than relationships, respectively.  In the
 case of NLS equality, defer to the secondary field (string "priority") to
 establish the collating sequence.  If NLS services are not available, use the
 CTOS primitive ULCmpB function. */

private Boolean greater_than(char key1[], char key2[]) {

   char nls_priority, nls_order;
   unsigned i;

   if (NlsCollate(NULL, &key1[1], key1[0], &key2[1], key2[0], &nls_order,
                  &nls_priority) == ercOK)
      if (nls_order != 1)
         return(nls_order == 2);
      else
         return(nls_priority == 2);
   else {
      i = ULCmpB(&key1[1], &key2[1], (key1[0] < key2[0]) ? key1[0] : key2[0]);
      if (i == 0xFFFF)
         return(key1[0] > key2[0]);
      else
         return(key1[i + 1] > key2[i + 1]);
   }

}
