# tail -- print the last +n lines of file list, default 10

BEGIN {
		# set maxlines
		if (length(ARGV[2]) > 0)
			maxlines = int(ARGV[2])
		else
			maxlines = 10
		ARGV[2] = ""

		# set log file -- if not specified, send to screen
		if (length(ARGV[3]) > 0) {
			logfile = ARGV[3]
			printf ("Printing to %s ... ", logfile)
			fLog++;
		}
		else
			logfile = "[vid]"
		ARGV[3] = ""

		if (ARGC > 4)
				fmulti = 1

		# main loop
		for (i = 1; i < ARGC; i++) {
			# skip null parameters from above
			if (length(ARGV[i]) == 0)
				continue

			# check if we can access the file by reading first line
			if ((err = (getline x < ARGV[i])) < 0) {
				printf("error accessing %s\n", ARGV[i])
				continue
			}
			if (fmulti)
				printf("%s:\n\n", ARGV[i]) >logfile
			if (err == 0)						# if zero length file
				continue

			# store lines in circular buffer
			do {
				nlines++
				buf[(nlines % maxlines) + 1] = x
			} while ((erc = (getline x < ARGV[i])) > 0)

			# print circular buffer contents
			start = (nlines % maxlines) + 2;
			if (start > maxlines)
				start = 1;
			for (j = start; j <= maxlines; j++)
				print buf[j] >logfile
			for (j = 1; j < start; j++)
				print buf[j] >logfile

			if (fmulti)
				print >logfile					# print newline
		}
		if (fLog)
			print "done."
}